/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers;

import com.pixelmonmod.pixelmon.api.data.PixelmonDataSerializers;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.ribbon.Ribbon;
import com.pixelmonmod.pixelmon.api.storage.PokemonStorage;
import com.pixelmonmod.pixelmon.api.storage.StoragePosition;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.comm.packetHandlers.clientStorage.newStorage.ClientSetPacket;
import java.util.UUID;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class SetDisplayRibbonPacket
extends AbstractPixelmonPacket {
    private StoragePosition position;
    private UUID pokemonUUID;
    private Ribbon ribbon;

    public SetDisplayRibbonPacket() {
        super(PacketDirection.PLAY_SERVER, true);
    }

    public SetDisplayRibbonPacket(StoragePosition position, UUID pokemonUUID, Ribbon ribbon) {
        super(PacketDirection.PLAY_SERVER, true);
        this.position = position;
        this.pokemonUUID = pokemonUUID;
        this.ribbon = ribbon;
    }

    @Override
    public void decode(PacketBuffer buffer) {
        this.position = new StoragePosition(buffer.readShort(), buffer.readByte());
        this.pokemonUUID = new UUID(buffer.readLong(), buffer.readLong());
        this.ribbon = (Ribbon)PixelmonDataSerializers.RIBBON_TYPE.func_187159_a(buffer);
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.writeShort(this.position.box);
        buffer.writeByte(this.position.order);
        buffer.writeLong(this.pokemonUUID.getMostSignificantBits());
        buffer.writeLong(this.pokemonUUID.getLeastSignificantBits());
        PixelmonDataSerializers.RIBBON_TYPE.func_187160_a(buffer, (Object)this.ribbon);
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        ServerPlayerEntity player = context.getSender();
        PokemonStorage storage = this.position.box == -1 ? StorageProxy.getParty(player) : StorageProxy.getPCForPlayer(player);
        Pokemon pokemon = storage.get(this.position);
        if (pokemon == null || !pokemon.getUUID().equals(this.pokemonUUID)) {
            return;
        }
        pokemon.setDisplayedRibbon(this.ribbon);
        NetworkHelper.sendPacket(new ClientSetPacket(storage, this.position, pokemon, EnumUpdateType.Ribbons), player);
    }
}

