/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers;

import com.pixelmonmod.pixelmon.CommonProxy;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.comm.packetHandlers.QueryResourceLocationResult;
import java.util.UUID;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class QueryResourceLocationPacket
extends AbstractPixelmonPacket {
    UUID query;
    ResourceLocation resource;

    public QueryResourceLocationPacket() {
        super(PacketDirection.PLAY_CLIENT, true);
    }

    public QueryResourceLocationPacket(UUID query, ResourceLocation resource) {
        this();
        this.query = query;
        this.resource = resource;
    }

    @Override
    public void decode(PacketBuffer buf) {
        this.query = buf.func_179253_g();
        this.resource = ResourceLocationHelper.of(buf.func_218666_n());
    }

    @Override
    public void encode(PacketBuffer buf) {
        buf.func_179252_a(this.query);
        buf.func_180714_a(this.resource.toString());
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        NetworkHelper.sendToServer(new QueryResourceLocationResult(this.query, CommonProxy.resourceLocationExists(this.resource)));
    }
}

