/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers;

import com.pixelmonmod.pixelmon.api.attackAnimations.AttackAnimation;
import com.pixelmonmod.pixelmon.api.battles.AttackCategory;
import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.ImmutableAttack;
import com.pixelmonmod.pixelmon.battles.attacks.animations.AttackAnimationData;
import com.pixelmonmod.pixelmon.battles.attacks.animations.particles.EffectType;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class PlayBattleParticleSystemPacket
extends AbstractPixelmonPacket {
    private AttackAnimationData effect;
    private ImmutableAttack immutableAttack;
    private ResourceLocation dimension;
    private int power;
    private byte effectiveType;
    private int accuracy;
    private float startX;
    private float startY;
    private float startZ;
    private float endX;
    private float endY;
    private float endZ;
    private int startID;
    private int endID;

    public PlayBattleParticleSystemPacket() {
        super(PacketDirection.PLAY_CLIENT);
    }

    public PlayBattleParticleSystemPacket(AttackAnimation animation, Attack attack, AttackAnimationData effect, boolean groundedStartPosition, boolean groundedEndPosition) {
        super(PacketDirection.PLAY_CLIENT);
        this.dimension = animation.dimension.func_240901_a_();
        this.startID = animation.startID;
        float f = this.startX = animation.user.entity == null ? animation.userPos[0] : (float)animation.user.entity.func_226277_ct_();
        this.startY = animation.user.entity == null ? animation.userPos[1] : (groundedStartPosition ? (float)animation.user.entity.func_226278_cu_() : (float)animation.user.entity.getYCentre());
        this.startZ = animation.user.entity == null ? animation.userPos[2] : (float)animation.user.entity.func_226281_cx_();
        this.endID = animation.endID;
        float f2 = this.endX = animation.target.entity == null ? animation.targetPos[0] : (float)animation.target.entity.func_226277_ct_();
        this.endY = animation.target.entity == null ? animation.targetPos[1] : (groundedEndPosition ? (float)animation.target.entity.func_226278_cu_() : (float)animation.target.entity.getYCentre());
        this.endZ = animation.target.entity == null ? animation.targetPos[2] : (float)animation.target.entity.func_226281_cx_();
        this.power = attack.getAttackCategory() == AttackCategory.STATUS ? 50 : attack.movePower;
        this.effectiveType = (byte)animation.effectiveType.ordinal();
        this.accuracy = attack.moveAccuracy;
        this.effect = effect;
        this.immutableAttack = attack.getMove();
    }

    public PlayBattleParticleSystemPacket(World dimension, AttackAnimationData effect, ImmutableAttack ab, int startID, Vector3d startPos, int endID, Vector3d endPos) {
        super(PacketDirection.PLAY_CLIENT);
        this.dimension = dimension.func_234923_W_().func_240901_a_();
        this.startID = startID;
        this.startX = (float)startPos.field_72450_a;
        this.startY = (float)startPos.field_72448_b;
        this.startZ = (float)startPos.field_72449_c;
        this.endID = endID;
        this.endX = (float)endPos.field_72450_a;
        this.endY = (float)endPos.field_72448_b;
        this.endZ = (float)endPos.field_72449_c;
        this.power = ab.getAttackCategory() == AttackCategory.STATUS ? 50 : ab.getBasePower();
        this.effectiveType = (byte)ab.getAttackType().ordinal();
        this.accuracy = ab.getAccuracy();
        this.effect = effect;
        this.immutableAttack = ab;
    }

    @Override
    public void decode(PacketBuffer buf) {
        this.dimension = buf.func_192575_l();
        this.power = buf.readShort();
        this.effectiveType = buf.readByte();
        this.accuracy = buf.readShort();
        this.startX = buf.readFloat();
        this.startY = buf.readFloat();
        this.startZ = buf.readFloat();
        this.endX = buf.readFloat();
        this.endY = buf.readFloat();
        this.endZ = buf.readFloat();
        this.startID = buf.readInt();
        this.endID = buf.readInt();
        if (buf.readBoolean()) {
            this.effect = EffectType.values()[buf.readByte()].getDataSupplier().get().readFromByteBuffer((ByteBuf)buf);
        }
        this.immutableAttack = AttackRegistry.getAttackBase(buf.func_218666_n()).get();
    }

    @Override
    public void encode(PacketBuffer buf) {
        buf.func_192572_a(this.dimension);
        buf.writeShort(this.power);
        buf.writeByte((int)this.effectiveType);
        buf.writeShort(this.accuracy);
        buf.writeFloat(this.startX);
        buf.writeFloat(this.startY);
        buf.writeFloat(this.startZ);
        buf.writeFloat(this.endX);
        buf.writeFloat(this.endY);
        buf.writeFloat(this.endZ);
        buf.writeInt(this.startID);
        buf.writeInt(this.endID);
        buf.writeBoolean(this.effect != null && this.effect.getEffectEnum() != null);
        if (this.effect != null && this.effect.getEffectEnum() != null) {
            buf.writeByte(this.effect.getEffectEnum().ordinal());
            this.effect.writeToByteBuffer((ByteBuf)buf);
        }
        buf.func_180714_a(this.immutableAttack.getAttackName());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void handlePacket(NetworkEvent.Context context) {
        if (this.effect == null) {
            return;
        }
        if (Minecraft.func_71410_x().field_71441_e.func_234923_W_().func_240901_a_().equals((Object)this.dimension)) {
            this.effect.initFromAttack(this.immutableAttack, this.power, Element.values()[this.effectiveType]);
            Minecraft mc = Minecraft.func_71410_x();
            if (mc.field_71441_e.func_234923_W_().func_240901_a_().equals((Object)this.dimension)) {
                this.effect.createSystem(mc, this.startID, new float[]{this.startX, this.startY, this.startZ}, this.endID, new float[]{this.endX, this.endY, this.endZ});
            }
        }
    }
}

