/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.client.ClientProxy;
import com.pixelmonmod.pixelmon.client.gui.battles.BattleScreen;
import com.pixelmonmod.pixelmon.client.gui.battles.PixelmonClientData;
import com.pixelmonmod.pixelmon.comm.PixelmonStatsData;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class LevelUpPacket
extends AbstractPixelmonPacket {
    public UUID pokemonUUID;
    public int level;
    public PixelmonStatsData statsLevel1;
    public PixelmonStatsData statsLevel2;
    public PixelmonClientData poke;

    public LevelUpPacket() {
        super(PacketDirection.PLAY_CLIENT, true);
    }

    public LevelUpPacket(UUID pokemonUUID, int level, PixelmonStatsData statsLevel1, PixelmonStatsData statsLevel2, PixelmonClientData poke) {
        super(PacketDirection.PLAY_CLIENT, true);
        this.pokemonUUID = pokemonUUID;
        this.level = level;
        this.statsLevel1 = statsLevel1;
        this.statsLevel2 = statsLevel2;
        this.poke = poke;
    }

    public LevelUpPacket(CompoundNBT p, int level, PixelmonStatsData statsLevel1, PixelmonStatsData statsLevel2) {
        super(PacketDirection.PLAY_CLIENT, true);
        this.pokemonUUID = p.func_186857_a("UUID");
        this.level = level;
        this.statsLevel1 = statsLevel1;
        this.statsLevel2 = statsLevel2;
    }

    @Override
    public void decode(PacketBuffer buffer) {
        this.pokemonUUID = new UUID(buffer.readLong(), buffer.readLong());
        this.level = buffer.readInt();
        this.statsLevel1 = new PixelmonStatsData();
        this.statsLevel1.readPacketData((ByteBuf)buffer);
        this.statsLevel2 = new PixelmonStatsData();
        this.statsLevel2.readPacketData((ByteBuf)buffer);
        this.poke = new PixelmonClientData();
        this.poke.decodeFrom(buffer);
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.func_179252_a(this.pokemonUUID);
        buffer.writeInt(this.level);
        this.statsLevel1.writePacketData((ByteBuf)buffer);
        this.statsLevel2.writePacketData((ByteBuf)buffer);
        this.poke.encodeInto(buffer);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void handlePacket(NetworkEvent.Context context) {
        ClientProxy.battleManager.levelUpList.add(this);
        if (!(Minecraft.func_71410_x().field_71462_r instanceof BattleScreen)) {
            if (ClientProxy.battleManager.fullOurPokemon == null) {
                ClientProxy.battleManager.fullOurPokemon = Lists.newArrayList();
            }
            ClientProxy.battleManager.fullOurPokemon.add(this.poke);
            Minecraft.func_71410_x().func_147108_a((Screen)new BattleScreen());
        }
    }
}

