/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.events.PokedexEvent;
import com.pixelmonmod.pixelmon.api.events.npc.NPCTraderEvent;
import com.pixelmonmod.pixelmon.api.pokedex.PokedexRegistrationStatus;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.stats.evolution.types.TradeEvolution;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.trading.NPCTrades;
import com.pixelmonmod.pixelmon.api.trading.TradePair;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.entities.npcs.NPCEntity;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class AcceptNPCTradePacket
extends AbstractPixelmonPacket {
    private int id = -1;

    public AcceptNPCTradePacket() {
        super(PacketDirection.PLAY_SERVER, true);
    }

    public AcceptNPCTradePacket(int id) {
        super(PacketDirection.PLAY_SERVER, true);
        this.id = id;
    }

    @Override
    public void decode(PacketBuffer buffer) {
        this.id = buffer.readInt();
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.id);
    }

    @Override
    public void handlePacket(NetworkEvent.Context context) {
        ServerPlayerEntity player = context.getSender();
        if (player == null) {
            return;
        }
        TradePair tradePair = NPCTrades.getTradePair(player.func_110124_au());
        if (tradePair == null) {
            return;
        }
        Pokemon pokemon = tradePair.offer.create();
        PlayerPartyStorage party = StorageProxy.getParty(context.getSender());
        for (int i = 0; i < party.getAll().length; ++i) {
            NPCEntity npcEntity;
            NPCTraderEvent.AcceptTrade.Pre pre;
            PokedexEvent.Pre preEvent;
            Pokemon partyPokemon = party.get(i);
            if (partyPokemon == null || partyPokemon.isEgg() || !tradePair.exchange.matches(partyPokemon) || partyPokemon.isUntradeable()) continue;
            if (!pokemon.isEgg() && !Pixelmon.EVENT_BUS.post((Event)(preEvent = new PokedexEvent.Pre(player.func_110124_au(), pokemon, PokedexRegistrationStatus.CAUGHT, "tradeNPC")))) {
                party.playerPokedex.set(preEvent.getPokemon(), preEvent.getNewStatus());
                party.playerPokedex.update();
                Pixelmon.EVENT_BUS.post((Event)new PokedexEvent.Post(player.func_110124_au(), preEvent.getOldStatus(), preEvent.getPokemon(), preEvent.getNewStatus(), preEvent.getCause()));
            }
            if (Pixelmon.EVENT_BUS.post((Event)(pre = new NPCTraderEvent.AcceptTrade.Pre((PlayerEntity)player, npcEntity = (NPCEntity)NPCEntity.locateNPCServer(player.field_70170_p, this.id, NPCEntity.class).orElse(null), tradePair, partyPokemon, pokemon, !PixelmonConfigProxy.getGeneral().isTradersReusable())))) continue;
            if (pre.isRemoveNPC() && npcEntity != null) {
                npcEntity.func_70106_y();
            }
            pokemon = pre.getTradedPokemon();
            player.func_71053_j();
            party.set(i, pokemon);
            PixelmonEntity pixelmon = pokemon.getOrSpawnPixelmon((Entity)player);
            Pokemon finalPokemon = pokemon;
            pokemon.getEvolutions(TradeEvolution.class).forEach(evo -> {
                if (evo.canEvolve(pixelmon, finalPokemon.getSpecies())) {
                    evo.doEvolution(pixelmon, "Trade");
                }
            });
            Pixelmon.EVENT_BUS.post((Event)new NPCTraderEvent.AcceptTrade.Post((PlayerEntity)player, npcEntity, tradePair, partyPokemon, pokemon, pre.isRemoveNPC()));
            return;
        }
    }
}

