/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.data;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PixelmonPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.PacketDistributor;

public abstract class AbstractPixelmonPacket
implements PixelmonPacket {
    private final boolean sync;
    private final PacketDirection direction;

    public AbstractPixelmonPacket(PacketDirection direction) {
        this(direction, false);
    }

    public AbstractPixelmonPacket(PacketDirection direction, boolean sync) {
        this.direction = direction;
        this.sync = sync;
    }

    public AbstractPixelmonPacket(boolean sync) {
        this.direction = null;
        this.sync = sync;
    }

    @Override
    public void encode(PacketBuffer buffer) {
    }

    @Override
    public void decode(PacketBuffer buffer) {
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        if (this.sync) {
            context.enqueueWork(() -> this.handlePacket(context));
        } else {
            this.handlePacket(context);
        }
        context.setPacketHandled(true);
    }

    protected abstract void handlePacket(NetworkEvent.Context var1);

    protected void reply(NetworkEvent.Context context, Object packet) {
        Pixelmon.network.send(PacketDistributor.PLAYER.with(() -> ((NetworkEvent.Context)context).getSender()), packet);
    }
}

