/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.events.battles.BattleMessageEvent;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.Spectator;
import com.pixelmonmod.pixelmon.battles.tasks.BattleMessagePacket;
import java.util.List;
import net.minecraft.command.ICommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Util;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.eventbus.api.Event;

public class ChatHandler {
    public static void sendChat(Entity entityLiving, String string, Object ... data) {
        ChatHandler.sendChat((ICommandSource)entityLiving, ChatHandler.getMessage(string, data));
    }

    public static void sendChat(ICommandSource receiver, TranslationTextComponent message) {
        receiver.func_145747_a((ITextComponent)message, Util.field_240973_b_);
    }

    public static void sendChat(ICommandSource owner, ICommandSource owner2, String string, Object ... data) {
        TranslationTextComponent textComponentTranslation = ChatHandler.getMessage(string, data);
        ChatHandler.sendChat(owner, textComponentTranslation);
        ChatHandler.sendChat(owner2, textComponentTranslation);
    }

    public static void sendFormattedChat(ICommandSource receiver, TextFormatting chatFormat, String string, Object ... data) {
        TranslationTextComponent textComponentTranslation = new TranslationTextComponent(string, data);
        textComponentTranslation.func_150256_b().func_240718_a_(Color.func_240744_a_((TextFormatting)chatFormat));
        ChatHandler.sendChat(receiver, textComponentTranslation);
    }

    public static void sendBattleMessage(Entity user, String string, Object ... data) {
        TranslationTextComponent textComponentTranslation = new TranslationTextComponent(string, data);
        textComponentTranslation.func_150256_b().func_240718_a_(Color.func_240744_a_((TextFormatting)TextFormatting.GRAY));
        ChatHandler.sendBattleMessage(user, textComponentTranslation);
    }

    public static void sendBattleMessage(Entity user, TranslationTextComponent chat) {
        if (chat.func_150268_i() != null && !chat.func_150268_i().isEmpty()) {
            if (user instanceof ServerPlayerEntity) {
                NetworkHelper.sendPacket(new BattleMessagePacket((ITextComponent)chat), (ServerPlayerEntity)user);
            }
            Pixelmon.EVENT_BUS.post((Event)new BattleMessageEvent(user, chat));
        }
    }

    public static void sendBattleMessage(List<BattleParticipant> participants, String string, Object ... data) {
        ChatHandler.sendBattleMessage(participants, ChatHandler.getMessage(string, data));
    }

    public static void sendBattleMessage(List<BattleParticipant> participants, TranslationTextComponent message) {
        for (BattleParticipant p : participants) {
            ChatHandler.sendBattleMessage((Entity)p.getEntity(), message);
        }
        List<Spectator> spectators = participants.get((int)0).bc.spectators;
        spectators.forEach(spectator -> spectator.sendBattleMessage(message));
    }

    public static TranslationTextComponent getMessage(String string, Object ... data) {
        TranslationTextComponent message = new TranslationTextComponent(string, data);
        message.func_150256_b().func_240718_a_(Color.func_240744_a_((TextFormatting)TextFormatting.GRAY));
        return message;
    }

    public static void sendMessageToAllPlayers(MinecraftServer minecraftServer, String string, Object ... data) {
        TranslationTextComponent translation = ChatHandler.getMessage(string, data);
        minecraftServer.func_184103_al().func_232641_a_((ITextComponent)translation, ChatType.CHAT, Util.field_240973_b_);
    }
}

