/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.render.tileEntities;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonFactory;
import com.pixelmonmod.pixelmon.api.pokemon.item.pokeball.PokeBall;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.util.helpers.QuaternionHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.blocks.MultiBlock;
import com.pixelmonmod.pixelmon.blocks.machines.FossilMachineBlock;
import com.pixelmonmod.pixelmon.blocks.tileentity.FossilMachineTileEntity;
import com.pixelmonmod.pixelmon.client.models.blocks.GenericSmdModel;
import com.pixelmonmod.pixelmon.client.models.pokeballs.ModelPokeballs;
import com.pixelmonmod.pixelmon.client.models.smd.AnimationType;
import com.pixelmonmod.pixelmon.client.render.GenericModelHolder;
import com.pixelmonmod.pixelmon.client.render.PixelmonRendering;
import com.pixelmonmod.pixelmon.client.render.tileEntities.TileEntityRenderer;
import com.pixelmonmod.pixelmon.entities.pixelmon.StatueEntity;
import com.pixelmonmod.pixelmon.enums.EnumGrowth;
import com.pixelmonmod.pixelmon.enums.items.EnumFossils;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.BlockState;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;

public class RenderTileEntityFossilMachine
extends TileEntityRenderer<FossilMachineTileEntity> {
    public static final ResourceLocation MACHINE_TEXTURE = ResourceLocationHelper.of("pixelmon", "textures/block/fossil_extractor.png");
    private static final GenericModelHolder<GenericSmdModel> machineBase = new GenericModelHolder("blocks/fossil_machine/fossil_extractor.pqc");
    public static final GenericSmdModel machineGlass = new GenericSmdModel("models/blocks/fossil_machine", "fossil_extractor_glass.pqc");
    private static final Map<Integer, StatueConfig> OVERRIDE_MAP = new HashMap<Integer, StatueConfig>();
    private static final StatueConfig DEFAULT = new StatueConfig(0.15f, 0, AnimationType.WALK);

    public RenderTileEntityFossilMachine(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
        RenderTileEntityFossilMachine.machineGlass.modelRenderer.setTransparent(0.5f);
        this.correctionAngles = 180;
        PixelmonSpecies.OMANYTE.ifInitialized(species -> OVERRIDE_MAP.put(species.getDex(), new StatueConfig(0.15f, 0, AnimationType.IDLE)));
        PixelmonSpecies.KABUTO.ifInitialized(species -> OVERRIDE_MAP.put(species.getDex(), new StatueConfig(0.001f, 0, AnimationType.IDLE)));
        PixelmonSpecies.AERODACTYL.ifInitialized(species -> OVERRIDE_MAP.put(species.getDex(), new StatueConfig(0.6f, 0, AnimationType.IDLE)));
        PixelmonSpecies.LILEEP.ifInitialized(species -> OVERRIDE_MAP.put(species.getDex(), new StatueConfig(0.16f, 0, AnimationType.IDLE)));
        PixelmonSpecies.ANORITH.ifInitialized(species -> OVERRIDE_MAP.put(species.getDex(), new StatueConfig(0.1f, 0, AnimationType.IDLE)));
        PixelmonSpecies.CRANIDOS.ifInitialized(species -> OVERRIDE_MAP.put(species.getDex(), new StatueConfig(0.22f, 0, AnimationType.IDLE)));
        PixelmonSpecies.SHIELDON.ifInitialized(species -> OVERRIDE_MAP.put(species.getDex(), new StatueConfig(0.001f, 0, AnimationType.IDLE)));
        PixelmonSpecies.TIRTOUGA.ifInitialized(species -> OVERRIDE_MAP.put(species.getDex(), new StatueConfig(0.05f, 0, AnimationType.IDLE)));
        PixelmonSpecies.ARCHEN.ifInitialized(species -> OVERRIDE_MAP.put(species.getDex(), new StatueConfig(0.15f, 6, AnimationType.FLY)));
        PixelmonSpecies.TYRUNT.ifInitialized(species -> OVERRIDE_MAP.put(species.getDex(), new StatueConfig(0.25f, 0, AnimationType.IDLE)));
        PixelmonSpecies.AMAURA.ifInitialized(species -> OVERRIDE_MAP.put(species.getDex(), new StatueConfig(0.01f, 0, AnimationType.IDLE)));
        PixelmonSpecies.ARCTOZOLT.ifInitialized(species -> OVERRIDE_MAP.put(species.getDex(), new StatueConfig(0.5f, 20, AnimationType.IDLE)));
        PixelmonSpecies.ARCTOVISH.ifInitialized(species -> OVERRIDE_MAP.put(species.getDex(), new StatueConfig(0.45f, 20, AnimationType.IDLE)));
        PixelmonSpecies.DRACOVISH.ifInitialized(species -> OVERRIDE_MAP.put(species.getDex(), new StatueConfig(0.5f, 0, AnimationType.IDLE)));
        PixelmonSpecies.DRACOZOLT.ifInitialized(species -> OVERRIDE_MAP.put(species.getDex(), new StatueConfig(0.45f, 20, AnimationType.IDLE)));
    }

    @Override
    public void render(FossilMachineTileEntity machine, BlockState state, double x, double y, double z, float partialTicks, MatrixStack matrix, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        StatueConfig config;
        this.renderSMD(matrix, buffer, (Model)machineBase.getModel(), MACHINE_TEXTURE, combinedLight, combinedOverlay);
        this.renderTransparentSMD(matrix, buffer, machineGlass, MACHINE_TEXTURE, combinedLight, combinedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
        matrix.func_227865_b_();
        matrix.func_227860_a_();
        int rotate = this.getRotation(state);
        Direction facing = Direction.NORTH;
        if (state.func_177230_c() instanceof FossilMachineBlock) {
            facing = (Direction)state.func_177229_b((Property)MultiBlock.FACING);
        }
        this.renderCompletionLevel(machine, matrix, machine.completionRate + "%", facing, rotate, x, 0.0, z, false, Color.RED.getRGB());
        if (machine.staticFlicker && machine.completionRate == 100 && machine.pokeball == null) {
            this.renderCompletionLevel(machine, matrix, I18n.func_135052_a((String)"pixelmon.blocks.fossilmachine.pokeball", (Object[])new Object[0]), facing, rotate, x, 0.08f, z, true, -65536);
        } else if (machine.completionRate > 0 && machine.completionRate < 100) {
            this.renderCompletionLevel(machine, matrix, I18n.func_135052_a((String)"pixelmon.blocks.fossilmachine.working", (Object[])new Object[0]) + machine.dots, facing, rotate, x, 0.1f, z, true, -16711936);
        } else if (machine.staticFlicker && machine.completionRate == 0 && machine.currentFossil == EnumFossils.NULL) {
            this.renderCompletionLevel(machine, matrix, I18n.func_135052_a((String)"pixelmon.blocks.fossilmachine.fossil", (Object[])new Object[0]), facing, rotate, x, 0.08f, z, true, -65536);
        } else if (machine.staticFlicker && machine.completionRate == 0 && machine.currentFossil.getPokemon() == null) {
            this.renderCompletionLevel(machine, matrix, I18n.func_135052_a((String)"pixelmon.blocks.fossilmachine.incomplete", (Object[])new Object[0]), facing, rotate, x, 0.08f, z, true, -65536);
        } else if (machine.staticFlicker && machine.completionRate == 100 && machine.pokeball != null) {
            this.renderCompletionLevel(machine, matrix, I18n.func_135052_a((String)"pixelmon.blocks.fossilmachine.retrieve", (Object[])new Object[0]), facing, rotate, x, 0.08f, z, true, -16711936);
        }
        this.renderBarLevel(machine, matrix, facing, rotate, x, y, z);
        if (machine.currentFossil != EnumFossils.NULL) {
            this.renderFossil(machine.currentFossil, machine, matrix, buffer, combinedLight, combinedOverlay, rotate, x, y, z, facing);
        }
        if (machine.pokeball != null) {
            this.renderPokeball(machine.pokeball, machine, matrix, buffer, combinedLight, combinedOverlay, rotate, x, y, z, facing);
        }
        if (!(machine.statue != null && machine.statue.func_200200_C_().getString().equalsIgnoreCase(machine.currentPokemon) || machine.currentPokemon.equals("") || !PixelmonSpecies.has(machine.currentPokemon))) {
            machine.statue = new StatueEntity(machine.func_145831_w());
            machine.statue.setPokemon(PokemonFactory.create(PixelmonSpecies.fromName(machine.currentPokemon).getValueUnsafe()));
            machine.statue.setGrowth(EnumGrowth.Small);
            if (machine.isShiny) {
                machine.statue.setPalette("shiny");
            }
            config = OVERRIDE_MAP.getOrDefault(machine.statue.getSpecies().getDex(), DEFAULT);
            machine.statue.setAnimation(config.type);
            machine.statue.setAnimationFrame(config.frame);
        }
        if (machine.statue != null) {
            matrix.func_227860_a_();
            matrix.func_227861_a_((double)((float)x + 0.5f), (double)((float)y + 0.9f), (double)((float)z + 0.5f));
            config = OVERRIDE_MAP.getOrDefault(machine.statue.getSpecies(), DEFAULT);
            float scale = Math.max(machine.pokemonProgress / 1000.0f / 4.0f - config.scale, 0.0f);
            matrix.func_227862_a_(scale, scale, scale);
            machine.statue.func_70012_b(x, y, z, 0.0f, 0.0f);
            PixelmonRendering.renderEntity(matrix, machine.statue, false, partialTicks);
            matrix.func_227865_b_();
        }
        matrix.func_227865_b_();
        matrix.func_227860_a_();
    }

    @Override
    protected int getRotation(BlockState state) {
        if (state.func_177230_c() instanceof FossilMachineBlock) {
            Direction facing = (Direction)state.func_177229_b((Property)MultiBlock.FACING);
            if (facing == Direction.WEST) {
                return 90;
            }
            if (facing == Direction.SOUTH) {
                return 180;
            }
            if (facing == Direction.EAST) {
                return 270;
            }
            return 0;
        }
        return 0;
    }

    private void renderBarLevel(FossilMachineTileEntity tile, MatrixStack matrix, Direction facing, int rotate, double x1, double y1, double z1) {
        matrix.func_227860_a_();
        float f2 = 1.5f;
        float f3 = 0.00666667f * f2;
        if (facing == Direction.NORTH) {
            matrix.func_227861_a_(0.5, (double)0.32f, (double)0.97f);
        } else if (facing == Direction.WEST) {
            matrix.func_227861_a_((double)0.97f, (double)0.32f, 0.5);
        } else if (facing == Direction.SOUTH) {
            matrix.func_227861_a_(0.5, (double)0.32f, (double)0.03f);
        } else {
            matrix.func_227861_a_((double)0.03f, (double)0.32f, 0.5);
        }
        matrix.func_227863_a_(QuaternionHelper.fromEuler(rotate + 180, 0.0f, 1.0f, 0.0f));
        matrix.func_227862_a_(-f3, -f3, f3);
        Matrix4f pose = matrix.func_227866_c_().func_227870_a_();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        int byte0 = -20;
        float f8 = (float)tile.completionRate / 2.0f;
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        buffer.func_227888_a_(pose, -25.0f + f8, (float)(-7 + byte0), 0.0f).func_227885_a_(0.0039f, 0.03137f, 0.4196f, 1.0f).func_181675_d();
        buffer.func_227888_a_(pose, -25.0f + f8, (float)(-6 + byte0), 0.0f).func_227885_a_(0.0039f, 0.03137f, 0.4196f, 1.0f).func_181675_d();
        buffer.func_227888_a_(pose, 25.0f, (float)(-6 + byte0), 0.0f).func_227885_a_(0.0039f, 0.03137f, 0.4196f, 1.0f).func_181675_d();
        buffer.func_227888_a_(pose, 25.0f, (float)(-7 + byte0), 0.0f).func_227885_a_(0.0039f, 0.03137f, 0.4196f, 1.0f).func_181675_d();
        buffer.func_227888_a_(pose, -25.0f, (float)(-7 + byte0), 0.0f).func_227885_a_(0.0f, 0.8901f, 0.8901f, 1.0f).func_181675_d();
        buffer.func_227888_a_(pose, -25.0f, (float)(-6 + byte0), 0.0f).func_227885_a_(0.0f, 0.8901f, 0.8901f, 1.0f).func_181675_d();
        buffer.func_227888_a_(pose, f8 - 25.0f, (float)(-6 + byte0), 0.0f).func_227885_a_(0.0f, 0.8901f, 0.8901f, 1.0f).func_181675_d();
        buffer.func_227888_a_(pose, f8 - 25.0f, (float)(-7 + byte0), 0.0f).func_227885_a_(0.0f, 0.8901f, 0.8901f, 1.0f).func_181675_d();
        tessellator.func_78381_a();
        matrix.func_227865_b_();
    }

    private void renderCompletionLevel(FossilMachineTileEntity tile, MatrixStack matrix, String text, Direction facing, int rotation, double x1, double y1, double z1, boolean par10, int color) {
        FontRenderer fontRenderer = this.field_228858_b_.func_147548_a();
        matrix.func_227860_a_();
        float var13 = 1.5f;
        float var14 = 0.011f * var13;
        if (facing == Direction.NORTH) {
            matrix.func_227861_a_(0.5, y1 + 0.75, (double)0.97f);
            rotation = 180 - rotation;
        } else if (facing == Direction.WEST) {
            matrix.func_227861_a_((double)0.97f, y1 + 0.75, 0.5);
        } else if (facing == Direction.SOUTH) {
            matrix.func_227861_a_(0.5, y1 + 0.75, (double)0.03f);
            rotation = 180 - rotation;
        } else {
            matrix.func_227861_a_((double)0.03f, y1 + 0.75, 0.5);
        }
        if (!par10) {
            matrix.func_227862_a_(-var14, -var14, var14);
        } else {
            matrix.func_227862_a_(-var14 + 0.011f, -var14 + 0.011f, var14 - 0.011f);
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        matrix.func_227863_a_(QuaternionHelper.fromEuler(rotation, 0.0f, 1.0f, 0.0f));
        Matrix4f pose = matrix.func_227866_c_().func_227870_a_();
        int stringWidth = fontRenderer.func_78256_a(text) / 2;
        fontRenderer.func_238421_b_(matrix, text, (float)(-stringWidth), 1.0f, color);
        RenderSystem.color4f((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        buffer.func_227888_a_(pose, (float)(-stringWidth - 1), -1.0f, -0.5f).func_181675_d();
        buffer.func_227888_a_(pose, (float)(-stringWidth - 1), 8.0f, -0.5f).func_181675_d();
        buffer.func_227888_a_(pose, (float)(stringWidth + 1), 8.0f, -0.5f).func_181675_d();
        buffer.func_227888_a_(pose, (float)(stringWidth + 1), -1.0f, -0.5f).func_181675_d();
        tessellator.func_78381_a();
        fontRenderer.func_238421_b_(matrix, text, (float)(-stringWidth), 0.0f, color);
        matrix.func_227865_b_();
    }

    private void renderFossil(EnumFossils fossil, FossilMachineTileEntity machine, MatrixStack matrix, IRenderTypeBuffer buffer, int light, int overlay, int rotate, double x, double y, double z, Direction facing) {
        matrix.func_227860_a_();
        matrix.func_227861_a_(0.5, (double)(1.0f + machine.fossilJitter), 0.5);
        matrix.func_227862_a_(0.8f - machine.fossilProgress / 1000.0f / 2.0f, -0.8f + machine.fossilProgress / 1000.0f / 2.0f, -0.8f + machine.fossilProgress / 1000.0f / 2.0f);
        if (facing == Direction.NORTH || facing == Direction.SOUTH) {
            matrix.func_227863_a_(QuaternionHelper.fromEuler(rotate, 0.0f, 1.0f, 0.0f));
        } else {
            matrix.func_227863_a_(QuaternionHelper.fromEuler((float)rotate + 180.0f, 0.0f, 0.5f, 0.0f));
        }
        this.renderSMD(matrix, buffer, (Model)fossil.getModel().getModel(), fossil.getTexture(), light, overlay);
        matrix.func_227865_b_();
    }

    private void renderPokeball(PokeBall pokeBall, FossilMachineTileEntity machine, MatrixStack matrix, IRenderTypeBuffer buffer, int light, int overlay, int rotate, double x, double y, double z, Direction facing) {
        matrix.func_227860_a_();
        if (rotate == 270) {
            matrix.func_227861_a_((double)-0.1f, (double)0.42f, 0.86);
        } else if (rotate == 180) {
            matrix.func_227861_a_(0.14, (double)0.42f, -0.1);
        } else if (rotate == 90) {
            matrix.func_227861_a_(1.1, (double)0.42f, 0.14);
        } else {
            matrix.func_227861_a_(0.86, (double)0.42f, 1.1);
        }
        matrix.func_227863_a_(QuaternionHelper.fromEuler(rotate, 0.0f, 1.0f, 0.0f));
        GenericModelHolder<ModelPokeballs> pokeball = pokeBall.getModelHolder();
        ((ModelPokeballs)((Object)pokeball.getModel())).theModel.setAnimation(AnimationType.IDLE);
        ((ModelPokeballs)((Object)pokeball.getModel())).theModel.animate();
        float scale = 0.002f;
        matrix.func_227862_a_(scale, scale, scale);
        this.renderSMD(matrix, buffer, (Model)pokeball.getModel(), pokeBall.getModelTexture(), light, overlay);
        matrix.func_227865_b_();
    }

    private static class StatueConfig {
        float scale = 0.15f;
        int frame = 0;
        AnimationType type = AnimationType.WALK;

        public StatueConfig(float scale, int frame, AnimationType type) {
            this.scale = scale;
            this.frame = frame;
            this.type = type;
        }
    }
}

