/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.render.tileEntities;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.pixelmonmod.api.pokemon.PokemonSpecificationProxy;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.util.helpers.QuaternionHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.blocks.MultiBlock;
import com.pixelmonmod.pixelmon.blocks.tileentity.CloningMachineTileEntity;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.models.blocks.ModelBrokenCloningMachine;
import com.pixelmonmod.pixelmon.client.models.blocks.ModelCloningMachine;
import com.pixelmonmod.pixelmon.client.models.smd.AnimationType;
import com.pixelmonmod.pixelmon.client.render.GenericModelHolder;
import com.pixelmonmod.pixelmon.client.render.PixelmonRendering;
import com.pixelmonmod.pixelmon.client.render.tileEntities.TileEntityRenderer;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.enums.EnumGrowth;
import net.minecraft.block.BlockState;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;

public class RenderTileEntityCloningMachine
extends TileEntityRenderer<CloningMachineTileEntity> {
    private static final ResourceLocation CLONING_MACHINE_TEX = ResourceLocationHelper.of("pixelmon:textures/block/cloning_machine.png");
    private static final ResourceLocation CLONING_MACHINE_BLOCKS = ResourceLocationHelper.of("pixelmon:textures/gui/clonerblocks.png");
    private static final GenericModelHolder<ModelCloningMachine> model = new GenericModelHolder<ModelCloningMachine>(ModelCloningMachine.class);
    private static final GenericModelHolder<ModelBrokenCloningMachine> brokenModel = new GenericModelHolder<ModelBrokenCloningMachine>(ModelBrokenCloningMachine.class);
    private PixelmonEntity pokemon;

    public RenderTileEntityCloningMachine(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
        this.flip = false;
    }

    @Override
    public void render(CloningMachineTileEntity machine, BlockState state, double x, double y, double z, float partialTicks, MatrixStack matrix, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        IVertexBuilder vertices = buffer.getBuffer(PixelmonRendering.getOBJRenderTypeUndelegated(CLONING_MACHINE_TEX));
        if (machine.isBroken) {
            ((ModelBrokenCloningMachine)((Object)brokenModel.getModel())).renderTileEntity(machine, matrix, vertices, combinedLight, combinedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
        } else {
            ((ModelCloningMachine)((Object)model.getModel())).renderTileEntity(machine, matrix, vertices, combinedLight, combinedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        matrix.func_227865_b_();
        matrix.func_227860_a_();
        Direction facing = Direction.NORTH;
        int rotation = super.getRotation(state);
        if (state.func_177230_c() instanceof MultiBlock) {
            facing = (Direction)state.func_177229_b((Property)MultiBlock.FACING);
        }
        if (machine.hasMew() && !machine.isBroken && !machine.isFinished) {
            if (this.pokemon == null) {
                this.pokemon = PokemonSpecificationProxy.create(PixelmonSpecies.MEW.getValueUnsafe().getName()).create(machine.func_145831_w());
                this.pokemon.getPokemon().setGrowth(EnumGrowth.Runt);
                this.pokemon.getLvl().setLevel(1);
                this.pokemon.getPokemon().setPalette(machine.mew.getPalette());
                this.pokemon.initAnimation();
            }
            matrix.func_227860_a_();
            if (this.pokemon != null) {
                matrix.func_227861_a_(0.5, (double)0.45f, 0.5);
                matrix.func_227863_a_(QuaternionHelper.fromEuler(rotation, 0.0f, 1.0f, 0.0f));
                this.pokemon.func_70012_b(x, y, z, 0.0f, 0.0f);
                this.pokemon.setAnimation(AnimationType.IDLE);
                if (this.pokemon.getAnimationVariables().hasInt(-1)) {
                    this.pokemon.getAnimationVariables().getCounter((int)-1).value = 30.0f;
                }
                PixelmonRendering.renderEntity(matrix, this.pokemon, false, partialTicks);
            }
            matrix.func_227865_b_();
        }
        matrix.func_227860_a_();
        matrix.func_227861_a_(0.5, 0.0, 0.5);
        matrix.func_227863_a_(QuaternionHelper.fromEuler(rotation, 0.0f, 1.0f, 0.0f));
        matrix.func_227863_a_(QuaternionHelper.fromEuler(180.0f, 1.0f, 0.0f, 0.0f));
        matrix.func_227862_a_(1.0f, -1.0f, -1.0f);
        RenderSystem.enableBlend();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.blendFunc((int)770, (int)771);
        if (machine.isBroken) {
            ((ModelBrokenCloningMachine)((Object)brokenModel.getModel())).renderGlass(matrix, vertices, combinedLight, combinedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
        } else {
            ((ModelCloningMachine)((Object)model.getModel())).renderGlass(matrix, vertices, combinedLight, combinedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        RenderSystem.disableBlend();
        matrix.func_227865_b_();
        if (machine.isBroken) {
            this.renderLeftDisplay(machine, matrix, I18n.func_135052_a((String)"pixelmon.blocks.cloningmachine.error", (Object[])new Object[0]), facing, x, y, z, 64, false, -1);
        } else {
            if (machine.isFinished) {
                this.renderLeftDisplay(machine, matrix, I18n.func_135052_a((String)"pixelmon.blocks.cloningmachine.finished", (Object[])new Object[0]), facing, x, y, z, 64, false, -1);
            } else if (machine.hasMew()) {
                this.renderLeftDisplay(machine, matrix, I18n.func_135052_a((String)"pixelmon.blocks.cloningmachine.scanning", (Object[])new Object[0]), facing, x, y, z, 64, false, -1);
            } else {
                this.renderLeftDisplay(machine, matrix, I18n.func_135052_a((String)"pixelmon.blocks.cloningmachine.mew", (Object[])new Object[0]), facing, x, y, z, 64, false, -1);
            }
            if (machine.hasMew()) {
                this.renderRightDisplay(machine, matrix, I18n.func_135052_a((String)"pixelmon.blocks.cloningmachine.catalyst", (Object[])new Object[0]), facing, x, y, z, 64, false, -1);
            }
            if (!machine.pokemonName.equals("")) {
                if (machine.pixelmon == null) {
                    machine.pixelmon = PokemonSpecificationProxy.create(machine.pokemonName, machine.isShiny ? "s" : "!s", "gr:Runt", "lvl:1").create(machine.func_145831_w());
                    machine.pixelmon.initAnimation();
                }
                matrix.func_227860_a_();
                matrix.func_227861_a_((double)(0.5f + machine.xboost), (double)0.8f, (double)(0.5f + machine.zboost));
                machine.pixelmon.func_70029_a(machine.func_145831_w());
                matrix.func_227863_a_(QuaternionHelper.fromEuler(rotation, 0.0f, 1.0f, 0.0f));
                matrix.func_227862_a_(0.0f + (float)machine.pokemonProgress / 200.0f, 0.0f + (float)machine.pokemonProgress / 200.0f, 0.0f + (float)machine.pokemonProgress / 200.0f);
                PixelmonRendering.renderEntity(matrix, machine.pixelmon, false, partialTicks);
                matrix.func_227865_b_();
            }
        }
    }

    private void renderLeftDisplay(CloningMachineTileEntity tile, MatrixStack matrix, String par2Str, Direction facing, double par3, double par5, double par7, int par9, boolean par10, int par11) {
        int j = 0;
        if (facing == Direction.EAST) {
            j = 270;
        } else if (facing == Direction.NORTH) {
            j = 0;
        } else if (facing == Direction.WEST) {
            j = 90;
        } else if (facing == Direction.SOUTH) {
            j = 180;
        }
        FontRenderer var12 = this.field_228858_b_.func_147548_a();
        float var13 = 1.6f;
        float var14 = 0.011666667f * var13;
        matrix.func_227860_a_();
        if (facing == Direction.NORTH) {
            matrix.func_227861_a_(0.5, (double)0.9f, (double)1.22f);
        } else if (facing == Direction.WEST) {
            matrix.func_227861_a_((double)1.23f, (double)0.9f, 0.5);
        } else if (facing == Direction.SOUTH) {
            matrix.func_227861_a_(0.5, (double)0.9f, (double)-0.23f);
        } else {
            matrix.func_227861_a_((double)-0.23f, (double)0.9f, (double)0.51f);
        }
        matrix.func_227863_a_(QuaternionHelper.fromEuler(j + 180, 0.0f, 1.0f, 0.0f));
        RenderSystem.normal3f((float)0.0f, (float)1.0f, (float)0.0f);
        if (!par10) {
            matrix.func_227862_a_(-var14, -var14, var14);
        } else {
            matrix.func_227862_a_(-var14 + 0.012f, -var14 + 0.012f, var14 + 0.012f);
        }
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        boolean var16 = false;
        matrix.func_227862_a_(0.5f, 0.5f, 0.5f);
        RenderSystem.disableTexture();
        RenderSystem.enableTexture();
        var12.func_238421_b_(matrix, par2Str, (float)(-var12.func_78256_a(par2Str)) / 2.0f, (float)var16, par11);
        RenderSystem.disableBlend();
        matrix.func_227865_b_();
    }

    private void renderRightDisplay(CloningMachineTileEntity tile, MatrixStack matrix, String par2Str, Direction facing, double par3, double par5, double par7, int par9, boolean par10, int par11) {
        int j = 0;
        if (facing == Direction.EAST) {
            j = 270;
        } else if (facing == Direction.NORTH) {
            j = 0;
        } else if (facing == Direction.WEST) {
            j = 90;
        } else if (facing == Direction.SOUTH) {
            j = 180;
        }
        FontRenderer var12 = this.field_228858_b_.func_147548_a();
        float var13 = 1.6f;
        float var14 = 0.011666667f * var13;
        matrix.func_227860_a_();
        if (facing == Direction.NORTH) {
            matrix.func_227861_a_((double)3.87f, (double)0.9f, (double)1.22f);
        } else if (facing == Direction.WEST) {
            matrix.func_227861_a_((double)1.23f, (double)0.9f, (double)-2.87f);
        } else if (facing == Direction.SOUTH) {
            matrix.func_227861_a_((double)-2.87f, (double)0.9f, (double)-0.23f);
        } else {
            matrix.func_227861_a_((double)-0.23f, (double)0.9f, (double)3.87f);
        }
        matrix.func_227863_a_(QuaternionHelper.fromEuler(j + 180, 0.0f, 1.0f, 0.0f));
        RenderSystem.normal3f((float)0.0f, (float)1.0f, (float)0.0f);
        if (!par10) {
            matrix.func_227862_a_(-var14, -var14, var14);
        } else {
            matrix.func_227862_a_(-var14 + 0.012f, -var14 + 0.012f, var14 + 0.012f);
        }
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        int var16 = 0;
        matrix.func_227862_a_(0.3f, 0.3f, 0.3f);
        RenderSystem.disableTexture();
        var12.func_78256_a(par2Str);
        RenderSystem.enableTexture();
        if (tile.isFinished) {
            par2Str = I18n.func_135052_a((String)"pixelmon.blocks.cloningmachine.retrieve", (Object[])new Object[0]);
        } else if (tile.processingClone || tile.growingPokemon) {
            par2Str = I18n.func_135052_a((String)"pixelmon.blocks.cloningmachine.processing", (Object[])new Object[0]);
        }
        if (!(tile.processingClone || tile.growingPokemon || tile.isFinished)) {
            RenderSystem.enableCull();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.enableDepthTest();
            ScreenHelper.drawImageQuad(CLONING_MACHINE_BLOCKS, matrix, -30.0f, 10.0f, 60.0f, 20.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
            par2Str = I18n.func_135052_a((String)"pixelmon.blocks.cloningmachine.boost", (Object[])new Object[0]) + " " + tile.boostCount + "/3";
            var12.func_238421_b_(matrix, par2Str, (float)(-var12.func_78256_a(par2Str)) / 2.0f, (float)(var16 + 40), par11);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder worldRenderer = tessellator.func_178180_c();
            int x = -30;
            int w = 60;
            int y = 35;
            int h = 17;
            boolean zLevel = false;
            RenderSystem.disableTexture();
            float boostPercent = (float)tile.boostLevel / 40.0f;
            worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            worldRenderer.func_225582_a_((double)x, (double)(y + h), (double)zLevel + 0.01).func_227885_a_(0.2f + 0.3f * (1.0f - boostPercent), 0.2f + 0.3f * boostPercent, 0.2f, 1.0f).func_181675_d();
            worldRenderer.func_225582_a_((double)(x + w), (double)(y + h), (double)zLevel + 0.01).func_227885_a_(0.2f + 0.3f * (1.0f - boostPercent), 0.2f + 0.3f * boostPercent, 0.2f, 1.0f).func_181675_d();
            worldRenderer.func_225582_a_((double)(x + w), (double)y, (double)zLevel + 0.01).func_227885_a_(0.2f + 0.3f * (1.0f - boostPercent), 0.2f + 0.3f * boostPercent, 0.2f, 1.0f).func_181675_d();
            worldRenderer.func_225582_a_((double)x, (double)y, (double)zLevel + 0.01).func_227885_a_(0.2f + 0.3f * (1.0f - boostPercent), 0.2f + 0.3f * boostPercent, 0.2f, 1.0f).func_181675_d();
            tessellator.func_78381_a();
            RenderSystem.enableTexture();
        }
        var12.func_238421_b_(matrix, par2Str, (float)(-var12.func_78256_a(par2Str)) / 2.0f, (float)var16, par11);
        RenderSystem.disableBlend();
        matrix.func_227865_b_();
    }

    public boolean shouldRenderOffScreen(CloningMachineTileEntity p_188185_1_) {
        return true;
    }
}

