/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.render.tileEntities;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.pixelmonmod.pixelmon.api.registries.PixelmonBlocks;
import com.pixelmonmod.pixelmon.api.util.helpers.QuaternionHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.blocks.BellBlock;
import com.pixelmonmod.pixelmon.blocks.tileentity.BellTileEntity;
import com.pixelmonmod.pixelmon.client.models.blocks.GenericSmdModel;
import com.pixelmonmod.pixelmon.client.render.GenericModelHolder;
import com.pixelmonmod.pixelmon.client.render.PixelmonRendering;
import com.pixelmonmod.pixelmon.client.render.tileEntities.TileEntityRenderer;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;

public class RenderTileEntityBell
extends TileEntityRenderer<BellTileEntity> {
    private static final GenericModelHolder<GenericSmdModel> tidal_model = new GenericModelHolder("blocks/bells/tidal_bell.pqc");
    private static final ResourceLocation tidal_texture = ResourceLocationHelper.of("pixelmon", "textures/block/tidal_bell.png");
    private static final GenericModelHolder<GenericSmdModel> clear_model = new GenericModelHolder("blocks/bells/clear_bell.pqc");
    private static final ResourceLocation clear_texture = ResourceLocationHelper.of("pixelmon", "textures/block/clear_bell.png");
    private int ticker = 0;
    private float randomValue = RandomHelper.getRandom().nextFloat();

    public RenderTileEntityBell(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    @Override
    public void render(BellTileEntity bell, BlockState state, double x, double y, double z, float partialTicks, MatrixStack matrix, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        if (state.func_177230_c().equals(PixelmonBlocks.clear_bell.getBlock()) || state.func_177230_c().equals(PixelmonBlocks.tidal_bell.getBlock())) {
            switch (((BellBlock)state.func_177230_c()).getBell()) {
                case CLEAR: {
                    this.renderModel(matrix, buffer, combinedLight, combinedOverlay, clear_model, clear_texture);
                    break;
                }
                case TIDAL: {
                    this.renderModel(matrix, buffer, combinedLight, combinedOverlay, tidal_model, tidal_texture);
                }
            }
            if (bell.isSpawning()) {
                bell.setTicks(bell.getTicks() + 1);
                int ticker = bell.getTicks();
                float f = ((float)ticker + partialTicks) / 300.0f;
                matrix.func_227860_a_();
                matrix.func_227861_a_(0.0, (double)-0.65f, 0.0);
                int count = 15;
                float scale = 9.0E-4f;
                if (bell.isSpawning() && bell.func_145831_w().func_72820_D() > 12000L && bell.func_145831_w().func_72820_D() < 14000L) {
                    long factor = 13000L - bell.func_145831_w().func_72820_D();
                    double size = (double)factor / 1000.0;
                    scale = (float)Math.max((1.0 - size) / 1000.0, 3.0E-4);
                    int additional = (int)((1.0 - size) * 10.0);
                    count += additional;
                }
                IVertexBuilder bufferBuilder = buffer.getBuffer(PixelmonRendering.getBellRenderType());
                matrix.func_227862_a_(scale, scale, scale);
                for (int i = 0; i < count; ++i) {
                    matrix.func_227863_a_(QuaternionHelper.fromEuler(bell.func_145831_w().func_201674_k().nextFloat(), 1.0f, 0.0f, 0.0f));
                    matrix.func_227863_a_(QuaternionHelper.fromEuler(bell.func_145831_w().func_201674_k().nextFloat(), 0.0f, 1.0f, 0.0f));
                    matrix.func_227863_a_(QuaternionHelper.fromEuler(bell.func_145831_w().func_201674_k().nextFloat(), 0.0f, 0.0f, 1.0f));
                    matrix.func_227863_a_(QuaternionHelper.fromEuler(bell.func_145831_w().func_201674_k().nextFloat(), 1.0f, 0.0f, 0.0f));
                    matrix.func_227863_a_(QuaternionHelper.fromEuler(bell.func_145831_w().func_201674_k().nextFloat(), 0.0f, 1.0f, 0.0f));
                    matrix.func_227863_a_(QuaternionHelper.fromEuler(f * 90.0f, 0.0f, 0.0f, 1.0f));
                    float f2 = bell.func_145831_w().func_201674_k().nextFloat() * 20.0f + 5.0f + 2000.0f;
                    float f3 = bell.func_145831_w().func_201674_k().nextFloat() * 2.0f + 1.0f + 400.0f;
                    Matrix4f pose = matrix.func_227866_c_().func_227870_a_();
                    bufferBuilder.func_227888_a_(pose, 0.0f, 0.0f, 0.0f).func_227885_a_(1.0f, 0.84313726f, 0.0f, 0.45f).func_181675_d();
                    bufferBuilder.func_227888_a_(pose, -0.866f * f3, f2, -0.5f * f3).func_225586_a_(0, 0, 0, 0).func_181675_d();
                    bufferBuilder.func_227888_a_(pose, 0.866f * f3, f2, -0.5f * f3).func_225586_a_(0, 0, 0, 0).func_181675_d();
                    bufferBuilder.func_227888_a_(pose, 0.0f, f2, 1.0f * f3).func_225586_a_(0, 0, 0, 0).func_181675_d();
                    bufferBuilder.func_227888_a_(pose, -0.866f * f3, f2, -0.5f * f3).func_225586_a_(0, 0, 0, 0).func_181675_d();
                }
                matrix.func_227865_b_();
            }
        }
    }

    public void renderModel(MatrixStack matrix, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay, GenericModelHolder<GenericSmdModel> model, ResourceLocation texture) {
        matrix.func_227860_a_();
        float rotate = -90.0f;
        float scale = 0.3f;
        matrix.func_227862_a_(scale, scale, scale);
        matrix.func_227861_a_(0.0, -1.3, 0.0);
        matrix.func_227863_a_(QuaternionHelper.fromEuler(rotate, 0.0f, 1.0f, 0.0f));
        matrix.func_227863_a_(QuaternionHelper.fromEuler(180.0f, 0.0f, 1.0f, 0.0f));
        this.renderSMD(matrix, buffer, (Model)model.getModel(), texture, combinedLight, combinedOverlay);
        matrix.func_227865_b_();
    }
}

