/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.render.layers;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.pixelmonmod.pixelmon.api.util.helpers.QuaternionHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.client.models.ModelHolder;
import com.pixelmonmod.pixelmon.client.models.blocks.GenericSmdModel;
import com.pixelmonmod.pixelmon.client.render.GenericModelHolder;
import com.pixelmonmod.pixelmon.client.render.PixelmonRendering;
import com.pixelmonmod.pixelmon.enums.EnumMegaItem;
import com.pixelmonmod.pixelmon.listener.EntityPlayerExtension;
import com.pixelmonmod.pixelmon.storage.extras.PixelExtrasData;
import com.pixelmonmod.pixelmon.storage.extras.PlayerExtraDataStore;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.PlayerRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.HandSide;
import net.minecraft.util.ResourceLocation;

public class LayerMegaItems
extends LayerRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>> {
    private static final ResourceLocation TEXTURE = ResourceLocationHelper.of("pixelmon:textures/playeritems/megabraceletoras.png");
    private static final ResourceLocation NECKLACE_TEXTURE = ResourceLocationHelper.of("pixelmon:textures/playeritems/boost_necklace.png");
    private static final ResourceLocation GLASSES_TEXTURE = ResourceLocationHelper.of("pixelmon:textures/playeritems/mega_glasses.png");
    private static final ResourceLocation ANCHOR_TEXTURE = ResourceLocationHelper.of("pixelmon:textures/playeritems/mega_anchor.png");
    private static final ResourceLocation DYNAMAX_TEXTURE = ResourceLocationHelper.of("pixelmon:textures/playeritems/dynamax_band.png");
    private static final ResourceLocation TIARA_TEXTURE = ResourceLocationHelper.of("pixelmon:textures/playeritems/mega_tiara.png");
    private final ModelHolder<GenericSmdModel> braceletModel = new GenericModelHolder<GenericSmdModel>("playeritems/megaitems/megabraceletoras.pqc");
    private final ModelHolder<GenericSmdModel> stoneModel = new GenericModelHolder<GenericSmdModel>("playeritems/megaitems/megabraceletorasstone.pqc");
    private final ModelHolder<GenericSmdModel> necklace = new GenericModelHolder<GenericSmdModel>("playeritems/megaitems/boost_necklace.pqc");
    private final ModelHolder<GenericSmdModel> glasses = new GenericModelHolder<GenericSmdModel>("playeritems/megaitems/mega_glasses.pqc");
    private final ModelHolder<GenericSmdModel> anchor = new GenericModelHolder<GenericSmdModel>("playeritems/megaitems/mega_anchor.pqc");
    private final ModelHolder<GenericSmdModel> dynamax = new GenericModelHolder<GenericSmdModel>("playeritems/megaitems/dynamax_band.pqc");
    private final ModelHolder<GenericSmdModel> tiara = new GenericModelHolder<GenericSmdModel>("playeritems/megaitems/mega_tiara.pqc");
    private final PlayerRenderer renderer;

    public LayerMegaItems(PlayerRenderer renderer) {
        super((IEntityRenderer)renderer);
        this.renderer = renderer;
    }

    public void render(MatrixStack matrix, IRenderTypeBuffer buffer, int packedLight, AbstractClientPlayerEntity player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!EntityPlayerExtension.isDefined((PlayerEntity)player)) {
            return;
        }
        float scale = 1.0f;
        int packedOverlay = LivingRenderer.func_229117_c_((LivingEntity)player, (float)0.0f);
        EnumMegaItem megaItem = EntityPlayerExtension.getPlayerMegaItem((PlayerEntity)player);
        if (megaItem == EnumMegaItem.Disabled || megaItem == EnumMegaItem.None || player.func_82150_aj()) {
            return;
        }
        if (megaItem == EnumMegaItem.BoostNecklace) {
            PixelExtrasData extras = PlayerExtraDataStore.get((PlayerEntity)player);
            if (!extras.isReady()) {
                return;
            }
            if (!extras.hasBoostedNecklace()) {
                megaItem = EnumMegaItem.BraceletORAS;
            }
        }
        ModelRenderer left = ((PlayerModel)this.renderer.func_217764_d()).field_178724_i;
        ModelRenderer body = ((PlayerModel)this.renderer.func_217764_d()).field_78115_e;
        ModelRenderer head = ((PlayerModel)this.renderer.func_217764_d()).field_78116_c;
        Minecraft.func_71410_x().func_213239_aq().func_76320_a("layer_mega_wear");
        matrix.func_227860_a_();
        if (megaItem == EnumMegaItem.BraceletORAS) {
            this.renderBracelet(left, HandSide.LEFT, player.func_225608_bj_(), matrix, buffer, packedLight, packedOverlay);
        } else if (megaItem == EnumMegaItem.DynamaxBand) {
            scale = 1.05f;
            if (!left.field_78804_l.isEmpty() && ((ModelRenderer.ModelBox)left.field_78804_l.get((int)0)).field_78248_d == 2.0f) {
                scale = 1.02f;
            }
            ((PlayerModel)this.renderer.func_217764_d()).func_225599_a_(HandSide.LEFT, matrix);
            matrix.func_227861_a_(0.0, (double)0.4f, 0.0);
            matrix.func_227862_a_(scale, scale, scale);
            matrix.func_227863_a_(QuaternionHelper.fromEuler(90.0f, 1.0f, 0.0f, 0.0f));
            matrix.func_227861_a_((double)-0.3f, 0.0, 0.875);
            IVertexBuilder vertices = buffer.getBuffer(PixelmonRendering.getSMDRenderType(DYNAMAX_TEXTURE));
            this.dynamax.getModel().getModel().animate();
            this.dynamax.getModel().render(matrix, vertices, packedLight, packedOverlay);
        } else if (megaItem == EnumMegaItem.BoostNecklace) {
            PixelExtrasData extras = PlayerExtraDataStore.get((PlayerEntity)player);
            float offset = -0.01f;
            float scaleBoost = -0.03f;
            if (extras.getSashType() != PixelExtrasData.SashType.NONE) {
                offset = -0.02f;
                scaleBoost = 0.0f;
            }
            if (extras.getRobeType() != PixelExtrasData.RobeType.NONE) {
                scaleBoost = 0.12f;
                offset = -0.03f;
            }
            body.func_228307_a_(matrix);
            matrix.func_227861_a_(0.0, 0.0, (double)offset);
            matrix.func_227862_a_(scale, scale, scale + scaleBoost);
            IVertexBuilder vertices = buffer.getBuffer(PixelmonRendering.getSMDRenderType(NECKLACE_TEXTURE));
            this.necklace.getModel().getModel().animate();
            this.necklace.getModel().render(matrix, vertices, packedLight, packedOverlay);
        } else if (megaItem == EnumMegaItem.MegaAnchor) {
            PixelExtrasData extras = PlayerExtraDataStore.get((PlayerEntity)player);
            float offset = -0.01f;
            float scaleBoost = -0.03f;
            scale = 1.0f;
            if (extras.getSashType() != PixelExtrasData.SashType.NONE) {
                offset = -0.02f;
                scaleBoost = 0.0f;
            }
            if (extras.getRobeType() != PixelExtrasData.RobeType.NONE) {
                scaleBoost = 0.12f;
                offset = -0.03f;
            }
            body.func_228307_a_(matrix);
            matrix.func_227861_a_(0.0, 0.0, (double)offset);
            matrix.func_227862_a_(scale, scale, scale + scaleBoost);
            IVertexBuilder vertices = buffer.getBuffer(PixelmonRendering.getSMDRenderType(ANCHOR_TEXTURE));
            this.anchor.getModel().getModel().animate();
            this.anchor.getModel().render(matrix, vertices, packedLight, packedOverlay);
        } else if (megaItem == EnumMegaItem.MegaGlasses) {
            head.func_228307_a_(matrix);
            matrix.func_227861_a_(0.0, 1.5, 0.0);
            matrix.func_227861_a_(0.0, (double)-1.72f, (double)-0.15f);
            matrix.func_227862_a_(0.62f, 0.62f, 0.62f);
            IVertexBuilder vertices = buffer.getBuffer(PixelmonRendering.getSMDRenderType(GLASSES_TEXTURE));
            this.glasses.getModel().getModel().animate();
            this.glasses.getModel().render(matrix, vertices, packedLight, packedOverlay);
        } else if (megaItem == EnumMegaItem.MegaTiara) {
            head.func_228307_a_(matrix);
            matrix.func_227861_a_(0.0, 1.5, 0.0);
            IVertexBuilder vertices = buffer.getBuffer(PixelmonRendering.getSMDRenderType(TIARA_TEXTURE));
            this.tiara.getModel().getModel().animate();
            this.tiara.getModel().render(matrix, vertices, packedLight, packedOverlay);
        }
        matrix.func_227865_b_();
        Minecraft.func_71410_x().func_213239_aq().func_76319_b();
    }

    void renderBracelet(ModelRenderer arm, HandSide side, boolean sneak, MatrixStack matrix, IRenderTypeBuffer buffer, int light, int overlay) {
        matrix.func_227860_a_();
        float scale = !arm.field_78804_l.isEmpty() && ((ModelRenderer.ModelBox)arm.field_78804_l.get((int)0)).field_78248_d == 2.0f ? 0.17f : 0.19f;
        ((PlayerModel)this.renderer.func_217764_d()).func_225599_a_(side, matrix);
        matrix.func_227861_a_(0.0, (double)0.4f, 0.0);
        matrix.func_227862_a_(scale, scale, scale);
        matrix.func_227861_a_((double)0.35f, 0.0, 0.0);
        IVertexBuilder vertices = buffer.getBuffer(PixelmonRendering.getSMDRenderType(TEXTURE));
        this.braceletModel.getModel().getModel().animate();
        this.braceletModel.getModel().render(matrix, vertices, light, overlay);
        vertices = buffer.getBuffer(PixelmonRendering.getSMDCulledRenderType(TEXTURE));
        this.stoneModel.getModel().getModel().animate();
        this.stoneModel.getModel().func_225598_a_(matrix, vertices, light, overlay, 1.0f, 1.0f, 1.0f, 0.4f);
        matrix.func_227865_b_();
    }
}

