/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.particle.systems;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.pixelmonmod.pixelmon.client.particle.ParticleArcanery;
import com.pixelmonmod.pixelmon.client.particle.ParticleSystem;
import com.pixelmonmod.pixelmon.client.particle.particles.Blob;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.opengl.GL11;

public class UltraWormhole
extends ParticleSystem {
    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void execute(MatrixStack matrix, Minecraft mc, World w, double x, double y, double z, float scale, boolean shiny, double ... args) {
        double posZ;
        double posY;
        double dy;
        int spokes;
        matrix.func_227860_a_();
        Tessellator tessellator = Tessellator.func_178181_a();
        long time = (long)args[1];
        long mod100 = time % 15L;
        double yaw = args[2] * (Math.PI / 180);
        double pitch = args[3] * (Math.PI / 180);
        RenderSystem.alphaFunc((int)516, (float)0.1f);
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        RenderSystem.depthMask((boolean)false);
        GL11.glEnable((int)2848);
        GL11.glHint((int)3154, (int)4354);
        BufferBuilder builder = tessellator.func_178180_c();
        Vector3d view = Minecraft.func_71410_x().field_71460_t.func_215316_n().func_216785_c();
        matrix.func_227861_a_(-view.field_72450_a, -view.field_72448_b, -view.field_72449_c);
        RenderSystem.lineWidth((float)1.0f);
        double[] cx = new double[9];
        double[] cy = new double[9];
        double[] cz = new double[9];
        double[] coords = new double[768];
        int coordsIndex = 0;
        Matrix4f mat = matrix.func_227866_c_().func_227870_a_();
        for (spokes = 0; spokes < 16; ++spokes) {
            double zFront = 0.0;
            double zBack = 0.1;
            float radiusDecay = 0.35f;
            double radius = 3.25;
            double dx = Math.cos(0.39269908169872414 * (double)spokes);
            dy = Math.sin(0.39269908169872414 * (double)spokes);
            for (int segments = 0; segments < 8; ++segments) {
                double radius2 = radius - (double)radiusDecay;
                coords[coordsIndex++] = x + dx * radius;
                coords[coordsIndex++] = y + dy * radius;
                coords[coordsIndex++] = z + zFront;
                coords[coordsIndex++] = x + dx * radius2;
                coords[coordsIndex++] = y + dy * radius2;
                coords[coordsIndex++] = z + zBack;
                if (segments == 0) {
                    cx[segments] = radius;
                    cy[segments] = radius;
                    cz[segments] = zFront;
                }
                if (spokes == 1) {
                    cx[segments + 1] = radius2;
                    cy[segments + 1] = radius2;
                    cz[segments + 1] = zBack;
                }
                zFront = zBack;
                zBack += 0.2 * (double)(segments + 1);
                radius -= (double)radiusDecay;
                radiusDecay -= 0.02f;
            }
        }
        coordsIndex = 0;
        for (spokes = 0; spokes < 16; ++spokes) {
            GL11.glHint((int)3154, (int)4354);
            builder.func_181668_a(3, DefaultVertexFormats.field_227850_m_);
            for (int segments = 0; segments < 8; ++segments) {
                for (int i = 0; i < 2; ++i) {
                    this.rotatePointAndDraw(mat, builder, coords[coordsIndex++], coords[coordsIndex++], coords[coordsIndex++], x, y, z, 1.0f, 1.0f, 1.0f, (float)segments / 9.0f, yaw, pitch);
                }
            }
            tessellator.func_78381_a();
        }
        for (int i = 0; i < 9; ++i) {
            if (i <= 1) continue;
            GL11.glHint((int)3154, (int)4354);
            builder.func_181668_a(3, DefaultVertexFormats.field_227850_m_);
            double ox = cx[i];
            double oy = cx[i];
            double oz = cz[i];
            if (i != 8) {
                ox = cx[i] + (cx[i + 1] - cx[i]) * ((double)mod100 / 15.0);
                oy = cy[i] + (cy[i + 1] - cy[i]) * ((double)mod100 / 15.0);
                oz = cz[i] + (cz[i + 1] - cz[i]) * ((double)mod100 / 15.0);
            }
            float a = (float)i / 9.0f * (i == 2 ? (float)mod100 / 15.0f * 2.0f : 1.0f);
            for (int spokes2 = 0; spokes2 < 17; ++spokes2) {
                double theta = 0.39269908169872414 * (double)(spokes2 == 16 ? 0 : spokes2);
                double dx = Math.cos(theta);
                double dy2 = Math.sin(theta);
                this.rotatePointAndDraw(mat, builder, x + ox * dx, y + oy * dy2, z + oz, x, y, z, 1.0f, 1.0f, 1.0f, a, yaw, pitch);
            }
            tessellator.func_78381_a();
        }
        int colorPattern = (int)args[0];
        int colorSpeed = 120;
        int determinant = ((int)args[1] + (int)w.func_82737_E() % (colorSpeed * 2)) % colorSpeed;
        for (int i = 0; i < 9; ++i) {
            RenderSystem.disableCull();
            if (i != 8) {
                for (int spokes3 = 0; spokes3 < 16; ++spokes3) {
                    int colorDeterminant = determinant + i * 4;
                    float r = this.calcRed(colorPattern, colorSpeed, colorDeterminant);
                    float g = this.calcGreen(colorPattern, colorSpeed, colorDeterminant);
                    float b = this.calcBlue(colorPattern, colorSpeed, colorDeterminant);
                    float a = 1.0f - 0.11f * (float)(i + 1);
                    GL11.glHint((int)3155, (int)4354);
                    builder.func_181668_a(7, DefaultVertexFormats.field_227850_m_);
                    double theta1 = 0.39269908169872414 * (double)spokes3;
                    double dx1 = Math.cos(theta1);
                    double dy1 = Math.sin(theta1);
                    double theta2 = 0.39269908169872414 * (double)(spokes3 + 1 == 16 ? 0 : spokes3 + 1);
                    double dx2 = Math.cos(theta2);
                    double dy2 = Math.sin(theta2);
                    this.rotatePointAndDraw(mat, builder, x + cx[7 - i] * dx1, y + cy[7 - i] * dy1, z + cz[7 - i], x, y, z, r, g, b, a, yaw, pitch);
                    this.rotatePointAndDraw(mat, builder, x + cx[7 - i] * dx2, y + cy[7 - i] * dy2, z + cz[7 - i], x, y, z, r, g, b, a, yaw, pitch);
                    this.rotatePointAndDraw(mat, builder, x + cx[7 - i + 1] * dx2, y + cy[7 - i + 1] * dy2, z + cz[7 - i + 1], x, y, z, r, g, b, a, yaw, pitch);
                    this.rotatePointAndDraw(mat, builder, x + cx[7 - i + 1] * dx1, y + cy[7 - i + 1] * dy1, z + cz[7 - i + 1], x, y, z, r, g, b, a, yaw, pitch);
                    tessellator.func_78381_a();
                }
            }
            RenderSystem.enableCull();
        }
        RenderSystem.lineWidth((float)1.0f);
        long seed = time - mod100 + (long)x + (long)y + (long)z;
        Random rand = new Random(seed);
        for (int bolts = 0; bolts < 3; ++bolts) {
            if (mod100 >= 7L) continue;
            int forks = rand.nextInt(5) + 5;
            double dx = x;
            dy = y;
            double dz = z + 5.5;
            float a = 1.0f - 0.14285715f * (float)mod100;
            for (int i = 0; i < forks; ++i) {
                GL11.glHint((int)3154, (int)4354);
                builder.func_181668_a(3, DefaultVertexFormats.field_227850_m_);
                this.rotatePointAndDraw(mat, builder, x, dy, dz, x, y, z, 1.0f, 1.0f, 1.0f, a, yaw, pitch);
                this.rotatePointAndDraw(mat, builder, dx += (rand.nextDouble() * 2.0 - 1.0) / 2.0, dy += rand.nextDouble() * 2.0 - 1.0, dz -= rand.nextDouble() * 2.0, x, y, z, 1.0f, 1.0f, 1.0f, a, yaw, pitch);
                tessellator.func_78381_a();
                if (i <= 4) continue;
                GL11.glHint((int)3154, (int)4354);
                builder.func_181668_a(3, DefaultVertexFormats.field_227850_m_);
                this.rotatePointAndDraw(mat, builder, dx, dy, dz, x, y, z, 1.0f, 1.0f, 1.0f, a, yaw, pitch);
                this.rotatePointAndDraw(mat, builder, dx + (rand.nextDouble() * 2.0 - 1.0) / 2.0, dy + rand.nextDouble() * 2.0 - 1.0, dz + rand.nextDouble() * 2.0, x, y, z, 1.0f, 1.0f, 1.0f, a, yaw, pitch);
                tessellator.func_78381_a();
            }
        }
        double rad = 0.85;
        double posX = w.field_73012_v.nextDouble() * (rad * 2.0) - rad;
        if (Math.sqrt(posX * posX + (posY = w.field_73012_v.nextDouble() * (rad * 2.0) - rad) * posY + (posZ = w.field_73012_v.nextDouble() * (rad * 2.0) - rad) * posZ) <= rad) {
            double[] center = this.rotatePoint(x, y, z + 5.0, x, y, z, yaw, pitch);
            ParticleArcanery particle = new ParticleArcanery(center[0] + posX, center[1] + posY, center[2] + posZ, 0.0, 0.0, 0.0, new Blob(0.0, 0.0, 0.0, 0.0, 0.0f, 0.0f, 0.0f, true, 10, (int)args[0], 1.7f));
            particle.func_82338_g(0.05f);
            mc.field_71452_i.func_78873_a((Particle)particle);
        }
        GL11.glDisable((int)2848);
        RenderSystem.disableBlend();
        RenderSystem.enableTexture();
        RenderSystem.lineWidth((float)2.0f);
        matrix.func_227865_b_();
    }

    private double[] rotatePoint(double px, double py, double pz, double cx, double cy, double cz, double yaw, double pitch) {
        double rx = Math.cos(yaw) * (px - cx) - Math.sin(yaw) * (pz - cz) + cx;
        double rz = Math.sin(yaw) * (px - cx) + Math.cos(yaw) * (pz - cz) + cz;
        double ry = Math.sin(pitch) * (rz - cz) + Math.cos(pitch) * (py - cy) + cy;
        rz = Math.cos(pitch) * (rz - cz) - Math.sin(pitch) * (py - cy) + cz;
        return new double[]{rx, ry, rz};
    }

    private void rotatePointAndDraw(Matrix4f mat, BufferBuilder builder, double px, double py, double pz, double cx, double cy, double cz, float r, float g, float b, float a, double yaw, double pitch) {
        double[] points = this.rotatePoint(px, py, pz, cx, cy, cz, yaw, pitch);
        builder.func_227888_a_(mat, (float)points[0], (float)points[1], (float)points[2]).func_227885_a_(r, g, b, a).func_227886_a_(0xF000F0).func_181675_d();
    }

    private float calcChangingColor(int colorSpeed, int colorDeterminant) {
        float c1 = 1.0f / (float)colorSpeed;
        float c2 = c1 * (float)colorDeterminant;
        if (c2 > 0.5f) {
            float c3 = c2 - 0.5f;
            c2 -= c3 * 2.0f;
        }
        return MathHelper.func_76131_a((float)c2, (float)0.0f, (float)0.5f);
    }

    private float calcRed(int colorPattern, int colorSpeed, int colorDeterminant) {
        switch (colorPattern) {
            case 0: 
            case 1: {
                return this.calcChangingColor(colorSpeed, colorDeterminant);
            }
            case 2: 
            case 3: {
                return 0.2f;
            }
            case 4: 
            case 5: {
                return 0.7f;
            }
        }
        return 0.0f;
    }

    private float calcGreen(int colorPattern, int colorSpeed, int colorDeterminant) {
        switch (colorPattern) {
            case 2: 
            case 4: {
                return this.calcChangingColor(colorSpeed, colorDeterminant);
            }
            case 0: 
            case 5: {
                return 0.2f;
            }
            case 1: 
            case 3: {
                return 0.7f;
            }
        }
        return 0.0f;
    }

    private float calcBlue(int colorPattern, int colorSpeed, int colorDeterminant) {
        switch (colorPattern) {
            case 3: 
            case 5: {
                return this.calcChangingColor(colorSpeed, colorDeterminant);
            }
            case 1: 
            case 4: {
                return 0.2f;
            }
            case 0: 
            case 2: {
                return 0.7f;
            }
        }
        return 0.0f;
    }
}

