/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.particle.particles;

import com.google.common.primitives.Doubles;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.pixelmonmod.pixelmon.client.particle.ParticleArcanery;
import com.pixelmonmod.pixelmon.client.particle.ParticleEffect;
import com.pixelmonmod.pixelmon.client.render.PixelmonRendering;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public class Electric
extends ParticleEffect {
    private final int age;
    private final boolean parent;
    private final float pitch;
    private final float yaw;
    private final float velocity;
    private final float inaccuracy;
    private final float r;
    private final float g;
    private final float b;
    private final float a;

    public Electric(int age, boolean parent, float pitch, float yaw, float velocity, float inaccuracy, float r, float g, float b) {
        this.age = age;
        this.parent = parent;
        this.pitch = pitch;
        this.yaw = yaw;
        this.velocity = velocity;
        this.inaccuracy = inaccuracy;
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = 1.0f;
    }

    public Electric(int age, boolean parent, float pitch, float yaw, float velocity, float inaccuracy, float r, float g, float b, float a) {
        this.age = age;
        this.parent = parent;
        this.pitch = pitch;
        this.yaw = yaw;
        this.velocity = velocity;
        this.inaccuracy = inaccuracy;
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
    }

    @Override
    public void render(MatrixStack matrix, ParticleArcanery particle, IRenderTypeBuffer tessellator, float partialTicks) {
        if (!this.parent) {
            matrix.func_227860_a_();
            float a1 = 0.75f * this.a * (1.0f - (float)particle.getAge() / (float)particle.func_206254_h());
            float a2 = Math.max(0.75f * this.a * (1.0f - (float)particle.getAge() / (float)particle.func_206254_h()) - 0.3f, 0.0f);
            Vector3d view = Minecraft.func_71410_x().field_71460_t.func_215316_n().func_216785_c();
            matrix.func_227861_a_(-view.field_72450_a, -view.field_72448_b, -view.field_72449_c);
            IVertexBuilder buffer = tessellator.getBuffer(PixelmonRendering.getParticleTypes());
            Matrix4f mat = matrix.func_227866_c_().func_227870_a_();
            buffer.func_227888_a_(mat, (float)particle.getX(), (float)particle.getY(), (float)particle.getZ()).func_227885_a_(this.r, this.g, this.b, a2).func_227886_a_(0xF000F0).func_181675_d();
            buffer.func_227888_a_(mat, (float)particle.getPrevX(), (float)particle.getPrevY(), (float)particle.getPrevZ()).func_227885_a_(this.r, this.g, this.b, a2).func_227886_a_(0xF000F0).func_181675_d();
            buffer.func_227888_a_(mat, (float)particle.getX(), (float)particle.getY(), (float)particle.getZ()).func_227885_a_(this.r, this.g, this.b, a1).func_227886_a_(0xF000F0).func_181675_d();
            buffer.func_227888_a_(mat, (float)particle.getPrevX(), (float)particle.getPrevY(), (float)particle.getPrevZ()).func_227885_a_(this.r, this.g, this.b, a1).func_227886_a_(0xF000F0).func_181675_d();
            matrix.func_227865_b_();
            ((IRenderTypeBuffer.Impl)tessellator).func_228462_a_(PixelmonRendering.getParticleTypes());
        }
    }

    @Override
    public boolean customRenderer() {
        return true;
    }

    @Override
    public void init(ParticleArcanery particle, World world, double x, double y, double z, double vx, double vy, double vz, float size) {
        particle.setRGBA(1.0f, 1.0f, 1.0f, 0.8f * this.a);
        particle.setSize(0.05f);
        particle.func_187114_a(this.age);
        particle.func_187109_b(x, y, z);
        particle.setPrevPos(vx, vy, vz);
        this.setAim(this.pitch, this.yaw, this.velocity, this.inaccuracy, particle);
    }

    @Override
    public void update(ParticleArcanery particle) {
        if (this.parent) {
            particle.setPrevPos(particle.getX(), particle.getY(), particle.getZ());
            particle.func_187110_a(particle.getMotionX(), particle.getMotionY(), particle.getMotionZ());
            particle.func_187110_a((particle.getRandom().nextDouble() - 0.5) * Doubles.constrainToRange((double)(0.15 + (double)particle.getAge() / 3.0), (double)0.0, (double)1.75), (particle.getRandom().nextDouble() - 0.5) * Doubles.constrainToRange((double)(0.15 + (double)particle.getAge() / 3.0), (double)0.0, (double)1.75), (particle.getRandom().nextDouble() - 0.5) * Doubles.constrainToRange((double)(0.15 + (double)particle.getAge() / 3.0), (double)0.0, (double)1.75));
            ParticleArcanery child = new ParticleArcanery(particle.getX(), particle.getY(), particle.getZ(), particle.getPrevX(), particle.getPrevY(), particle.getPrevZ(), new Electric(8, false, 0.0f, 0.0f, 0.0f, 0.0f, this.r, this.g, this.b, this.a));
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)child);
        }
        particle.incrementAge();
        if (particle.getAge() >= particle.func_206254_h()) {
            particle.func_187112_i();
        }
    }

    @Override
    public ResourceLocation texture() {
        return null;
    }

    private void setAim(float pitch, float yaw, float velocity, float inaccuracy, ParticleArcanery particle) {
        float f = -MathHelper.func_76126_a((float)(yaw * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(pitch * ((float)Math.PI / 180)));
        float f1 = -MathHelper.func_76126_a((float)(pitch * ((float)Math.PI / 180)));
        float f2 = MathHelper.func_76134_b((float)(yaw * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(pitch * ((float)Math.PI / 180)));
        this.setHeading(f, f1, f2, velocity, inaccuracy, particle);
    }

    private void setHeading(double x, double y, double z, float velocity, float inaccuracy, ParticleArcanery particle) {
        float f = MathHelper.func_76133_a((double)(x * x + y * y + z * z));
        x /= (double)f;
        y /= (double)f;
        z /= (double)f;
        x += particle.getRandom().nextGaussian() * (double)0.0075f * (double)inaccuracy;
        y += particle.getRandom().nextGaussian() * (double)0.0075f * (double)inaccuracy;
        z += particle.getRandom().nextGaussian() * (double)0.0075f * (double)inaccuracy;
        particle.setMotion(x *= (double)velocity, y *= (double)velocity, z *= (double)velocity);
    }
}

