/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.models.smd;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.pixelmonmod.pixelmon.CommonProxy;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.util.RegexPatterns;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.client.models.smd.AnimationType;
import com.pixelmonmod.pixelmon.client.models.smd.Bone;
import com.pixelmonmod.pixelmon.client.models.smd.DeformVertex;
import com.pixelmonmod.pixelmon.client.models.smd.GabeNewellException;
import com.pixelmonmod.pixelmon.client.models.smd.SmdAnimation;
import com.pixelmonmod.pixelmon.client.models.smd.SmdAnimationSequence;
import com.pixelmonmod.pixelmon.client.models.smd.SmdModel;
import com.pixelmonmod.pixelmon.client.render.PixelmonRendering;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.util.ResourceLocation;

public class ValveStudioModel
extends Model {
    public static boolean debugModel = false;
    public SmdModel body;
    protected Bone root;
    ArrayList<Bone> allBones;
    public SmdAnimationSequence currentSequence;
    public ResourceLocation resource;
    public boolean overrideSmoothShading;
    public boolean hasChanged = true;
    private boolean hasAnimations = false;
    public HashMap<AnimationType, SmdAnimationSequence> anims = new HashMap(4);
    protected String materialPath;
    protected boolean usesMaterials = false;
    private float scale = -1.0f;

    public ValveStudioModel(ValveStudioModel model) {
        super(model.field_228281_q_);
        this.body = new SmdModel(model.body, this);
        for (Map.Entry<AnimationType, SmdAnimationSequence> entry : model.anims.entrySet()) {
            this.anims.put(entry.getKey(), new SmdAnimationSequence(entry.getKey(), entry.getValue().sequence, this));
        }
        this.hasAnimations = model.hasAnimations;
        this.usesMaterials = model.usesMaterials;
        this.scale = model.scale;
        this.resource = model.resource;
        this.currentSequence = this.anims.get((Object)AnimationType.IDLE);
        this.overrideSmoothShading = model.overrideSmoothShading;
    }

    public ValveStudioModel(ResourceLocation resource, boolean overrideSmoothShading) throws GabeNewellException {
        super(PixelmonRendering::getSMDRenderType);
        this.overrideSmoothShading = overrideSmoothShading;
        this.resource = resource;
        this.loadQC(resource);
        this.reformBones();
        this.precalculateAnimations();
    }

    public ValveStudioModel(ResourceLocation resource) throws GabeNewellException {
        this(resource, false);
    }

    public float getScale() {
        return this.scale;
    }

    public boolean hasAnimations() {
        return this.hasAnimations;
    }

    private void precalculateAnimations() {
        for (SmdAnimationSequence anim : this.anims.values()) {
            anim.precalculate(this.body);
        }
    }

    public void func_225598_a_(MatrixStack matrix, IVertexBuilder buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.body.render(matrix, buffer, packedLight, packedOverlay, Minecraft.func_71410_x().func_184121_ak(), red, green, blue, alpha);
        this.hasChanged = false;
    }

    void sendBoneData(SmdModel model) {
        this.allBones = model.bones;
        if (!model.isBodyGroupPart) {
            this.root = model.root;
        }
    }

    private void reformBones() {
        this.root.reformChildren();
        this.allBones.forEach(Bone::invertRestMatrix);
    }

    public void animate() {
        if (this.body.currentAnim == null) {
            this.setAnimation(AnimationType.IDLE);
        }
        this.resetVerts(this.body);
        this.root.setModified();
        this.hasChanged = true;
    }

    public void setAnimation(AnimationType animType) {
        this.currentSequence = this.anims.containsKey((Object)animType) ? this.anims.get((Object)animType) : this.anims.get((Object)AnimationType.IDLE);
        if (this.currentSequence != null) {
            this.body.setAnimation(this.currentSequence.current());
        } else {
            this.body.setAnimation(null);
        }
    }

    public void resetVerts(SmdModel model) {
        if (model == null) {
            return;
        }
        model.verts.forEach(DeformVertex::reset);
    }

    public static void print(Object o) {
    }

    private void loadQC(ResourceLocation resource) throws GabeNewellException {
        BufferedInputStream inputStream = CommonProxy.getStreamForResourceLocation(resource);
        if (inputStream == null) {
            Pixelmon.LOGGER.error("Couldn't find model at location " + resource.toString());
            return;
        }
        int lineCount = 0;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
            String animName;
            String currentLine;
            String[] bodyParams = null;
            ArrayList<String[]> animParams = new ArrayList<String[]>();
            while ((currentLine = reader.readLine()) != null) {
                ++lineCount;
                String[] params = RegexPatterns.MULTIPLE_WHITESPACE.split(currentLine);
                if (params[0].equalsIgnoreCase("$body")) {
                    bodyParams = params;
                    continue;
                }
                if (params[0].equalsIgnoreCase("$anim")) {
                    this.hasAnimations = true;
                    animParams.add(params);
                    continue;
                }
                if (params[0].equalsIgnoreCase("$cdmaterials")) {
                    this.usesMaterials = true;
                    this.materialPath = params[1];
                    continue;
                }
                if (!params[0].equalsIgnoreCase("$scale")) continue;
                this.scale = Float.parseFloat(params[1]);
            }
            if (this.scale == -1.0f) {
                this.scale = 1.0f;
                if (this.resource.func_110623_a().startsWith("models/pokemon")) {
                    Pixelmon.LOGGER.error("Model " + resource.func_110623_a() + " did not have a scale specified!");
                }
            }
            ResourceLocation modelPath = this.getResource((String)bodyParams[1]);
            this.body = new SmdModel(this, modelPath);
            HashMap<ResourceLocation, SmdAnimation> recognizedAnimations = new HashMap<ResourceLocation, SmdAnimation>();
            for (String[] animPars : animParams) {
                animName = animPars[1];
                ResourceLocation animPath = this.getResource(animPars[2]);
                if (recognizedAnimations.containsKey(animPath)) continue;
                SmdAnimation animation = new SmdAnimation(this, animName, animPath);
                recognizedAnimations.put(animPath, animation);
            }
            for (String[] animPars : animParams) {
                animName = animPars[1];
                ArrayList<SmdAnimation> sequence = new ArrayList<SmdAnimation>();
                for (int i = 2; i < animPars.length; ++i) {
                    ResourceLocation animPath = this.getResource(animPars[i]);
                    if (recognizedAnimations.containsKey(animPath)) {
                        sequence.add((SmdAnimation)recognizedAnimations.get(animPath));
                        continue;
                    }
                    if (!Pixelmon.isDevEnvironment()) continue;
                    Pixelmon.LOGGER.error("Animation file " + animPath + " was not registered in " + this.resource + "!");
                }
                AnimationType animType = AnimationType.getTypeFor(animName);
                this.anims.put(animType, new SmdAnimationSequence(animType, sequence, this));
                if (!animName.equalsIgnoreCase("idle")) continue;
                this.currentSequence = this.anims.get((Object)AnimationType.IDLE);
            }
        }
        catch (GabeNewellException e) {
            throw e;
        }
        catch (Exception e) {
            throw new GabeNewellException("An error occurred while reading the " + resource.toString() + " PQC file on line #" + lineCount, e);
        }
    }

    public ResourceLocation getResource(String fileName) {
        if (fileName.contains(":")) {
            ResourceLocation resourceLocation = ResourceLocation.func_208304_a((String)fileName);
            if (resourceLocation != null) {
                return resourceLocation;
            }
            Pixelmon.LOGGER.debug("There was an error attempting to load " + fileName + " (potentially invalid location check ResourceLocation specifications)");
        }
        String urlAsString = this.resource.func_110623_a();
        int lastIndex = urlAsString.lastIndexOf(47);
        String startString = urlAsString.substring(0, lastIndex);
        return ResourceLocationHelper.of("pixelmon", (startString + "/" + fileName).toLowerCase(Locale.ROOT));
    }
}

