/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.models.smd;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.pixelmonmod.pixelmon.CommonProxy;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.util.RegexPatterns;
import com.pixelmonmod.pixelmon.api.util.helpers.CommonHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.VectorHelper;
import com.pixelmonmod.pixelmon.client.models.smd.AnimFrame;
import com.pixelmonmod.pixelmon.client.models.smd.Bone;
import com.pixelmonmod.pixelmon.client.models.smd.DeformVertex;
import com.pixelmonmod.pixelmon.client.models.smd.GabeNewellException;
import com.pixelmonmod.pixelmon.client.models.smd.NormalizedFace;
import com.pixelmonmod.pixelmon.client.models.smd.SmdAnimation;
import com.pixelmonmod.pixelmon.client.models.smd.TextureCoordinate;
import com.pixelmonmod.pixelmon.client.models.smd.ValveStudioModel;
import com.pixelmonmod.pixelmon.tools.Matrix4f;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.minecraft.util.ResourceLocation;

public class SmdModel {
    public final ValveStudioModel owner;
    public ArrayList<NormalizedFace> faces = new ArrayList(0);
    public List<DeformVertex> verts = Collections.synchronizedList(new ArrayList(0));
    public ArrayList<Bone> bones = new ArrayList(0);
    public HashMap<String, Bone> nameToBoneMapping = new HashMap();
    public SmdAnimation currentAnim;
    private int vertexIDBank = 0;
    protected boolean isBodyGroupPart;
    int lineCount = -1;
    public Bone root;

    SmdModel(SmdModel model, ValveStudioModel owner) {
        Bone b;
        int i;
        this.owner = owner;
        this.isBodyGroupPart = model.isBodyGroupPart;
        for (NormalizedFace face : model.faces) {
            DeformVertex[] vertices = new DeformVertex[face.vertices.length];
            for (int i2 = 0; i2 < vertices.length; ++i2) {
                DeformVertex d = new DeformVertex(face.vertices[i2]);
                CommonHelper.ensureIndex(this.verts, d.ID);
                this.verts.set(d.ID, d);
            }
        }
        for (NormalizedFace face : model.faces) {
            this.faces.add(new NormalizedFace(face, this.verts));
        }
        for (i = 0; i < model.bones.size(); ++i) {
            b = model.bones.get(i);
            this.bones.add(new Bone(b, null, this));
        }
        for (i = 0; i < model.bones.size(); ++i) {
            b = model.bones.get(i);
            b.copy.setChildren(b, this.bones);
        }
        this.root = model.root.copy;
        owner.sendBoneData(this);
    }

    SmdModel(ValveStudioModel owner, ResourceLocation resloc) throws GabeNewellException {
        this.owner = owner;
        this.isBodyGroupPart = false;
        if (resloc.func_110623_a().endsWith(".bmd")) {
            this.loadBmdModel(resloc, null);
        } else {
            this.loadSmdModel(resloc, null);
        }
        this.setBoneChildren();
        this.determineRoot();
        owner.sendBoneData(this);
        ValveStudioModel.print("Number of vertices = " + this.verts.size());
    }

    SmdModel(ValveStudioModel owner, ResourceLocation resloc, SmdModel body) throws GabeNewellException {
        this.owner = owner;
        this.isBodyGroupPart = true;
        if (resloc.func_110623_a().endsWith(".bmd")) {
            this.loadBmdModel(resloc, body);
        } else {
            this.loadSmdModel(resloc, body);
        }
        this.setBoneChildren();
        this.determineRoot();
        owner.sendBoneData(this);
    }

    private void loadSmdModel(ResourceLocation resloc, SmdModel body) throws GabeNewellException {
        BufferedInputStream inputStream = CommonProxy.getStreamForResourceLocation(resloc);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
            String currentLine;
            this.lineCount = 0;
            while ((currentLine = reader.readLine()) != null) {
                ++this.lineCount;
                if (currentLine.startsWith("version")) continue;
                if (currentLine.startsWith("nodes")) {
                    ++this.lineCount;
                    while (!(currentLine = reader.readLine()).startsWith("end")) {
                        ++this.lineCount;
                        this.parseBone(currentLine, this.lineCount, body);
                    }
                    ValveStudioModel.print("Number of model bones = " + this.bones.size());
                    continue;
                }
                if (currentLine.startsWith("skeleton")) {
                    ++this.lineCount;
                    reader.readLine();
                    ++this.lineCount;
                    while (!(currentLine = reader.readLine()).startsWith("end")) {
                        ++this.lineCount;
                        if (this.isBodyGroupPart) continue;
                        this.parseBoneValues(currentLine, this.lineCount);
                    }
                    continue;
                }
                if (!currentLine.startsWith("triangles")) continue;
                ++this.lineCount;
                while (!(currentLine = reader.readLine()).startsWith("end")) {
                    String[] params = new String[3];
                    for (int i = 0; i < 3; ++i) {
                        ++this.lineCount;
                        params[i] = reader.readLine();
                    }
                    this.parseFace(params, this.lineCount);
                }
            }
        }
        catch (Exception e) {
            if (this.lineCount == -1) {
                throw new GabeNewellException("there was a problem opening the model file : " + resloc, e);
            }
            throw new GabeNewellException("an error occurred reading the SMD file \"" + resloc + "\" on line #" + this.lineCount, e);
        }
        ValveStudioModel.print("Number of faces = " + this.faces.size());
    }

    private void loadBmdModel(ResourceLocation modelLoc, SmdModel body) throws GabeNewellException {
        BufferedInputStream inputStream = CommonProxy.getStreamForResourceLocation(modelLoc);
        try (DataInputStream in = new DataInputStream(inputStream);){
            byte version = in.readByte();
            assert (version == 1);
            int numNodes = in.readShort();
            CommonHelper.ensureIndex(this.bones, numNodes - 1);
            for (int i = 0; i < numNodes; ++i) {
                short boneID = in.readShort();
                short parentBone = in.readShort();
                String name = SmdModel.readNullTerm(in);
                Bone parent = parentBone != -1 ? this.bones.get(parentBone) : null;
                this.bones.set(boneID, new Bone(name, boneID, parent, this));
            }
            short numSkeletons = in.readShort();
            for (short i = 0; i < numSkeletons; i = (short)(i + 1)) {
                int numBones = in.readShort();
                for (int j = 0; j < numBones; ++j) {
                    short boneId = in.readShort();
                    float locX = in.readFloat();
                    float locY = in.readFloat();
                    float locZ = in.readFloat();
                    float rotX = in.readFloat();
                    float rotY = in.readFloat();
                    float rotZ = in.readFloat();
                    Bone theBone = this.bones.get(boneId);
                    theBone.setRest(Matrix4f.fromVanilla(VectorHelper.matrix4FromLocRot(locX, -locY, -locZ, rotX, -rotY, -rotZ)));
                }
            }
            ArrayList<String> material = new ArrayList<String>();
            int numMaterial = in.readShort();
            for (int i = 0; i < numMaterial; ++i) {
                material.add(SmdModel.readNullTerm(in));
            }
            int vertexCount = 0;
            int numTriangles = in.readShort();
            for (int i = 0; i < numTriangles; ++i) {
                String mat = (String)material.get(in.readByte());
                DeformVertex[] faceVerts = new DeformVertex[3];
                TextureCoordinate[] uvs = new TextureCoordinate[3];
                for (int j = 0; j < 3; ++j) {
                    in.readShort();
                    float x = in.readFloat();
                    float y = -in.readFloat();
                    float z = -in.readFloat();
                    float normX = in.readFloat();
                    float normY = -in.readFloat();
                    float normZ = -in.readFloat();
                    float u = in.readFloat();
                    float v = in.readFloat();
                    int id = vertexCount++;
                    DeformVertex dv = this.getExisting(x, y, z, u, v);
                    faceVerts[j] = dv == null ? new DeformVertex(x, y, z, normX, normY, normZ, this.vertexIDBank, u, v) : dv;
                    int links = in.readByte();
                    for (int w = 0; w < links; ++w) {
                        short boneID = in.readShort();
                        float weight = in.readFloat();
                        this.bones.get(boneID).addVertex(faceVerts[j], weight);
                    }
                    CommonHelper.ensureIndex(this.verts, id);
                    this.verts.set(id, faceVerts[j]);
                    uvs[j] = new TextureCoordinate(u, 1.0f - v);
                }
                NormalizedFace face = new NormalizedFace(faceVerts, uvs);
                face.vertices = faceVerts;
                face.textureCoordinates = uvs;
                this.faces.add(face);
            }
        }
        catch (IOException e) {
            throw new GabeNewellException("An error occurred while reading BMD " + modelLoc.func_110623_a(), e);
        }
    }

    private void parseBone(String line, int lineCount, SmdModel body) {
        Bone theBone;
        String[] params = line.split("\"");
        int id = Integer.parseInt(RegexPatterns.SPACE_SYMBOL.matcher(params[0]).replaceAll(""));
        String boneName = params[1];
        Bone bone = theBone = body != null ? body.getBoneByName(boneName) : null;
        if (theBone == null) {
            int parentID = Integer.parseInt(RegexPatterns.SPACE_SYMBOL.matcher(params[2]).replaceAll(""));
            Bone parent = parentID >= 0 ? this.bones.get(parentID) : null;
            theBone = new Bone(boneName, id, parent, this);
        }
        CommonHelper.ensureIndex(this.bones, id);
        this.bones.set(id, theBone);
        this.nameToBoneMapping.put(boneName, theBone);
        ValveStudioModel.print(boneName);
    }

    private void parseBoneValues(String line, int lineCount) {
        String[] params = RegexPatterns.MULTIPLE_WHITESPACE.split(line);
        int id = Integer.parseInt(params[0]);
        float[] locRots = new float[6];
        for (int i = 1; i < 7; ++i) {
            locRots[i - 1] = Float.parseFloat(params[i]);
        }
        Bone theBone = this.bones.get(id);
        theBone.setRest(Matrix4f.fromVanilla(VectorHelper.matrix4FromLocRot(locRots[0], -locRots[1], -locRots[2], locRots[3], -locRots[4], -locRots[5])));
    }

    private void parseFace(String[] params, int lineCount) {
        DeformVertex[] faceVerts = new DeformVertex[3];
        TextureCoordinate[] uvs = new TextureCoordinate[3];
        for (int i = 0; i < 3; ++i) {
            String[] values = RegexPatterns.MULTIPLE_WHITESPACE.split(params[i]);
            float x = Float.parseFloat(values[1]);
            float y = -Float.parseFloat(values[2]);
            float z = -Float.parseFloat(values[3]);
            float xn = Float.parseFloat(values[4]);
            float yn = -Float.parseFloat(values[5]);
            float zn = -Float.parseFloat(values[6]);
            DeformVertex v = this.getExisting(x, y, z, 0.0f, 0.0f);
            if (v == null) {
                faceVerts[i] = new DeformVertex(x, y, z, xn, yn, zn, this.vertexIDBank, 0.0f, 0.0f);
                CommonHelper.ensureIndex(this.verts, this.vertexIDBank);
                this.verts.set(this.vertexIDBank, faceVerts[i]);
                ++this.vertexIDBank;
            } else {
                faceVerts[i] = v;
            }
            uvs[i] = new TextureCoordinate(Float.parseFloat(values[7]), 1.0f - Float.parseFloat(values[8]));
            if (values.length <= 10) continue;
            this.doBoneWeights(values, faceVerts[i]);
        }
        NormalizedFace face = new NormalizedFace(faceVerts, uvs);
        face.vertices = faceVerts;
        face.textureCoordinates = uvs;
        this.faces.add(face);
    }

    private DeformVertex getExisting(float x, float y, float z, float u, float v) {
        for (DeformVertex vertex : this.verts) {
            if (!vertex.equals(x, y, z, u, v)) continue;
            return vertex;
        }
        return null;
    }

    private void doBoneWeights(String[] values, DeformVertex vert) {
        int i;
        int links = Integer.parseInt(values[9]);
        float[] weights = new float[links];
        float sum = 0.0f;
        for (i = 0; i < links; ++i) {
            weights[i] = Float.parseFloat(values[i * 2 + 11]);
            sum += weights[i];
        }
        for (i = 0; i < links; ++i) {
            int boneID = Integer.parseInt(values[i * 2 + 10]);
            float weight = weights[i] / sum;
            this.bones.get(boneID).addVertex(vert, weight);
        }
    }

    private void setBoneChildren() {
        for (int i = 0; i < this.bones.size(); ++i) {
            Bone theBone = this.bones.get(i);
            this.bones.stream().filter(child -> child.parent == theBone).forEach(theBone::addChild);
        }
    }

    private void determineRoot() {
        for (Bone b : this.bones) {
            if (b.parent != null || b.children.isEmpty()) continue;
            this.root = b;
            break;
        }
        if (this.root == null) {
            for (Bone b : this.bones) {
                if (b.name.equals("blender_implicit")) continue;
                this.root = b;
                break;
            }
        }
    }

    public void setAnimation(SmdAnimation anim) {
        this.currentAnim = anim;
    }

    public Bone getBoneByID(int id) {
        try {
            return this.bones.get(id);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    public Bone getBoneByName(String name) {
        for (Bone b : this.bones) {
            if (!b.name.equals(name)) continue;
            return b;
        }
        return null;
    }

    public AnimFrame currentFrame() {
        return this.currentAnim == null ? null : (this.currentAnim.frames == null ? null : (this.currentAnim.frames.isEmpty() ? null : this.currentAnim.frames.get(this.currentAnim.currentFrameIndex)));
    }

    public void resetVerts() {
        this.verts.forEach(DeformVertex::reset);
    }

    public void render(MatrixStack matrixStack, IVertexBuilder buffer, int packedLight, int packedOverlay, float partialTick, float r, float g, float b, float a) {
        boolean smooth;
        boolean isPokeball = this.owner.resource.func_110623_a().contains("pokeballs");
        boolean bl = smooth = isPokeball ? PixelmonConfigProxy.getGraphics().isUseSmoothShadingOnPokeBalls() : PixelmonConfigProxy.getGraphics().isEnableSmoothPokemonShading();
        if (this.owner.overrideSmoothShading) {
            smooth = false;
        }
        this.buildVBO(matrixStack, buffer, packedLight, packedOverlay, smooth, partialTick, r, g, b, a);
    }

    private void buildVBO(MatrixStack matrixStack, IVertexBuilder builder, int packedLight, int packedOverlay, boolean smoothShading, float partialTick, float r, float g, float b, float a) {
        for (NormalizedFace face : this.faces) {
            face.addFaceForRender(matrixStack, builder, packedLight, packedOverlay, smoothShading, partialTick, r, g, b, a);
        }
    }

    private static String readNullTerm(DataInputStream in) throws IOException {
        StringBuilder str = new StringBuilder();
        char ch = '\u0000';
        do {
            if (ch == '\u0000') continue;
            str.append(ch);
        } while ((ch = in.readChar()) != '\u0000');
        return str.toString();
    }
}

