/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.models.smd;

import com.pixelmonmod.pixelmon.client.models.smd.Bone;
import com.pixelmonmod.pixelmon.client.models.smd.Vertex;
import com.pixelmonmod.pixelmon.tools.Matrix4f;
import com.pixelmonmod.pixelmon.tools.Vector4f;

public class DeformVertex
extends Vertex {
    protected final Vector4f baseLoc;
    public Vector4f currentLocMod;
    protected final Vector4f baseNormal;
    public Vector4f currentNormalMod;
    public Vector4f storage = new Vector4f();
    public Vector4f storageNorm = new Vector4f();
    private boolean reset = false;
    public float u;
    public float v;
    public final int ID;
    public int id2 = -1;
    public float xn;
    public float yn;
    public float zn;

    public DeformVertex(DeformVertex vertex) {
        super(vertex.x, vertex.y, vertex.z);
        this.xn = vertex.xn;
        this.yn = vertex.yn;
        this.zn = vertex.zn;
        this.u = vertex.u;
        this.v = vertex.v;
        this.baseLoc = new Vector4f(vertex.baseLoc);
        this.baseNormal = new Vector4f(vertex.baseNormal);
        this.ID = vertex.ID;
        this.currentLocMod = new Vector4f(vertex.currentLocMod);
        this.currentNormalMod = new Vector4f(vertex.currentNormalMod);
    }

    public DeformVertex(float x, float y, float z, float xn, float yn, float zn, int ID2, float u, float v) {
        super(x, y, z);
        this.xn = xn;
        this.yn = yn;
        this.zn = zn;
        this.baseLoc = new Vector4f(x, y, z, 1.0f);
        this.baseNormal = new Vector4f(xn, yn, zn, 0.0f);
        this.currentLocMod = new Vector4f(20.0f, 20.0f, 20.0f, 1.0f);
        this.currentNormalMod = new Vector4f(20.0f, 20.0f, 20.0f, 0.0f);
        this.ID = ID2;
        this.u = u;
        this.v = v;
    }

    public void reset() {
        this.reset = true;
        this.id2 = -1;
    }

    public void applyModified(Bone bone, float weight) {
        Matrix4f modified = bone.modified;
        if (modified != null) {
            if (this.reset) {
                this.currentLocMod.set(0.0f, 0.0f, 0.0f, 0.0f);
                this.currentNormalMod.set(0.0f, 0.0f, 0.0f, 0.0f);
                this.reset = false;
            }
            this.storage.set(0.0f, 0.0f, 0.0f, 0.0f);
            this.storageNorm.set(0.0f, 0.0f, 0.0f, 0.0f);
            Matrix4f.transform(modified, this.baseLoc, this.storage);
            Matrix4f.transform(modified, this.baseNormal, this.storageNorm);
            this.storage.scale(weight);
            this.storageNorm.scale(weight);
            Vector4f.add(this.storage, this.currentLocMod, this.currentLocMod);
            Vector4f.add(this.storageNorm, this.currentNormalMod, this.currentNormalMod);
        }
    }

    public void applyChange() {
        if (this.reset) {
            this.x = this.baseLoc.x;
            this.y = this.baseLoc.y;
            this.z = this.baseLoc.z;
        } else {
            this.x = this.currentLocMod.x;
            this.y = this.currentLocMod.y;
            this.z = this.currentLocMod.z;
        }
        if (this.reset) {
            this.xn = this.baseNormal.x;
            this.yn = this.baseNormal.y;
            this.zn = this.baseNormal.z;
        } else {
            this.xn = this.currentNormalMod.x;
            this.yn = this.currentNormalMod.y;
            this.zn = this.currentNormalMod.z;
        }
    }

    public boolean equals(float x, float y, float z, float u, float v) {
        return this.x == x && this.y == y && this.z == z && this.u == u && this.v == v;
    }

    public float getX(float partialTick) {
        return this.x;
    }

    public float getY(float partialTick) {
        return this.y;
    }

    public float getZ(float partialTick) {
        return this.z;
    }

    public float getXN(float partialTick) {
        return this.xn;
    }

    public float getYN(float partialTick) {
        return this.yn;
    }

    public float getZN(float partialTick) {
        return this.zn;
    }
}

