/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.models.items;

import com.google.common.collect.ImmutableList;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.SpriteItemHelper;
import com.pixelmonmod.pixelmon.client.render.PixelmonRendering;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.WeakHashMap;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.TransformationMatrix;
import net.minecraftforge.client.model.BakedItemModel;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.client.model.data.IModelData;

public class SpriteItemModel
implements IBakedModel {
    public static final ModelResourceLocation RESOURCE_LOCATION = new ModelResourceLocation("pixelmon:pixelmon_sprite", "inventory");
    private static final Map<ResourceLocation, IBakedModel> models = new WeakHashMap<ResourceLocation, IBakedModel>();
    private final IBakedModel model;
    private final OverrideList overrides = new OverrideList();

    public SpriteItemModel(IBakedModel model) {
        this.model = model;
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        return this.func_200117_a(state, side, rand);
    }

    public List<BakedQuad> func_200117_a(@Nullable BlockState state, @Nullable Direction side, Random rand) {
        return this.model.func_200117_a(state, side, rand);
    }

    public boolean func_177555_b() {
        return this.model.func_177555_b();
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_230044_c_() {
        return false;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.model.func_177554_e();
    }

    public ItemCameraTransforms func_177552_f() {
        return this.model.func_177552_f();
    }

    public ItemOverrideList func_188617_f() {
        return this.overrides;
    }

    public static IBakedModel getBakedModel(Pokemon pixelmon, IBakedModel originalModel) {
        if (pixelmon.getSprite() == null) {
            return originalModel;
        }
        ResourceLocation sprite = ResourceLocationHelper.of(pixelmon.getSprite().toString().replace(".png", "").replace("textures/", ""));
        IBakedModel model = models.get(sprite);
        if (model != null) {
            return model;
        }
        try {
            Function textureGetter = Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b);
            ImmutableList quads = ItemLayerModel.getQuadsForSprite((int)0, (TextureAtlasSprite)((TextureAtlasSprite)textureGetter.apply(sprite)), (TransformationMatrix)TransformationMatrix.func_227983_a_());
            BakedItemModel newModel = new BakedItemModel(quads, originalModel.func_177554_e(), PixelmonRendering.STANDARD_ITEM_TRANSFORMATIONS, ItemOverrideList.field_188022_a, true, false);
            models.put(sprite, (IBakedModel)newModel);
            return newModel;
        }
        catch (IllegalStateException | IndexOutOfBoundsException e) {
            return originalModel;
        }
    }

    static class OverrideList
    extends ItemOverrideList {
        @Nullable
        public IBakedModel func_239290_a_(IBakedModel originalModel, ItemStack stack, @Nullable ClientWorld world, @Nullable LivingEntity entity) {
            Optional<Pokemon> pokemon = SpriteItemHelper.getPokemon(stack);
            if (pokemon.isPresent()) {
                return SpriteItemModel.getBakedModel(pokemon.get(), originalModel);
            }
            return originalModel;
        }
    }
}

