/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.models;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.pixelmonmod.pixelmon.api.util.ResourceWithFallback;
import com.pixelmonmod.pixelmon.client.models.DualModelFactory;
import com.pixelmonmod.pixelmon.client.models.ModelCustomWrapper;
import com.pixelmonmod.pixelmon.client.models.PixelmonModelRenderer;
import com.pixelmonmod.pixelmon.client.models.PixelmonModelSmd;
import com.pixelmonmod.pixelmon.client.models.PixelmonSmdFactory;
import com.pixelmonmod.pixelmon.client.models.smd.AnimationType;
import com.pixelmonmod.pixelmon.client.models.smd.SmdAnimation;
import com.pixelmonmod.pixelmon.client.models.smd.ValveStudioModel;
import com.pixelmonmod.pixelmon.client.render.PixelmonRendering;
import com.pixelmonmod.pixelmon.entities.pixelmon.AbstractClientEntity;
import com.pixelmonmod.pixelmon.entities.pixelmon.helpers.animation.IncrementingVariable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;

public class DualModelDualTextureFactory
extends DualModelFactory {
    protected ResourceWithFallback texture2;

    public DualModelDualTextureFactory(ResourceWithFallback[] modelsAndTexture) {
        super(modelsAndTexture[0], modelsAndTexture[1]);
        this.texture2 = modelsAndTexture[2];
    }

    @Override
    public <T extends AbstractClientEntity> PixelmonModelSmd<T> createModel() {
        TransparentImpl impl = new TransparentImpl(this, DualModelDualTextureFactory.loadModel(this.model.get()), DualModelDualTextureFactory.loadModel(this.model2.get()), this.texture2.get());
        impl.body.func_78793_a(this.xRotation, this.yRotation, this.zRotation);
        impl.body.field_78795_f = this.rotateAngleX;
        impl.body.field_78796_g = this.rotateAngleY;
        impl.body2.func_78793_a(this.xRotation, this.yRotation, this.zRotation);
        impl.body2.field_78795_f = this.rotateAngleX;
        impl.body2.field_78796_g = this.rotateAngleY;
        impl.body2.setTransparent(this.transparency);
        impl.movementThreshold = this.movementThreshold;
        impl.animationIncrement = this.animationIncrement;
        return impl;
    }

    public static class TransparentImpl<T extends AbstractClientEntity>
    extends PixelmonSmdFactory.Impl<T> {
        protected PixelmonModelRenderer body2;
        protected ValveStudioModel model2;
        protected ResourceLocation texture2;
        protected boolean overloadTexture = false;

        TransparentImpl(PixelmonSmdFactory factory, ValveStudioModel model, ValveStudioModel model2, ResourceLocation texture2) {
            super(factory, model);
            this.model2 = model2;
            this.body2 = new PixelmonModelRenderer((Model)this, "body");
            this.body2.addCustomModel(new ModelCustomWrapper(model2));
            this.texture2 = texture2;
        }

        @Override
        public void setScale(float scale) {
            super.setScale(scale);
            this.body2.scale = scale;
        }

        public void overloadTexture() {
            this.overloadTexture = true;
        }

        @Override
        public void render(Entity entity, MatrixStack matrix, IVertexBuilder buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
            super.render(entity, matrix, buffer, packedLight, packedOverlay, red, green, blue, alpha);
            if (!this.overloadTexture) {
                buffer = this.buffer.getBuffer(PixelmonRendering.getSMDRenderType(this.texture2));
            }
            this.body2.func_228309_a_(matrix, buffer, packedLight, packedOverlay, red, green, blue, alpha);
            this.overloadTexture = false;
        }

        @Override
        protected void updateAnimation(IncrementingVariable variable) {
            SmdAnimation animation = this.theModel.currentSequence.checkForIncrement(variable);
            int frame = (int)Math.floor(variable.value % (float)animation.totalFrames);
            animation.setCurrentFrame(frame);
            animation = this.model2.currentSequence.checkForIncrement(variable);
            frame = (int)Math.floor(variable.value % (float)animation.totalFrames);
            animation.setCurrentFrame(frame);
            Minecraft.func_71410_x().func_213239_aq().func_76320_a("pixelmon_animate");
            this.theModel.animate();
            this.model2.animate();
            Minecraft.func_71410_x().func_213239_aq().func_76319_b();
        }

        @Override
        protected void setAnimation(AnimationType animType) {
            this.theModel.setAnimation(animType);
            this.model2.setAnimation(animType);
        }
    }
}

