/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.trainerCard;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.species.Pokedex;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.client.ClientProxy;
import com.pixelmonmod.pixelmon.client.gui.Resources;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.widgets.IndexedButton;
import com.pixelmonmod.pixelmon.client.storage.ClientStorageManager;
import com.pixelmonmod.pixelmon.comm.packetHandlers.trainerCard.RequestTrainerCardPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.trainerCard.TrainerCardColorPacket;
import com.pixelmonmod.pixelmon.enums.EnumTrainerCardColor;
import com.pixelmonmod.pixelmon.enums.EnumTrainerCardUser;
import com.pixelmonmod.pixelmon.storage.ClientData;
import java.text.NumberFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TrainerCardScreen
extends Screen {
    public PlayerEntity player;
    public Pokemon[] party = new Pokemon[6];
    public EnumTrainerCardColor color = EnumTrainerCardColor.WHITE;
    public EnumTrainerCardUser user;
    public String money = "0";
    public int caughtCount = 0;
    private static final int SPRITE_HEIGHT = 40;
    private static final int SPRITE_WIDTH = 40;
    private static final int POKEBALL_HEIGHT = 43;
    private static final int POKEBALL_WIDTH = 44;

    public TrainerCardScreen() {
        super(StringTextComponent.field_240750_d_);
        this.player = Minecraft.func_71410_x().field_71439_g;
        this.party = ClientStorageManager.party.getAll();
        this.color = ClientData.color;
        this.user = EnumTrainerCardUser.getFromPlayer(this.player);
        this.money = NumberFormat.getInstance().format(ClientData.playerMoney);
        this.caughtCount = ClientStorageManager.pokedex.countCaught();
    }

    public TrainerCardScreen(PlayerEntity player) {
        super(StringTextComponent.field_240750_d_);
        this.player = player;
        this.user = EnumTrainerCardUser.getFromPlayer(this.player);
        NetworkHelper.sendToServer(new RequestTrainerCardPacket(player.func_110124_au()));
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        this.field_230706_i_.func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
        if (this.player.equals((Object)this.field_230706_i_.field_71439_g)) {
            this.field_230710_m_.clear();
            int i = 0;
            for (EnumTrainerCardColor color : EnumTrainerCardColor.values()) {
                if (color == EnumTrainerCardColor.GOLD && this.user == EnumTrainerCardUser.REGULAR) {
                    return;
                }
                this.func_230480_a_((Widget)new ThemedButton(i, color, this.field_230708_k_ / 2 - 158 + 13 * i++, 205, this::actionPerformed));
            }
        }
    }

    public void func_230430_a_(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        int xOffset = this.field_230708_k_ / 2 - 165;
        int yOffset = 30;
        this.field_230706_i_.func_110434_K().func_110577_a(this.color.resource);
        AbstractGui.func_238463_a_((MatrixStack)matrix, (int)xOffset, (int)yOffset, (float)0.0f, (float)0.0f, (int)335, (int)195, (int)335, (int)195);
        if (this.user.resource != null) {
            this.field_230706_i_.func_110434_K().func_110577_a(this.user.resource);
            AbstractGui.func_238463_a_((MatrixStack)matrix, (int)(xOffset + 62), (int)(yOffset - 5), (float)0.0f, (float)0.0f, (int)200, (int)60, (int)200, (int)60);
        }
        int firstRowHeight = 67;
        int secondRowHeight = 103;
        this.drawPokemon(matrix, this.party[0], xOffset, yOffset, 12, 65, 15, firstRowHeight);
        this.drawPokemon(matrix, this.party[1], xOffset, yOffset, 58, 65, 61, firstRowHeight);
        this.drawPokemon(matrix, this.party[2], xOffset, yOffset, 105, 65, 108, firstRowHeight);
        this.drawPokemon(matrix, this.party[3], xOffset, yOffset, 12, 101, 15, secondRowHeight);
        this.drawPokemon(matrix, this.party[4], xOffset, yOffset, 58, 101, 61, secondRowHeight);
        this.drawPokemon(matrix, this.party[5], xOffset, yOffset, 105, 101, 108, secondRowHeight);
        this.field_230706_i_.func_110434_K().func_110577_a(Resources.pokedexItemIcon);
        AbstractGui.func_238463_a_((MatrixStack)matrix, (int)(xOffset + 169), (int)(yOffset + 108), (float)0.0f, (float)0.0f, (int)14, (int)14, (int)14, (int)14);
        this.field_230712_o_.func_238421_b_(matrix, this.caughtCount + "/" + Pokedex.pokedexSize, (float)(xOffset + 188), (float)(yOffset + 112), 1);
        this.field_230712_o_.func_238421_b_(matrix, "UUID: " + this.player.func_110124_au().toString(), (float)(xOffset + 46), (float)(yOffset + 153), 1);
        this.field_230712_o_.func_238421_b_(matrix, this.player.func_200200_C_().getString(), (float)(xOffset + 10), (float)(yOffset + 55), 1);
        this.field_230706_i_.func_110434_K().func_110577_a(Resources.pokedollar);
        AbstractGui.func_238463_a_((MatrixStack)matrix, (int)(xOffset + 169), (int)(yOffset + 84), (float)0.0f, (float)0.0f, (int)6, (int)9, (int)6, (int)9);
        this.field_230712_o_.func_238421_b_(matrix, this.money, (float)(xOffset + 177), (float)(yOffset + 84), 1);
        if (this.player == null) {
            matrix.func_227860_a_();
            matrix.func_227862_a_(2.5f, 2.5f, 0.0f);
            this.func_238474_b_(matrix, (this.field_230708_k_ - 290) / 4, this.field_230709_l_ / 2 + 15, 227, 242, 10, 14);
            matrix.func_227865_b_();
        } else {
            ScreenHelper.drawEntity(matrix, (LivingEntity)this.player, this.field_230708_k_ / 2 + 123, 151, 45.0f, 0.0f, 0.0f);
        }
        super.func_230430_a_(matrix, mouseX, mouseY, partialTicks);
    }

    private void drawPokemon(MatrixStack matrix, Pokemon pokemon, int xOffset, int yOffset, int ballX, int ballY, int pokeX, int pokeY) {
        if (pokemon != null) {
            this.field_230706_i_.func_110434_K().func_110577_a(pokemon.getBall().getGUISprite());
            AbstractGui.func_238463_a_((MatrixStack)matrix, (int)(xOffset + ballX), (int)(yOffset + ballY), (float)0.0f, (float)0.0f, (int)44, (int)43, (int)44, (int)43);
            if (pokemon.isEgg()) {
                this.field_230706_i_.func_110434_K().func_110577_a(ResourceLocationHelper.of(Resources.prefix + "sprites/eggs/egg1.png"));
            } else {
                ScreenHelper.bindPokemonSprite(pokemon, this.field_230706_i_);
            }
            AbstractGui.func_238463_a_((MatrixStack)matrix, (int)(xOffset + pokeX), (int)(yOffset + pokeY - 3), (float)0.0f, (float)0.0f, (int)40, (int)40, (int)40, (int)40);
        }
    }

    public boolean func_231177_au__() {
        return false;
    }

    protected void actionPerformed(Button button) {
        if (button instanceof ThemedButton) {
            ClientData.color = this.color = ((ThemedButton)button).color;
            NetworkHelper.sendToServer(new TrainerCardColorPacket(this.color));
        }
    }

    public boolean func_231042_a_(char typedChar, int keyCode) {
        if (keyCode == ClientProxy.trainerCardKeyBind.getKey().func_197937_c()) {
            this.field_230706_i_.field_71439_g.func_71053_j();
        }
        return super.func_231042_a_(typedChar, keyCode);
    }

    public void func_231164_f_() {
        this.field_230706_i_.func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
    }

    public static class ThemedButton
    extends IndexedButton {
        private static final ResourceLocation BUTTON = ResourceLocationHelper.of(Resources.prefix + "gui/trainercards/button.png");
        private EnumTrainerCardColor color;

        public ThemedButton(int buttonId, EnumTrainerCardColor color, int x, int y, Button.IPressable action) {
            super(buttonId, x, y, 10, 10, "", action);
            this.color = color;
        }

        public void func_230431_b_(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
            ScreenHelper.drawImage(BUTTON, matrix, (float)this.field_230690_l_, (float)this.field_230691_m_, (float)this.field_230688_j_, (float)this.field_230689_k_, this.color.red, this.color.green, this.color.blue, 1.0f, 1.0f);
        }
    }
}

