/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.battles.rules;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.battles.AcceptDenyScreen;
import com.pixelmonmod.pixelmon.client.gui.battles.rules.BattleRulesBaseScreen;
import com.pixelmonmod.pixelmon.client.gui.battles.rules.EnumRulesGuiState;
import com.pixelmonmod.pixelmon.client.gui.widgets.ChatExtensionScreen;
import com.pixelmonmod.pixelmon.client.gui.widgets.IndexedButton;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.AcceptDeclineBattlePacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.EnumBattleQueryResponse;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.rules.ProposeBattleRulesPacket;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class BattleRulesPlayerScreen
extends BattleRulesBaseScreen {
    private ChatExtensionScreen chat;
    private String opponentName = "";
    private int battleQueryID;
    private EnumRulesGuiState state;
    private Button proposeButton;
    private Button acceptButton;
    private Button changeButton;
    private Button declineButton;
    private int flashCounter;
    private static final int FLASH_DURATION = 30;

    public BattleRulesPlayerScreen(int battleQueryID, boolean isProposing) {
        PlayerEntity opponentEntity;
        this.battleQueryID = battleQueryID;
        this.state = isProposing ? EnumRulesGuiState.Propose : EnumRulesGuiState.WaitPropose;
        this.chat = new ChatExtensionScreen(this, 20);
        if (AcceptDenyScreen.opponent != null && (opponentEntity = this.field_230706_i_.field_71441_e.func_217371_b(AcceptDenyScreen.opponent.opponentUUID)) != null) {
            this.opponentName = opponentEntity.func_145748_c_().getString();
        }
        this.yChange = -15;
        this.clauseListHeight = 50;
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        this.chat.func_231160_c_();
        int buttonWidth = 60;
        int id = 0;
        this.proposeButton = new IndexedButton(id++, this.centerX - buttonWidth / 2, this.centerY + 60, buttonWidth, 20, (ITextComponent)new TranslationTextComponent("gui.battlerules.propose"), this::actionPerformed);
        this.acceptButton = new IndexedButton(id++, this.centerX - buttonWidth, this.centerY + 60, buttonWidth, 20, (ITextComponent)new TranslationTextComponent("gui.acceptdeny.accept"), this::actionPerformed);
        this.changeButton = new IndexedButton(id++, this.centerX, this.centerY + 60, buttonWidth, 20, (ITextComponent)new TranslationTextComponent("gui.battlerules.change"), this::actionPerformed);
        this.declineButton = new IndexedButton(id++, this.centerX + 200 - buttonWidth, this.centerY + 60, buttonWidth, 20, (ITextComponent)new TranslationTextComponent("gui.acceptdeny.deny"), this::actionPerformed);
        this.func_230480_a_((Widget)this.declineButton);
        this.changeState(this.state);
    }

    public void changeState(EnumRulesGuiState state) {
        this.state = state;
        switch (state) {
            case Propose: {
                this.field_230710_m_.remove(this.acceptButton);
                this.field_230710_m_.remove(this.changeButton);
                this.enableButton(this.proposeButton);
                this.editingEnabled = true;
                break;
            }
            case WaitPropose: 
            case WaitChange: 
            case WaitAccept: {
                this.field_230710_m_.remove(this.proposeButton);
                this.field_230710_m_.remove(this.acceptButton);
                this.field_230710_m_.remove(this.changeButton);
                this.editingEnabled = false;
                break;
            }
            case Accept: {
                this.field_230710_m_.remove(this.proposeButton);
                this.enableButton(this.acceptButton);
                this.enableButton(this.changeButton);
                this.editingEnabled = false;
            }
        }
    }

    private void enableButton(Button button) {
        if (!this.field_230710_m_.contains(button)) {
            this.func_230480_a_((Widget)button);
        }
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        this.chat.tick(this.field_230709_l_);
    }

    @Override
    public void func_230430_a_(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        this.chat.drawScreen(matrix, mouseX, mouseY, partialTicks);
        super.func_230430_a_(matrix, mouseX, mouseY, partialTicks);
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(MatrixStack matrix, float partialTicks, int mouseX, int mouseY) {
        super.drawGuiContainerBackgroundLayer(matrix, partialTicks, mouseX, mouseY);
        if (this.state != EnumRulesGuiState.Propose) {
            boolean isWaiting;
            this.dimScreen(matrix);
            String langKey = "";
            int textColor = 0;
            switch (this.state) {
                case WaitAccept: {
                    langKey = "gui.battlerules.waitaccept";
                    break;
                }
                case WaitPropose: {
                    langKey = "gui.battlerules.waitpropose";
                    break;
                }
                case WaitChange: {
                    langKey = "gui.battlerules.waitchange";
                    break;
                }
            }
            int n = this.flashCounter++;
            if ((double)n >= 45.0) {
                this.flashCounter = 0;
            }
            if (!(isWaiting = this.state.isWaiting())) {
                this.highlightButtons(matrix, 80, 35);
            }
            if (this.flashCounter < 30 || !isWaiting) {
                ScreenHelper.drawCenteredString(matrix, I18n.func_135052_a((String)langKey, (Object[])new Object[]{this.opponentName}), (float)this.centerX, (float)(this.rectBottom - 30), textColor);
            }
        }
    }

    @Override
    protected int getBackgroundHeight() {
        return 200;
    }

    public void func_231165_f_(int vOffset) {
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        super.func_231046_a_(keyCode, scanCode, modifiers);
        return this.chat.func_231046_a_(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean func_231043_a_(double mouseX, double mouseY, double delta) {
        super.func_231043_a_(mouseX, mouseY, delta);
        return this.chat.func_231043_a_(mouseX, mouseY, delta);
    }

    @Override
    public boolean mouseClickedUnderMenus(double x, double y, int mouseButton) {
        super.mouseClickedUnderMenus(x, y, mouseButton);
        this.chat.func_231044_a_(x, y, mouseButton);
        return true;
    }

    @Override
    protected void actionPerformed(Button button) {
        super.actionPerformed(button);
        if (!button.field_230693_o_) {
            return;
        }
        if (button == this.proposeButton) {
            this.registerRules();
            NetworkHelper.sendToServer(new ProposeBattleRulesPacket(this.battleQueryID, this.rules));
        } else if (button == this.acceptButton) {
            NetworkHelper.sendToServer(new AcceptDeclineBattlePacket(this.battleQueryID, EnumBattleQueryResponse.Accept));
        } else if (button == this.changeButton) {
            NetworkHelper.sendToServer(new AcceptDeclineBattlePacket(this.battleQueryID, EnumBattleQueryResponse.Change));
        } else if (button == this.declineButton) {
            NetworkHelper.sendToServer(new AcceptDeclineBattlePacket(this.battleQueryID, EnumBattleQueryResponse.Decline));
            ScreenHelper.closeScreen();
        }
    }

    @Override
    public void func_231164_f_() {
        super.func_231164_f_();
        this.chat.func_231175_as__();
    }

    @Override
    public boolean func_231177_au__() {
        return false;
    }
}

