/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.battles.battleScreens;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.pixelmonmod.pixelmon.api.battles.BattleMode;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.battles.tasks.BattleMessagePacket;
import com.pixelmonmod.pixelmon.battles.tasks.BattleTaskPacket;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.battles.ClientBattleManager;
import com.pixelmonmod.pixelmon.client.gui.widgets.PixelmonWidget;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.renderer.texture.ITickable;
import net.minecraft.util.ResourceLocation;

public class BattleLogElement
extends PixelmonWidget
implements ITickable {
    private static final ResourceLocation LOG_UP = ResourceLocationHelper.of("pixelmon", "textures/gui/battle/log_up.png");
    private static final ResourceLocation LOG_DOWN = ResourceLocationHelper.of("pixelmon", "textures/gui/battle/log_down.png");
    protected boolean autoAcknowledge;
    private final ClientBattleManager bm;
    private final LinkedList<String> messageLog = new LinkedList();
    private int activeCounter = -1;
    private int scrollPos = -1;
    private String activeMessage = "";
    private BattleMode lastMode = BattleMode.WAITING;

    public BattleLogElement(ClientBattleManager bm) {
        this.bm = bm;
    }

    @Override
    public void drawElement(MatrixStack matrix, float scale) {
        int centerX = this.x + this.width / 2;
        int centerY = this.y + this.height / 2;
        ScreenHelper.drawImage(LOG_UP, matrix, (float)(centerX - 12), (float)this.y, 12.0f, 6.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
        ScreenHelper.drawImage(LOG_DOWN, matrix, (float)(centerX - 12), (float)(this.y + this.height - 8), 12.0f, 6.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
        LinkedList<String> lines = this.compileLines();
        if (!this.activeMessage.isEmpty() && this.scrollPos == -1) {
            List<String> active = ScreenHelper.splitString(this.activeMessage, this.width - 16);
            lines.addAll(active);
        }
        int activeHeight = centerY;
        if (this.scrollPos != -1) {
            activeHeight = this.y + this.height - 20;
        }
        for (int i = lines.size() - (this.scrollPos <= 0 ? 1 : this.scrollPos + 1); i >= 0; --i) {
            if (activeHeight < this.y + 10) continue;
            int gray = 220 - (lines.size() - i - (this.scrollPos == -1 ? 0 : this.scrollPos)) * (this.scrollPos == -1 ? 20 : 5);
            ScreenHelper.drawCenteredString(matrix, lines.get(i), (float)(centerX - 6), (float)activeHeight, gray + (gray << 16) + (gray << 8));
            activeHeight -= 10;
        }
    }

    public void func_110550_d() {
        this.activeCounter = Math.max(-1, this.activeCounter - 1);
        if (this.autoAcknowledge) {
            if (this.activeCounter == -1) {
                this.activeCounter = 80;
            } else if (this.activeCounter == 0) {
                this.acknowledge();
            }
        }
        if (this.bm.getMode() != this.lastMode) {
            this.lastMode = this.bm.getMode();
            this.activeMessage = "";
        }
    }

    public void drawElement(MatrixStack matrix, int x, int y, int width, int height, boolean autoAcknowledge) {
        this.setPosition(x, y, width, height);
        this.autoAcknowledge = autoAcknowledge;
        this.drawElement(matrix, this.scale);
    }

    public void setActiveMessage(String message) {
        this.activeMessage = message;
    }

    public void forceAddMessage(String message) {
        this.messageLog.push(message);
    }

    public void acknowledge() {
        BattleTaskPacket nextBattleTask = this.bm.getNextBattleTask();
        if (this.bm.hasMoreMessages() && nextBattleTask instanceof BattleMessagePacket && !this.bm.isProcessingTask() && ((BattleMessagePacket)nextBattleTask).getMessage() != null && !((BattleMessagePacket)nextBattleTask).isRead()) {
            String text = ((BattleMessagePacket)nextBattleTask).getMessage().getString();
            for (String line : text.split("\\n")) {
                this.messageLog.push(line);
            }
            ((BattleMessagePacket)nextBattleTask).markAsRead();
            if (this.messageLog.size() > 100) {
                this.messageLog.removeLast();
            }
        }
        this.bm.checkClearedMessages();
    }

    public boolean withinBounds(double mouseX, double mouseY) {
        return mouseX >= (double)this.x && mouseY >= (double)this.y && mouseX < (double)(this.x + this.width) && mouseY < (double)(this.y + this.height);
    }

    public boolean processUpDown(double mouseX, double mouseY) {
        if (this.withinBounds(mouseX, mouseY) && mouseX >= (double)((float)this.x + (float)this.width / 4.0f) && mouseX < (double)((float)(this.x + this.width) - (float)this.width / 4.0f)) {
            if (mouseY >= (double)this.y && mouseY < (double)(this.y + 10)) {
                if (this.compileLines().size() - 7 >= this.scrollPos) {
                    ++this.scrollPos;
                }
            } else if (mouseY >= (double)(this.y + this.height - 10) && mouseY < (double)(this.y + this.height)) {
                this.scrollPos = this.scrollPos <= 0 ? -1 : --this.scrollPos;
            } else {
                return false;
            }
            return true;
        }
        return false;
    }

    private LinkedList<String> compileLines() {
        List<String> message;
        LinkedList lines = Lists.newLinkedList();
        if (this.bm.hasMoreMessages() && this.bm.getNextBattleTask() instanceof BattleMessagePacket) {
            String text = ((BattleMessagePacket)this.bm.getNextBattleTask()).getMessage().getString();
            for (String string : text.split("\\n")) {
                message = ScreenHelper.splitString(string, this.width - 16);
                for (int i = message.size() - 1; i >= 0; --i) {
                    lines.push(message.get(i));
                }
            }
        }
        int messageIndex = 0;
        while (messageIndex < this.messageLog.size()) {
            message = ScreenHelper.splitString(this.messageLog.get(messageIndex++), this.width - 16);
            for (int i = message.size() - 1; i >= 0; --i) {
                lines.push(message.get(i));
            }
        }
        return lines;
    }
}

