/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.battles;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.pixelmonmod.pixelmon.api.pokemon.item.pokeball.PokeBallRegistry;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.battles.rules.TeamSelectScreen;
import com.pixelmonmod.pixelmon.entities.npcs.NPCEntity;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.StringTextComponent;

public abstract class VersusScreen
extends Screen {
    private static final ResourceLocation TOP_LEFT = ResourceLocationHelper.of("pixelmon:textures/gui/acceptdeny/opponent1.png");
    private static final ResourceLocation MIDDLE = ResourceLocationHelper.of("pixelmon:textures/gui/acceptdeny/opponent2.png");
    private static final ResourceLocation BOTTOM_RIGHT = ResourceLocationHelper.of("pixelmon:textures/gui/acceptdeny/opponent3.png");
    private static final ResourceLocation VS = ResourceLocationHelper.of("pixelmon:textures/gui/acceptdeny/opponent8.png");
    private static final ResourceLocation PLAYER_1_FRAME = ResourceLocationHelper.of("pixelmon:textures/gui/acceptdeny/player1frame.png");
    private static final ResourceLocation PLAYER_2_FRAME = ResourceLocationHelper.of("pixelmon:textures/gui/acceptdeny/player2frame.png");
    private static final ResourceLocation PLAYER_1_NAME = ResourceLocationHelper.of("pixelmon:textures/gui/acceptdeny/player1name.png");
    private static final ResourceLocation PLAYER_2_NAME = ResourceLocationHelper.of("pixelmon:textures/gui/acceptdeny/player2name.png");
    private static final ResourceLocation POKE_BALL_HOLDER = ResourceLocationHelper.of("pixelmon:textures/gui/acceptdeny/pokeballholder.png");
    protected int leftX;
    protected int topY;
    protected int ticks = 5;
    protected int offset1;
    protected int offset2;
    protected int playerPartyX;
    protected int playerPartyY;
    protected int opponentPartyX;
    protected int opponentPartyY;
    protected boolean isNPC;
    private ResourceLocation npcSkin;
    protected static final int GUI_WIDTH = 280;
    protected static final int GUI_HEIGHT = 182;
    public static final int PARTY_SEPARATOR = 12;

    protected VersusScreen() {
        super(StringTextComponent.field_240750_d_);
        this.field_230706_i_ = Minecraft.func_71410_x();
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        this.updateAnchors();
    }

    public void func_238651_a_(MatrixStack matrix, int v) {
    }

    public void func_231165_f_(int v) {
    }

    public void func_231023_e_() {
        try {
            super.func_231023_e_();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (this.ticks > 0) {
            --this.ticks;
        }
    }

    private void updateAnchors() {
        this.leftX = (this.field_230708_k_ - 280) / 2;
        this.topY = (this.field_230709_l_ - 182) / 2;
        this.offset1 = -this.ticks * 50;
        this.offset2 = -this.offset1;
        this.playerPartyX = this.leftX + 84;
        this.playerPartyY = this.topY + 27;
        this.opponentPartyX = this.leftX + 120;
        this.opponentPartyY = this.topY + 121;
    }

    public void func_230430_a_(MatrixStack matrix, int mouseX, int mouseY, float f) {
        this.updateAnchors();
        this.drawRectangle(matrix);
        this.drawEntity(matrix, PLAYER_1_NAME, PLAYER_1_FRAME, (LivingEntity)this.field_230706_i_.field_71439_g, this.field_230706_i_.field_71439_g.func_145748_c_().getString(), this.offset1, 76, 9, 19, 11, 16, 9, 82, 27, 92, 15, false);
        LivingEntity opponent = this.getOpponent();
        if (opponent == null) {
            return;
        }
        String opponentName = this.isNPC ? TeamSelectScreen.teamSelectPacket.npcName : opponent.func_145748_c_().getString();
        this.drawEntity(matrix, PLAYER_2_NAME, PLAYER_2_FRAME, opponent, opponentName, this.offset2, 56, 103, 202, 76, 199, 74, 118, 121, 188 - this.field_230706_i_.field_71466_p.func_78256_a(opponentName), 108, this.isNPC);
    }

    public boolean func_231177_au__() {
        return false;
    }

    protected abstract LivingEntity getOpponent();

    private void drawRectangle(MatrixStack matrix) {
        ScreenHelper.drawImageQuad(TOP_LEFT, matrix, this.leftX + this.offset1, this.topY, 280.0f, 182.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
        ScreenHelper.drawImageQuad(MIDDLE, matrix, this.leftX + this.offset2, this.topY, 280.0f, 182.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
        ScreenHelper.drawImageQuad(BOTTOM_RIGHT, matrix, this.leftX, this.topY, 280.0f, 182.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
        if (this.ticks == 0) {
            ScreenHelper.drawImageQuad(VS, matrix, this.leftX, this.topY + 2, 280.0f, 226.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    protected void drawEntity(MatrixStack matrix, ResourceLocation name, ResourceLocation frame, LivingEntity entity, String entityName, int tickOffset, int nameBoxX, int nameBoxY, int headX, int headY, int frameX, int frameY, int holderX, int holderY, int nameX, int nameY, boolean isCurrentNPC) {
        ScreenHelper.drawImageQuad(name, matrix, this.leftX + nameBoxX + tickOffset, this.topY + nameBoxY, 145.0f, 17.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
        this.drawEntity(matrix, entity, this.leftX + headX + tickOffset, this.topY + headY, isCurrentNPC);
        ScreenHelper.drawImageQuad(frame, matrix, this.leftX + frameX + tickOffset, this.topY + frameY, 65.0f, 65.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
        ScreenHelper.drawImageQuad(POKE_BALL_HOLDER, matrix, this.leftX + holderX + tickOffset, this.topY + holderY, 80.0f, 17.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
        this.field_230706_i_.field_71466_p.func_238421_b_(matrix, entityName, (float)(this.leftX + nameX + tickOffset), (float)(this.topY + nameY), 0xFFFFFF);
    }

    protected void drawPokeBalls(String[] pokeBalls, int startX, int startY, int tickOffset) {
        int pos = 0;
        for (String pid : pokeBalls) {
            if (!pid.isEmpty()) {
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                if (pid.startsWith("!")) {
                    pid = pid.replace("!", "");
                    RenderSystem.color4f((float)0.4f, (float)0.4f, (float)0.4f, (float)1.0f);
                }
                ItemStack pball = PokeBallRegistry.getPokeBall(pid).getValueUnsafe().getBallItem();
                this.field_230707_j_.func_175042_a(pball, startX + pos * 12 + tickOffset, startY);
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            ++pos;
        }
    }

    protected void drawOpponentPokeBalls(int numPokeBalls) {
        Object[] opponentPokeBalls = new String[numPokeBalls];
        Arrays.fill(opponentPokeBalls, "poke_ball");
        this.drawPokeBalls((String[])opponentPokeBalls, this.opponentPartyX, this.opponentPartyY, this.offset2);
    }

    protected void drawEntity(MatrixStack matrix, LivingEntity entity, int x, int y, boolean isCurrentNPC) {
        ResourceLocation skin = null;
        if (isCurrentNPC && entity instanceof NPCEntity) {
            NPCEntity npc = (NPCEntity)entity;
            if (!npc.bindTexture() && this.npcSkin == null) {
                this.npcSkin = ResourceLocationHelper.of(npc.getTexture());
            }
            skin = this.npcSkin;
        } else {
            skin = ((AbstractClientPlayerEntity)entity).func_110306_p();
        }
        if (skin != null) {
            this.field_230706_i_.func_110434_K().func_110577_a(skin);
        }
        if (skin != null) {
            ScreenHelper.simpleDrawImageQuad(matrix, x, y, 60.0f, 60.0f, 0.125f, 0.125f, 0.25f, 0.25f, 1.0f);
        }
    }
}

