/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks.tileentity;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.events.legendary.TimespaceEvent;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonFactory;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.util.EncounterData;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.WildPixelmonParticipant;
import com.pixelmonmod.pixelmon.blocks.machines.TimespaceAltarBlock;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.comm.packetHandlers.RotateEntityPacket;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.init.registry.TileEntityRegistration;
import com.pixelmonmod.pixelmon.items.heldItems.TimespaceOrbItem;
import java.util.UUID;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.eventbus.api.Event;

public class TimespaceAltarTileEntity
extends TileEntity
implements ITickableTileEntity {
    public EncounterData encounters = new EncounterData(PixelmonConfigProxy.getGeneral().getShrineEncounterMode());
    public Orb orbIn = Orb.NONE;
    public boolean chainIn = false;
    public boolean flutePlayed = false;
    private boolean spawning = false;
    public int timeSpent = 0;
    public boolean summoningShiny = false;
    public PlayerEntity summoningPlayer = null;
    public BlockState summoningState = null;

    public TimespaceAltarTileEntity() {
        super((TileEntityType)TileEntityRegistration.TIMESPACE_ALTAR.get());
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = new CompoundNBT();
        return this.func_189515_b(nbt);
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        this.func_230337_a_(state, tag);
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_218657_a("EncounterData", (INBT)this.encounters.write(new CompoundNBT()));
        nbt.func_74768_a("OrbIn", this.orbIn.ordinal());
        nbt.func_74757_a("ChainIn", this.chainIn);
        nbt.func_74757_a("FlutePlayed", this.flutePlayed);
        nbt.func_74768_a("TimeSpent", this.timeSpent);
        nbt.func_74757_a("IsShiny", this.summoningShiny);
        return nbt;
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.orbIn = Orb.values()[nbt.func_74762_e("OrbIn")];
        this.chainIn = nbt.func_74767_n("ChainIn");
        this.flutePlayed = nbt.func_74767_n("FlutePlayed");
        this.timeSpent = nbt.func_74762_e("TimeSpent");
        this.summoningShiny = nbt.func_74767_n("IsShiny");
        this.encounters = new EncounterData(PixelmonConfigProxy.getGeneral().getShrineEncounterMode());
        if (nbt.func_74764_b("EncounterData")) {
            this.encounters.read(nbt.func_74775_l("EncounterData"));
        }
        if (this.getTileData().func_74764_b("encounters")) {
            ListNBT data = this.getTileData().func_150295_c("encounters", 8);
            for (INBT base : data) {
                StringNBT str = (StringNBT)base;
                UUID uuid = UUID.fromString(str.func_150285_a_());
                this.encounters.addEncounter(uuid, 1L);
            }
            this.getTileData().func_82580_o("encounters");
        }
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(this.func_195044_w(), pkt.func_148857_g());
        this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
    }

    public void func_70296_d() {
        if (this.field_145850_b != null) {
            this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
        }
        super.func_70296_d();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void activate(PlayerEntity player, TimespaceAltarBlock block, BlockState state, ItemStack item) {
        if (!(this.orbIn == Orb.NONE && !this.chainIn || !player.func_225608_bj_() || this.orbIn != Orb.NONE && this.chainIn)) {
            if (this.orbIn != Orb.NONE) {
                if (Pixelmon.EVENT_BUS.post((Event)new TimespaceEvent.TakeOrb(player, this, item))) return;
                switch (this.orbIn) {
                    case PALKIA: {
                        player.func_191521_c(new ItemStack((IItemProvider)PixelmonItems.lustrous_orb));
                        break;
                    }
                    case DIALGA: {
                        player.func_191521_c(new ItemStack((IItemProvider)PixelmonItems.adamant_orb));
                        break;
                    }
                    case GIRATINA: {
                        player.func_191521_c(new ItemStack((IItemProvider)PixelmonItems.griseous_orb));
                        break;
                    }
                }
                this.orbIn = Orb.NONE;
                this.func_70296_d();
                return;
            } else {
                if (!this.chainIn || Pixelmon.EVENT_BUS.post((Event)new TimespaceEvent.TakeChain(player, this, item))) return;
                player.func_191521_c(new ItemStack((IItemProvider)PixelmonItems.red_chain));
                this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), SoundEvents.field_187713_n, SoundCategory.BLOCKS, 1.0f, 50.0f);
                this.chainIn = false;
                this.func_70296_d();
            }
            return;
        }
        if (item == null || item == ItemStack.field_190927_a) return;
        if (item.func_77973_b() instanceof TimespaceOrbItem || item.func_77973_b() == PixelmonItems.red_chain) {
            if (player.field_70170_p.field_72995_K) return;
            if (this.timeSpent == 0) {
                if (item.func_77973_b() instanceof TimespaceOrbItem) {
                    ItemStack stack = ItemStack.field_190927_a;
                    if (this.orbIn == Orb.PALKIA) {
                        stack = new ItemStack((IItemProvider)PixelmonItems.lustrous_orb, 1);
                    } else if (this.orbIn == Orb.DIALGA) {
                        stack = new ItemStack((IItemProvider)PixelmonItems.adamant_orb, 1);
                    } else if (this.orbIn == Orb.GIRATINA) {
                        stack = new ItemStack((IItemProvider)PixelmonItems.griseous_orb, 1);
                    }
                    if (stack != ItemStack.field_190927_a) {
                        if (Pixelmon.EVENT_BUS.post((Event)new TimespaceEvent.TakeOrb(player, this, stack))) return;
                        player.func_191521_c(stack);
                    }
                }
                if (item.func_77973_b() instanceof TimespaceOrbItem) {
                    if (!this.chainIn) {
                        ChatHandler.sendChat((Entity)player, "pixelmon.blocks.timespace.needchain", new Object[0]);
                        return;
                    }
                    if (Pixelmon.EVENT_BUS.post((Event)new TimespaceEvent.PlaceOrb(player, this, item))) return;
                    if (!this.encounters.canEncounter(player)) {
                        if (this.encounters.getMode().isTimedAccess()) {
                            ChatHandler.sendChat((Entity)player, "pixelmon.blocks.shrine.today", new Object[0]);
                            return;
                        } else {
                            ChatHandler.sendChat((Entity)player, "pixelmon.blocks.shrine.encountered", new Object[0]);
                        }
                        return;
                    }
                    this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), SoundEvents.field_187766_dk, SoundCategory.BLOCKS, 1.0f, 5.0f);
                    if (item.func_77973_b() == PixelmonItems.lustrous_orb) {
                        this.orbIn = Orb.PALKIA;
                    } else if (item.func_77973_b() == PixelmonItems.adamant_orb) {
                        this.orbIn = Orb.DIALGA;
                    } else if (item.func_77973_b() == PixelmonItems.griseous_orb) {
                        this.orbIn = Orb.GIRATINA;
                    }
                    this.func_70296_d();
                    if (!player.func_184812_l_()) {
                        item.func_190918_g(1);
                    }
                } else if (item.func_77973_b() == PixelmonItems.red_chain) {
                    if (Pixelmon.EVENT_BUS.post((Event)new TimespaceEvent.PlaceChain(player, this, item))) return;
                    if (!this.encounters.canEncounter(player)) {
                        if (this.encounters.getMode().isTimedAccess()) {
                            ChatHandler.sendChat((Entity)player, "pixelmon.blocks.shrine.today", new Object[0]);
                            return;
                        } else {
                            ChatHandler.sendChat((Entity)player, "pixelmon.blocks.shrine.encountered", new Object[0]);
                        }
                        return;
                    }
                    this.chainIn = true;
                    this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), SoundEvents.field_187713_n, SoundCategory.BLOCKS, 1.0f, 50.0f);
                    this.func_70296_d();
                    if (!player.func_184812_l_()) {
                        item.func_190918_g(1);
                    }
                }
            }
            if (this.orbIn == Orb.NONE || !this.chainIn || this.spawning || this.flutePlayed) return;
            this.summoningPlayer = player;
            this.summoningState = state;
            this.spawning = true;
            this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187810_eg, SoundCategory.NEUTRAL, 1.0f, 0.1f);
            this.summoningShiny = PixelmonConfigProxy.getSpawning().getShinyRate((RegistryKey<World>)this.field_145850_b.func_234923_W_()) > 0.0f && RandomHelper.getRandomChance(1.0f / PixelmonConfigProxy.getSpawning().getShinyRate((RegistryKey<World>)this.field_145850_b.func_234923_W_()));
            this.func_70296_d();
            return;
        } else if (this.chainIn && !this.spawning && !this.flutePlayed) {
            ItemStack chain = new ItemStack((IItemProvider)PixelmonItems.red_chain);
            if (Pixelmon.EVENT_BUS.post((Event)new TimespaceEvent.TakeChain(player, this, chain))) return;
            this.chainIn = false;
            player.func_191521_c(chain);
            this.func_70296_d();
            return;
        } else {
            ChatHandler.sendChat((Entity)player, "pixelmon.blocks.timespace.notorb", new Object[0]);
        }
    }

    public void func_73660_a() {
        block16: {
            block17: {
                PixelmonEntity startingPixelmon;
                float spawnRot;
                double zOffset;
                double xOffset;
                PixelmonEntity pixelmonEntity;
                block19: {
                    block18: {
                        if (!this.spawning && !this.flutePlayed || this.field_145850_b.field_72995_K) break block16;
                        ++this.timeSpent;
                        if (this.summoningPlayer == null) {
                            this.reset();
                            this.func_70296_d();
                            return;
                        }
                        if (this.timeSpent <= 200) break block17;
                        if (!this.spawning) break block18;
                        switch (this.orbIn) {
                            case PALKIA: {
                                pixelmonEntity = PokemonFactory.create(PixelmonSpecies.PALKIA.getValueUnsafe()).getOrCreatePixelmon(this.field_145850_b, 0.0, 0.0, 0.0);
                                pixelmonEntity.getPokemon().setHeldItem(new ItemStack((IItemProvider)PixelmonItems.lustrous_orb));
                                break block19;
                            }
                            case DIALGA: {
                                pixelmonEntity = PokemonFactory.create(PixelmonSpecies.DIALGA.getValueUnsafe()).getOrCreatePixelmon(this.field_145850_b, 0.0, 0.0, 0.0);
                                pixelmonEntity.getPokemon().setHeldItem(new ItemStack((IItemProvider)PixelmonItems.adamant_orb));
                                break block19;
                            }
                            case GIRATINA: {
                                pixelmonEntity = PokemonFactory.create(PixelmonSpecies.GIRATINA.getValueUnsafe()).getOrCreatePixelmon(this.field_145850_b, 0.0, 0.0, 0.0);
                                pixelmonEntity.getPokemon().setHeldItem(new ItemStack((IItemProvider)PixelmonItems.griseous_core));
                                break block19;
                            }
                            default: {
                                return;
                            }
                        }
                    }
                    pixelmonEntity = PokemonFactory.create(PixelmonSpecies.ARCEUS.getValueUnsafe()).getOrCreatePixelmon(this.field_145850_b, 0.0, 0.0, 0.0);
                    pixelmonEntity.getLvl().setLevel(80);
                }
                if (this.summoningShiny) {
                    pixelmonEntity.getPokemon().setPalette("shiny");
                }
                PlayerPartyStorage party = StorageProxy.getParty((ServerPlayerEntity)this.summoningPlayer);
                Direction rot = (Direction)this.func_195044_w().func_177229_b((Property)TimespaceAltarBlock.FACING);
                if (rot == Direction.EAST) {
                    xOffset = -4.5;
                    zOffset = 0.5;
                    spawnRot = 45.0f;
                } else if (rot == Direction.WEST) {
                    xOffset = 5.5;
                    zOffset = 0.5;
                    spawnRot = 225.0f;
                } else if (rot == Direction.NORTH) {
                    xOffset = 0.5;
                    zOffset = 4.5;
                    spawnRot = 135.0f;
                } else {
                    xOffset = 0.5;
                    zOffset = -5.5;
                    spawnRot = 315.0f;
                }
                TimespaceEvent.Summon.Pre pre = new TimespaceEvent.Summon.Pre(this.summoningPlayer, this, pixelmonEntity);
                if (Pixelmon.EVENT_BUS.post((Event)pre)) {
                    return;
                }
                if (this.spawning) {
                    this.encounters.registerEncounter(this.summoningPlayer);
                }
                if ((startingPixelmon = party.getAndSendOutFirstAblePokemon((Entity)this.summoningPlayer)) == null || BattleRegistry.getBattle(this.summoningPlayer) != null) {
                    this.spawnEntity(pre.getPixelmon(), (double)this.field_174879_c.func_177958_n() + xOffset, this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p() + zOffset, spawnRot);
                    Pixelmon.EVENT_BUS.post((Event)new TimespaceEvent.Summon.Post(this.summoningPlayer, this, pre.getPixelmon()));
                    this.reset();
                    this.func_70296_d();
                    return;
                }
                this.spawnEntity(pre.getPixelmon(), (double)this.field_174879_c.func_177958_n() + xOffset, this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p() + zOffset, spawnRot);
                Pixelmon.EVENT_BUS.post((Event)new TimespaceEvent.Summon.Post(this.summoningPlayer, this, pre.getPixelmon()));
                PlayerParticipant playerParticipant = new PlayerParticipant((ServerPlayerEntity)this.summoningPlayer, startingPixelmon);
                WildPixelmonParticipant wildPixelmonParticipant = new WildPixelmonParticipant(false, pre.getPixelmon());
                wildPixelmonParticipant.startedBattle = true;
                BattleRegistry.startBattle(playerParticipant, wildPixelmonParticipant);
                this.reset();
            }
            this.func_70296_d();
        }
    }

    public void reset() {
        this.orbIn = Orb.NONE;
        this.chainIn = false;
        this.spawning = false;
        this.flutePlayed = false;
        this.timeSpent = 0;
        this.summoningState = null;
        this.summoningPlayer = null;
        this.summoningShiny = false;
    }

    public void spawnEntity(PixelmonEntity pixelmonEntity, double x, double y, double z, float rotation) {
        if (this.func_145831_w() instanceof ServerWorld) {
            pixelmonEntity.func_70080_a(x, y, z, rotation, pixelmonEntity.field_70125_A);
            ((ServerWorld)this.func_145831_w()).func_217470_d((Entity)pixelmonEntity);
            NetworkHelper.sendToDimension(new RotateEntityPacket(pixelmonEntity.func_145782_y(), rotation, pixelmonEntity.field_70125_A), pixelmonEntity.field_70170_p);
            pixelmonEntity.func_213315_a(MoverType.SELF, new Vector3d(0.1, 0.1, 0.1));
            pixelmonEntity.field_70126_B = rotation;
            pixelmonEntity.field_70177_z = rotation;
        }
    }

    public static enum Orb {
        NONE,
        PALKIA,
        DIALGA,
        GIRATINA;

    }
}

