/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks.tileentity;

import com.pixelmonmod.pixelmon.blocks.tileentity.IFrameCounter;
import com.pixelmonmod.pixelmon.init.registry.TileEntityRegistration;
import com.pixelmonmod.pixelmon.items.FossilItem;
import java.util.UUID;
import net.minecraft.block.BlockState;
import net.minecraft.item.Item;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.world.server.ServerWorld;

public class FossilDisplayTileEntity
extends TileEntity
implements IFrameCounter {
    private FossilItem itemInDisplay = null;
    private UUID owner = null;
    public int renderPass = 0;
    public int frame = 0;

    public FossilDisplayTileEntity() {
        super((TileEntityType)TileEntityRegistration.FOSSIL_DISPLAY.get());
    }

    public void openGlass() {
        if (this.getLastFrame() != 30) {
            return;
        }
    }

    public void closeGlass() {
        if (this.getLastFrame() != 0 && this.getLastFrame() != 60) {
            return;
        }
    }

    public boolean isOpen() {
        return this.getLastFrame() == 0 || this.getLastFrame() == 60;
    }

    @Override
    public int getFrame() {
        return this.frame;
    }

    @Override
    public void setFrame(int frame) {
        this.frame = frame;
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        Item item = Item.func_150899_d((int)nbt.func_74762_e("ItemIn"));
        this.setItemInDisplay((Item)(item instanceof FossilItem ? item : null));
        this.setLastFrame(nbt.func_74762_e("frame"));
        if (nbt.func_74764_b("owner")) {
            this.owner = UUID.fromString(nbt.func_74779_i("owner"));
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("ItemIn", Item.func_150891_b((Item)this.itemInDisplay));
        if (this.frame > 30 || this.frame < 1) {
            nbt.func_74768_a("frame", 0);
        } else {
            nbt.func_74768_a("frame", 30);
        }
        if (this.owner != null) {
            nbt.func_74778_a("owner", this.owner.toString());
        }
        return nbt;
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = new CompoundNBT();
        this.func_189515_b(nbt);
        return nbt;
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189517_E_());
    }

    public void onLoad() {
        if (this.func_145830_o() && this.func_145831_w() instanceof ServerWorld) {
            ((ServerWorld)this.func_145831_w()).func_72863_F().func_217217_a(this.field_174879_c);
        }
    }

    public void sendAnimation(String str) {
        CompoundNBT nbt = new CompoundNBT();
        if (this.frame > 30 || this.frame < 1) {
            nbt.func_74768_a("frame", 0);
        } else {
            nbt.func_74768_a("frame", 30);
        }
        nbt.func_74778_a("Animation", str);
        SUpdateTileEntityPacket packet = new SUpdateTileEntityPacket(this.field_174879_c, 0, nbt);
        this.field_145850_b.func_73046_m().func_184103_al().func_148543_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 20.0, this.field_145850_b.func_234923_W_(), (IPacket)packet);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        CompoundNBT nbt = pkt.func_148857_g();
        if (nbt.func_150297_b("ItemIn", 3)) {
            Item item = Item.func_150899_d((int)nbt.func_74762_e("ItemIn"));
            this.setItemInDisplay((Item)(item instanceof FossilItem ? item : null));
        }
        this.setFrame(nbt.func_74762_e("frame"));
        if (nbt.func_150297_b("Animation", 8)) {
            if (nbt.func_74779_i("Animation").equals("open")) {
                this.openGlass();
            } else {
                this.closeGlass();
            }
        }
    }

    public UUID getOwnerUUID() {
        return this.owner;
    }

    public void setOwner(UUID owner) {
        this.owner = owner;
        this.func_70296_d();
    }

    public FossilItem getItemInDisplay() {
        return this.itemInDisplay;
    }

    public void setItemInDisplay(Item item) {
        if (item == null || item instanceof FossilItem) {
            this.itemInDisplay = (FossilItem)item;
            this.func_70296_d();
        }
    }

    public int getLastFrame() {
        return this.frame;
    }

    public void setLastFrame(int frame) {
        this.frame = frame;
    }
}

