/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks.multi;

import com.pixelmonmod.pixelmon.api.registries.PixelmonBlocks;
import com.pixelmonmod.pixelmon.api.util.helpers.BlockHelper;
import com.pixelmonmod.pixelmon.blocks.tileentity.FridgeTileEntity;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class FridgeBlock
extends ContainerBlock {
    public static final BooleanProperty OPEN = BooleanProperty.func_177716_a((String)"open");
    public static final DirectionProperty FACING = BlockStateProperties.field_208157_J;
    public static final VoxelShape SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)32.0, (double)16.0);

    public FridgeBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200943_b(0.5f).func_200947_a(SoundType.field_185852_e).func_226896_b_());
        this.func_180632_j((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)OPEN, (Comparable)Boolean.valueOf(false)));
    }

    public ActionResultType func_225533_a_(BlockState blockState, World world, BlockPos blockPos, PlayerEntity playerEntity, Hand hand, BlockRayTraceResult rayTraceResult) {
        if (hand == Hand.OFF_HAND) {
            return ActionResultType.PASS;
        }
        if (playerEntity instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)playerEntity;
            if (player.func_213453_ef()) {
                world.func_175656_a(blockPos, (BlockState)blockState.func_206870_a((Property)OPEN, (Comparable)Boolean.valueOf((Boolean)blockState.func_177229_b((Property)OPEN) == false)));
            }
            if (!player.func_213453_ef()) {
                FridgeTileEntity fridge = (FridgeTileEntity)world.func_175625_s(blockPos);
                player.func_213829_a((INamedContainerProvider)fridge);
                return ActionResultType.SUCCESS;
            }
        }
        return ActionResultType.PASS;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{OPEN}).func_206894_a(new Property[]{FACING});
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_220080_a(BlockState p_220080_1_, IBlockReader p_220080_2_, BlockPos p_220080_3_) {
        return 1.0f;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new FridgeTileEntity();
    }

    public BlockRenderType func_149645_b(BlockState p_149645_1_) {
        return BlockRenderType.MODEL;
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        return new ItemStack((IItemProvider)PixelmonBlocks.fridge);
    }

    public void func_196243_a(BlockState newState, World world, BlockPos pos, BlockState oldState, boolean p_196243_5_) {
        FridgeTileEntity tile;
        if (!newState.func_203425_a(oldState.func_177230_c()) && (tile = BlockHelper.getTileEntity(FridgeTileEntity.class, (IBlockReader)world, pos)) != null) {
            InventoryHelper.func_219961_a((World)world, (BlockPos)pos, tile.getContents());
            tile.func_174888_l();
        }
        super.func_196243_a(newState, world, pos, oldState, p_196243_5_);
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader p_196283_1_) {
        return new FridgeTileEntity();
    }

    public VoxelShape func_220053_a(BlockState p_220053_1_, IBlockReader p_220053_2_, BlockPos p_220053_3_, ISelectionContext p_220053_4_) {
        return SHAPE;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)super.func_196258_a(context).func_206870_a((Property)FACING, (Comparable)context.func_195992_f().func_176734_d());
    }

    public int func_200011_d(BlockState p_200011_1_, IBlockReader p_200011_2_, BlockPos p_200011_3_) {
        return super.func_200011_d(p_200011_1_, p_200011_2_, p_200011_3_);
    }

    public int getLightValue(BlockState state, IBlockReader world, BlockPos pos) {
        return 1;
    }

    public BlockState rotate(BlockState state, IWorld world, BlockPos pos, Rotation direction) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)direction.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror direction) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)direction.func_185803_b((Direction)state.func_177229_b((Property)FACING)));
    }
}

