/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks.machines;

import com.pixelmonmod.pixelmon.api.storage.PCStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.util.helpers.BlockHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.blocks.IBlockHasOwner;
import com.pixelmonmod.pixelmon.blocks.MultiBlock;
import com.pixelmonmod.pixelmon.blocks.enums.MultiBlockPosition;
import com.pixelmonmod.pixelmon.blocks.tileentity.PCTileEntity;
import com.pixelmonmod.pixelmon.comm.packetHandlers.OpenScreenPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.clientStorage.newStorage.pc.ClientChangeOpenPCPacket;
import com.pixelmonmod.pixelmon.enums.EnumGuiScreen;
import com.pixelmonmod.pixelmon.init.registry.SoundRegistration;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.DyeColor;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PCBlock
extends MultiBlock
implements IBlockHasOwner {
    private DyeColor color;

    public PCBlock(DyeColor color) {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_226896_b_().func_200943_b(2.5f), 1, 2.0, 1);
        this.color = color;
    }

    public BlockRenderType func_149645_b(BlockState state) {
        if (state.func_177229_b(MultiBlock.MULTIPOS) == MultiBlockPosition.BASE) {
            return BlockRenderType.MODEL;
        }
        return super.func_149645_b(state);
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (world.func_201670_d() || hand != Hand.MAIN_HAND) {
            return ActionResultType.SUCCESS;
        }
        pos = this.findBaseBlock((IBlockReader)world, new BlockPos.Mutable(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()), state);
        if (!(player.field_71070_bA instanceof PlayerContainer)) {
            return ActionResultType.FAIL;
        }
        PCTileEntity tileEntityPC = BlockHelper.getTileEntity(PCTileEntity.class, (IBlockReader)world, pos);
        PCStorage pc = StorageProxy.getPC((ServerPlayerEntity)player, tileEntityPC);
        StorageProxy.getParty((ServerPlayerEntity)player).retrieveAll("BlockInteract");
        NetworkHelper.sendPacket(new ClientChangeOpenPCPacket(pc.uuid), (ServerPlayerEntity)player);
        OpenScreenPacket.open(player, EnumGuiScreen.PC, new int[0]);
        world.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), (SoundEvent)SoundRegistration.PC.get(), SoundCategory.BLOCKS, 0.7f, 1.0f);
        return ActionResultType.SUCCESS;
    }

    @Override
    protected Optional<TileEntity> getTileEntity(IBlockReader world, BlockState state) {
        return Optional.of(new PCTileEntity());
    }

    @Override
    public void setOwner(BlockPos pos, PlayerEntity playerIn) {
        UUID playerID = playerIn.func_110124_au();
        PCTileEntity tileEntityPC = BlockHelper.getTileEntity(PCTileEntity.class, (IBlockReader)playerIn.func_130014_f_(), pos);
        tileEntityPC.setOwner(playerID);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_220080_a(BlockState p_220080_1_, IBlockReader p_220080_2_, BlockPos p_220080_3_) {
        return 1.0f;
    }

    @Override
    public int getLightValue(BlockState state, IBlockReader world, BlockPos pos) {
        return 1;
    }
}

