/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.block.EggBlockEvent;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonBuilder;
import com.pixelmonmod.pixelmon.api.pokemon.boss.BossTierRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.WildPixelmonParticipant;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class PokemonEggBlock
extends Block
implements IWaterLoggable {
    public static final IntegerProperty EGG = IntegerProperty.func_177719_a((String)"eggs", (int)1, (int)3);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    private static final VoxelShape ONE_EGG_AABB = Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)12.0, (double)7.0, (double)12.0);
    private static final VoxelShape MULTIPLE_EGGS_AABB = Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)7.0, (double)15.0);

    public PokemonEggBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200943_b(0.1f));
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)EGG, (Comparable)Integer.valueOf(1))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{EGG, WATERLOGGED});
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState blockstate = context.func_195991_k().func_180495_p(context.func_195995_a());
        return blockstate.func_203425_a((Block)this) ? (BlockState)blockstate.func_206870_a((Property)EGG, (Comparable)Integer.valueOf(Math.min(3, (Integer)blockstate.func_177229_b((Property)EGG) + 1))) : super.func_196258_a(context);
    }

    public VoxelShape func_220053_a(BlockState p_220053_1_, IBlockReader p_220053_2_, BlockPos p_220053_3_, ISelectionContext p_220053_4_) {
        return (Integer)p_220053_1_.func_177229_b((Property)EGG) > 1 ? MULTIPLE_EGGS_AABB : ONE_EGG_AABB;
    }

    public boolean func_196253_a(BlockState state, BlockItemUseContext context) {
        return context.func_195996_i().func_77973_b() == this.func_199767_j() && (Integer)state.func_177229_b((Property)EGG) < 3 || super.func_196253_a(state, context);
    }

    public boolean removedByPlayer(BlockState state, World world, BlockPos pos, PlayerEntity player, boolean willHarvest, FluidState fluid) {
        this.decreaseEggs(world, pos, world.func_180495_p(pos));
        this.sendPlayerFlying(pos, (Entity)player);
        this.spawnBoss(world, pos, player);
        return false;
    }

    public void func_180658_a(World level, BlockPos pos, Entity entity, float p_180658_4_) {
        super.func_180658_a(level, pos, entity, p_180658_4_);
        if (!(entity instanceof PlayerEntity)) {
            return;
        }
        this.decreaseEggs(level, pos, level.func_180495_p(pos));
        if (entity instanceof ServerPlayerEntity) {
            this.sendPlayerFlying(pos, entity);
            ServerLifecycleHooks.getCurrentServer().execute(() -> this.spawnBoss(level, pos, (PlayerEntity)entity));
        }
    }

    public void func_176199_a(World level, BlockPos pos, Entity entity) {
        if (!(entity instanceof PlayerEntity)) {
            return;
        }
        this.decreaseEggs(level, pos, level.func_180495_p(pos));
        if (entity instanceof ServerPlayerEntity) {
            this.sendPlayerFlying(pos, entity);
            ServerLifecycleHooks.getCurrentServer().execute(() -> this.spawnBoss(level, pos, (PlayerEntity)entity));
        }
    }

    private void decreaseEggs(World world, BlockPos pos, BlockState state) {
        if (!state.func_235901_b_((Property)EGG)) {
            return;
        }
        world.func_184133_a(null, pos, SoundEvents.field_203281_iz, SoundCategory.BLOCKS, 0.7f, 0.9f + world.field_73012_v.nextFloat() * 0.2f);
        int i = (Integer)state.func_177229_b((Property)EGG);
        if (i <= 1) {
            world.func_175655_b(pos, false);
        } else {
            world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)EGG, (Comparable)Integer.valueOf(i - 1)), 2);
            world.func_217379_c(2001, pos, Block.func_196246_j((BlockState)state));
        }
    }

    private void spawnBoss(World level, BlockPos pos, PlayerEntity player) {
        if (level.func_201670_d() || player.func_184812_l_()) {
            return;
        }
        PlayerPartyStorage party = StorageProxy.getParty((ServerPlayerEntity)player);
        if (party.getFirstBattleReadyPokemon() == null) {
            return;
        }
        Species species = this.getSpecies(level.func_226691_t_(pos));
        EggBlockEvent.SelectSpecies.Pre pre = new EggBlockEvent.SelectSpecies.Pre(level, pos, level.func_180495_p(pos), species);
        if (Pixelmon.EVENT_BUS.post((Event)pre)) {
            Pixelmon.EVENT_BUS.post((Event)new EggBlockEvent.SelectSpecies.Post(level, pos, pre.getState(), pre.getSpecies()));
            return;
        }
        Pixelmon.EVENT_BUS.post((Event)new EggBlockEvent.SelectSpecies.Post(level, pos, pre.getState(), pre.getSpecies()));
        if (species == null) {
            return;
        }
        Pokemon pokemon = PokemonBuilder.builder().species(pre.getSpecies()).level(100).build();
        PixelmonEntity pixelmon = new PixelmonEntity(level, pokemon);
        pixelmon.setBossTier(BossTierRegistry.getBossTierUnsafe("epic"));
        pixelmon.func_110163_bv();
        pixelmon.func_70107_b(pos.func_177984_a().func_177958_n(), pos.func_177984_a().func_177956_o(), pos.func_177984_a().func_177952_p());
        EggBlockEvent.BeginFight.Pre preFight = new EggBlockEvent.BeginFight.Pre(level, pos, level.func_180495_p(pos), pixelmon);
        if (Pixelmon.EVENT_BUS.post((Event)preFight)) {
            return;
        }
        level.func_217376_c((Entity)preFight.getEntity());
        Pokemon firstBattleReadyPokemon = party.getFirstBattleReadyPokemon();
        firstBattleReadyPokemon.getOrSpawnPixelmon((Entity)player);
        preFight.getEntity().startBattle(new WildPixelmonParticipant(preFight.getEntity()), new PlayerParticipant((ServerPlayerEntity)player, firstBattleReadyPokemon));
        Pixelmon.EVENT_BUS.post((Event)new EggBlockEvent.BeginFight.Post(level, pos, preFight.getState(), preFight.getEntity()));
    }

    @Nullable
    private Species getSpecies(Biome biome) {
        String biomeName = biome.getRegistryName().func_110623_a();
        if (biomeName.equalsIgnoreCase("ultra_crater")) {
            return PixelmonSpecies.CELESTEELA.orElse(PixelmonSpecies.BULBASAUR);
        }
        if (biomeName.equalsIgnoreCase("ultra_plant")) {
            return PixelmonSpecies.XURKITREE.orElse(PixelmonSpecies.BULBASAUR);
        }
        if (biomeName.equalsIgnoreCase("ultra_jungle")) {
            return PixelmonSpecies.BUZZWOLE.orElse(PixelmonSpecies.BULBASAUR);
        }
        if (biomeName.equalsIgnoreCase("ultra_desert")) {
            return PixelmonSpecies.PHEROMOSA.orElse(PixelmonSpecies.BULBASAUR);
        }
        if (biomeName.equalsIgnoreCase("ultra_forest")) {
            return PixelmonSpecies.KARTANA.orElse(PixelmonSpecies.BULBASAUR);
        }
        if (biomeName.equalsIgnoreCase("ultra_deep_sea")) {
            return PixelmonSpecies.NIHILEGO.orElse(PixelmonSpecies.BULBASAUR);
        }
        return null;
    }

    private void sendPlayerFlying(BlockPos blockPos, Entity entity) {
        Vector3d movementVector = entity.func_213303_ch().func_178788_d(new Vector3d((double)blockPos.func_177958_n() + 0.5, (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p() + 0.5));
        movementVector = movementVector.func_72432_b();
        Vector3d extraVerticalMovementVector = new Vector3d(movementVector.func_82615_a(), Math.max(movementVector.func_82617_b(), 0.3), movementVector.func_82616_c());
        entity.func_213309_a(2.0f, extraVerticalMovementVector);
    }
}

