/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.events.PokeLootEvent;
import com.pixelmonmod.pixelmon.api.registries.PixelmonBlocks;
import com.pixelmonmod.pixelmon.api.util.helpers.BlockHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.DropItemHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.blocks.IBlockHasOwner;
import com.pixelmonmod.pixelmon.blocks.enums.EnumPokeChestType;
import com.pixelmonmod.pixelmon.blocks.enums.EnumPokechestVisibility;
import com.pixelmonmod.pixelmon.blocks.tileentity.PokeChestTileEntity;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.entities.npcs.registry.DropItemRegistry;
import com.pixelmonmod.pixelmon.init.registry.SoundRegistration;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;

public class PokeChestBlock
extends ContainerBlock
implements IBlockHasOwner {
    public static final DirectionProperty FACING = BlockStateProperties.field_208157_J;
    private static final AxisAlignedBB AABB = new AxisAlignedBB((double)0.29f, 0.0, (double)0.29f, (double)0.72f, (double)0.44f, (double)0.72f);
    private final EnumPokeChestType type;

    public PokeChestBlock(EnumPokeChestType type) {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151592_s).func_226896_b_().func_200948_a(-1.0f, 6000000.0f));
        this.type = type;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{FACING});
    }

    public boolean func_149653_t(BlockState p_149653_1_) {
        return true;
    }

    public BlockState func_185499_a(BlockState p_185499_1_, Rotation p_185499_2_) {
        return (BlockState)p_185499_1_.func_206870_a((Property)FACING, (Comparable)p_185499_2_.func_185831_a((Direction)p_185499_1_.func_177229_b((Property)FACING)));
    }

    protected ItemStack getChestDrop() {
        switch (this.type) {
            case POKEBALL: {
                return DropItemRegistry.getTier1Drop();
            }
            case ULTRABALL: {
                return DropItemRegistry.getTier2Drop();
            }
            case MASTERBALL: {
                return DropItemRegistry.getTier3Drop();
            }
            case BEASTBALL: {
                return DropItemRegistry.getUltraSpaceDrop();
            }
        }
        return null;
    }

    private ItemStack getHiddenDrop() {
        int num = RandomHelper.rand.nextInt(100);
        if (num <= 50) {
            return DropItemRegistry.getTier1Drop();
        }
        if (num < 85) {
            return DropItemRegistry.getTier2Drop();
        }
        return DropItemRegistry.getTier3Drop();
    }

    private ItemStack[] getRandomDrops(EnumPokechestVisibility visibility) {
        if (visibility == EnumPokechestVisibility.Visible) {
            return new ItemStack[]{this.getChestDrop()};
        }
        return new ItemStack[]{this.getHiddenDrop()};
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (world.func_201670_d() || hand == Hand.OFF_HAND) {
            return ActionResultType.SUCCESS;
        }
        TileEntity tileEntity = world.func_175625_s(pos);
        if (!(tileEntity instanceof PokeChestTileEntity)) {
            return ActionResultType.SUCCESS;
        }
        PokeChestTileEntity pokeChest = (PokeChestTileEntity)tileEntity;
        UUID blockOwner = pokeChest.getOwner();
        UUID playerID = player.func_110124_au();
        if (playerID.equals(blockOwner)) {
            if (player.func_225608_bj_()) {
                pokeChest.setOwner(null);
                ChatHandler.sendChat((Entity)player, "pixelmon.blocks.ownerchanged", new Object[0]);
                return ActionResultType.SUCCESS;
            }
            ItemStack itemStack = player.func_184614_ca();
            if (!itemStack.func_190926_b()) {
                pokeChest.setCustomDrops(itemStack);
                pokeChest.setOwner(null);
                ChatHandler.sendChat((Entity)player, "pixelmon.blocks.chestset", new TranslationTextComponent(itemStack.func_77977_a() + ""));
                return ActionResultType.SUCCESS;
            }
            EnumPokechestVisibility visibility = pokeChest.getVisibility();
            String metaMode = "";
            if (visibility == EnumPokechestVisibility.Hidden) {
                pokeChest.setVisibility(EnumPokechestVisibility.Visible);
                metaMode = "Normal";
            } else {
                pokeChest.setVisibility(EnumPokechestVisibility.Hidden);
                metaMode = "Hidden";
            }
            ChatHandler.sendChat((Entity)player, "pixelmon.blocks.visible", metaMode);
            return ActionResultType.FAIL;
        }
        if (!pokeChest.canClaim(playerID)) {
            if (pokeChest.isTimeEnabled()) {
                ChatHandler.sendChat((Entity)player, "pixelmon.blocks.timedclaim", new Object[0]);
            } else {
                ChatHandler.sendChat((Entity)player, "pixelmon.blocks.claimedloot", new Object[0]);
            }
            return ActionResultType.SUCCESS;
        }
        ServerPlayerEntity playerMP = (ServerPlayerEntity)player;
        if (Pixelmon.EVENT_BUS.post((Event)new PokeLootEvent.Claim(playerMP, pokeChest))) {
            return ActionResultType.SUCCESS;
        }
        if (pokeChest.shouldBreakBlock()) {
            if (MinecraftForge.EVENT_BUS.post((Event)new BlockEvent.BreakEvent(world, pos, state, player))) {
                return ActionResultType.SUCCESS;
            }
            world.func_217377_a(pos, false);
        }
        ItemStack[] drops = pokeChest.isCustomDrop() ? pokeChest.getCustomDrops() : this.getRandomDrops(pokeChest.getVisibility());
        PokeLootEvent.GetDrops getDropsEvent = new PokeLootEvent.GetDrops(playerMP, pokeChest, drops);
        Pixelmon.EVENT_BUS.post((Event)getDropsEvent);
        drops = getDropsEvent.getDrops();
        ItemStack firstDrop = ItemStack.field_190927_a;
        for (ItemStack drop : drops) {
            ItemStack newDrop;
            PokeLootEvent.Drop dropEvent;
            if (drop == null || Pixelmon.EVENT_BUS.post((Event)(dropEvent = new PokeLootEvent.Drop(playerMP, pokeChest, newDrop = drop.func_77946_l())))) continue;
            if (firstDrop.func_190926_b()) {
                firstDrop = dropEvent.getDrop().func_77946_l();
            }
            DropItemHelper.giveItemStack(playerMP, dropEvent.getDrop(), false);
        }
        String itemName = drops.length == 0 || firstDrop.func_190926_b() ? "tile.poke_chest" : firstDrop.func_77973_b().func_200295_i(firstDrop).getString();
        ChatHandler.sendChat((Entity)player, "pixelmon.blocks.chestfound", new TranslationTextComponent(itemName));
        pokeChest.removeClaimer(playerID);
        pokeChest.addClaimer(playerID);
        world.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), (SoundEvent)SoundRegistration.POKELOOT_OBTAINED.get(), SoundCategory.BLOCKS, 0.2f, 1.0f);
        return ActionResultType.SUCCESS;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f());
    }

    public void func_196270_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player) {
        if (worldIn.func_201670_d()) {
            return;
        }
        PokeChestTileEntity pokeChest = (PokeChestTileEntity)worldIn.func_175625_s(pos);
        if (pokeChest == null || !Objects.equals(pokeChest.getOwner(), player.func_110124_au())) {
            return;
        }
        String mode = "pixelmon.blocks.chestmode";
        boolean chestMode = pokeChest.getChestMode();
        boolean dropMode = pokeChest.getDropMode();
        boolean timeEnabled = pokeChest.isTimeEnabled();
        if (!(chestMode || dropMode || timeEnabled)) {
            pokeChest.setChestOneTime(false);
            pokeChest.setDropOneTime(true);
            pokeChest.setTimeEnabled(false);
            mode = mode + "PL1D";
        } else if (!chestMode && dropMode && !timeEnabled) {
            pokeChest.setDropOneTime(true);
            pokeChest.setChestOneTime(false);
            pokeChest.setTimeEnabled(true);
            mode = mode + "TD";
        } else if (timeEnabled) {
            pokeChest.setTimeEnabled(false);
            pokeChest.setDropOneTime(true);
            pokeChest.setChestOneTime(true);
            mode = mode + "FCFS";
        } else if (chestMode && dropMode && !timeEnabled) {
            pokeChest.setChestOneTime(false);
            pokeChest.setDropOneTime(false);
            pokeChest.setTimeEnabled(false);
            mode = mode + "PUD";
        }
        ChatHandler.sendChat((Entity)player, "pixelmon.blocks.chestmode", new TranslationTextComponent(mode));
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        switch (this.type) {
            case POKEBALL: {
                return new ItemStack((IItemProvider)PixelmonBlocks.poke_chest);
            }
            case BEASTBALL: {
                return new ItemStack((IItemProvider)PixelmonBlocks.beast_chest);
            }
            case ULTRABALL: 
            case SPECIAL: {
                return new ItemStack((IItemProvider)PixelmonBlocks.ultra_chest);
            }
            case MASTERBALL: {
                return new ItemStack((IItemProvider)PixelmonBlocks.master_chest);
            }
        }
        return new ItemStack((IItemProvider)PixelmonBlocks.poke_chest);
    }

    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new PokeChestTileEntity();
    }

    public void func_225542_b_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        PokeChestTileEntity tile = BlockHelper.getTileEntity(PokeChestTileEntity.class, (IBlockReader)world, pos);
        if (tile == null) {
            return;
        }
        if (tile.getVisibility() == EnumPokechestVisibility.Hidden) {
            float rand = random.nextFloat() * 0.5f + 1.0f;
            double xVel = 0.1;
            double yVel = 0.2;
            double zVel = 0.1;
            world.func_195598_a((IParticleData)ParticleTypes.field_197590_A, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 1, xVel * (double)rand, yVel * (double)rand, zVel * (double)rand, 0.5);
        }
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return VoxelShapes.func_197881_a((AxisAlignedBB)AABB);
    }

    @Override
    public void setOwner(BlockPos pos, PlayerEntity playerIn) {
        UUID playerID = playerIn.func_110124_au();
        PokeChestTileEntity tile = BlockHelper.getTileEntity(PokeChestTileEntity.class, (IBlockReader)playerIn.field_70170_p, pos);
        tile.setOwner(playerID);
    }
}

