/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks;

import com.pixelmonmod.pixelmon.api.registries.PixelmonBlocks;
import com.pixelmonmod.pixelmon.blocks.GenericModelBlock;
import com.pixelmonmod.pixelmon.blocks.tileentity.BellTileEntity;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BellAttachment;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class BellBlock
extends GenericModelBlock {
    private static final AxisAlignedBB AABB = new AxisAlignedBB((double)0.16f, (double)0.38f, (double)0.16f, (double)0.84f, 1.0, (double)0.84f);
    public static final EnumProperty<BellAttachment> ATTACHMENT = BlockStateProperties.field_222511_P;
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    private final Type bell;

    public BellBlock(Type bell) {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151574_g).func_200948_a(5.0f, 20.0f));
        this.bell = bell;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return VoxelShapes.func_197881_a((AxisAlignedBB)AABB);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState blockstate;
        Direction direction = context.func_196000_l();
        BlockPos blockpos = context.func_195995_a();
        if (direction == Direction.DOWN && (blockstate = (BlockState)((BlockState)this.func_176223_P().func_206870_a(ATTACHMENT, (Comparable)BellAttachment.CEILING)).func_206870_a((Property)FACING, (Comparable)context.func_195992_f())).func_196955_c((IWorldReader)context.func_195991_k(), blockpos)) {
            return blockstate;
        }
        return null;
    }

    public Type getBell() {
        return this.bell;
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{FACING, ATTACHMENT});
    }

    @Override
    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new BellTileEntity(this.getBell());
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        TileEntity te;
        if (placer instanceof ServerPlayerEntity && (te = worldIn.func_175625_s(pos)) instanceof BellTileEntity) {
            BellTileEntity bell = (BellTileEntity)te;
            bell.owner = placer.func_110124_au();
            bell.func_70296_d();
        }
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        switch (this.bell) {
            case CLEAR: {
                return new ItemStack((IItemProvider)Item.func_150898_a((Block)PixelmonBlocks.clear_bell));
            }
            case TIDAL: {
                return new ItemStack((IItemProvider)Item.func_150898_a((Block)PixelmonBlocks.tidal_bell));
            }
        }
        return ItemStack.field_190927_a;
    }

    public static enum Type {
        TIDAL,
        CLEAR;

    }
}

