/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.tasks;

import com.pixelmonmod.pixelmon.battles.tasks.BattleTaskPacket;
import com.pixelmonmod.pixelmon.client.ClientProxy;
import com.pixelmonmod.pixelmon.client.gui.battles.ClientBattleManager;
import com.pixelmonmod.pixelmon.client.gui.battles.PixelmonClientData;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class HPIncreaseTask
extends BattleTaskPacket {
    private UUID pokemonUUID;
    private int level;
    private int currentHP;
    private int maxHP;

    public HPIncreaseTask() {
    }

    public HPIncreaseTask(UUID pokemonUUID, int level, int currentHP, int maxHP) {
        this.pokemonUUID = pokemonUUID;
        this.level = level;
        this.currentHP = currentHP;
        this.maxHP = maxHP;
    }

    @Override
    public boolean process(ClientBattleManager bm) {
        for (PixelmonClientData pixelmonClientData : ClientProxy.battleManager.displayedOurPokemon) {
            this.updatePokemon(pixelmonClientData, this);
        }
        for (PixelmonClientData pixelmonClientData : ClientProxy.battleManager.displayedEnemyPokemon) {
            this.updatePokemon(pixelmonClientData, this);
        }
        for (PixelmonClientData pokemon : ClientProxy.battleManager.fullOurPokemon) {
            this.updatePokemon(pokemon, this);
        }
        if (ClientProxy.battleManager.displayedAllyPokemon != null) {
            for (PixelmonClientData pixelmonClientData : ClientProxy.battleManager.displayedAllyPokemon) {
                this.updatePokemon(pixelmonClientData, this);
            }
        }
        return false;
    }

    private void updatePokemon(PixelmonClientData pokemon, HPIncreaseTask message) {
        if (pokemon != null && pokemon.pokemonUUID.equals(message.pokemonUUID)) {
            pokemon.level = message.level;
            pokemon.health.set((double)message.currentHP);
            pokemon.maxHealth = message.maxHP;
        }
    }

    @Override
    @Nullable
    public UUID getPokemonID() {
        return this.pokemonUUID;
    }

    @Override
    public void decode(PacketBuffer buf) {
        this.pokemonUUID = buf.func_179253_g();
        this.level = buf.readInt();
        this.currentHP = buf.readInt();
        this.maxHP = buf.readInt();
    }

    @Override
    public void encode(PacketBuffer buf) {
        buf.func_179252_a(this.pokemonUUID);
        buf.writeInt(this.level);
        buf.writeInt(this.currentHP);
        buf.writeInt(this.maxHP);
    }
}

