/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.status;

import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.battles.controller.GlobalStatusController;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.GlobalStatusBase;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import java.util.List;

public class TrickRoom
extends GlobalStatusBase {
    private transient int effectTurns = 5;

    public TrickRoom() {
        super(StatusType.TrickRoom);
    }

    @Override
    public void applyEffect(PixelmonWrapper user, PixelmonWrapper target) {
        if (user.bc.globalStatusController.removeGlobalStatus(this.type)) {
            user.bc.sendToAll("pixelmon.effect.trickroomnormal", new Object[0]);
        } else {
            user.bc.sendToAll("pixelmon.status.trickroom", user.getNickname());
            user.addGlobalStatus(new TrickRoom());
        }
    }

    @Override
    public void applyRepeatedEffect(GlobalStatusController globalStatusController) {
        if (--this.effectTurns <= 0) {
            globalStatusController.bc.sendToAll("pixelmon.status.trickroomreturntonormal", new Object[0]);
            globalStatusController.removeGlobalStatus(this);
        }
    }

    public boolean participantMovesFirst(PixelmonWrapper user, PixelmonWrapper target) throws Exception {
        int targetSpeed;
        int userSpeed = user.getBattleStats().getStatWithMod(BattleStatsType.SPEED);
        if (userSpeed > (targetSpeed = target.getBattleStats().getStatWithMod(BattleStatsType.SPEED))) {
            return false;
        }
        if (targetSpeed > userSpeed) {
            return true;
        }
        return RandomHelper.getRandomChance(50);
    }

    @Override
    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, List<MoveChoice> userChoices, List<MoveChoice> bestUserChoices, List<MoveChoice> opponentChoices, List<MoveChoice> bestOpponentChoices) {
        for (List<MoveChoice> choices : MoveChoice.splitChoices(pw.getOpponentPokemon(), bestOpponentChoices)) {
            if (MoveChoice.canOutspeed(choices, pw, bestUserChoices)) continue;
            return;
        }
        userChoice.raiseWeight(50.0f);
    }
}

