/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.status;

import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.log.AttackResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusBase;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import java.util.List;
import net.minecraft.util.text.TranslationTextComponent;

public class Torment
extends StatusBase {
    transient Attack lastAttack;

    public Torment() {
        super(StatusType.Torment);
    }

    @Override
    public void applyEffect(PixelmonWrapper user, PixelmonWrapper target) {
        if (target.hasStatus(this.type)) {
            user.bc.sendToAll("pixelmon.effect.effectfailed", new Object[0]);
            user.attack.moveResult.result = AttackResult.failed;
        } else {
            TranslationTextComponent message = ChatHandler.getMessage("pixelmon.status.torment", target.getNickname());
            target.addStatus(new Torment(), user, message);
        }
    }

    @Override
    public void onAttackUsed(PixelmonWrapper user, Attack attack) {
        this.lastAttack = attack;
    }

    @Override
    public void applyRepeatedEffect(PixelmonWrapper pw) {
        for (Attack attack : pw.getMoveset().attacks) {
            if (attack == null || !attack.equals(this.lastAttack)) continue;
            attack.setDisabled(true, pw);
        }
    }

    @Override
    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, List<MoveChoice> userChoices, List<MoveChoice> bestUserChoices, List<MoveChoice> opponentChoices, List<MoveChoice> bestOpponentChoices) {
        if (MoveChoice.getAffectedChoices(userChoice, bestOpponentChoices).size() <= 1) {
            userChoice.raiseWeight(20.0f);
        }
    }
}

