/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.status;

import com.pixelmonmod.pixelmon.api.battles.AttackCategory;
import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusBase;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.enums.heldItems.EnumHeldItems;

public class Telekinesis
extends StatusBase {
    private transient int effectTurns = 3;

    public Telekinesis() {
        super(StatusType.Telekinesis);
    }

    @Override
    public void applyEffect(PixelmonWrapper user, PixelmonWrapper target) {
        if (target.hasStatus(StatusType.Telekinesis, StatusType.Ingrain) || target.bc.globalStatusController.hasStatus(StatusType.Gravity) || target.getUsableHeldItem().getHeldItemType() == EnumHeldItems.ironBall) {
            target.bc.sendToAll("pixelmon.effect.effectfailed", new Object[0]);
        } else if (target.addStatus(new Telekinesis(), user)) {
            target.bc.sendToAll("pixelmon.status.telekinesis", target.getNickname());
        }
    }

    @Override
    public void applyRepeatedEffect(PixelmonWrapper pw) {
        if (--this.effectTurns <= 0) {
            pw.bc.sendToAll("pixelmon.status.telekinesisend", pw.getNickname());
            pw.removeStatus(this);
        }
    }

    @Override
    public int[] modifyPowerAndAccuracyTarget(int power, int accuracy, PixelmonWrapper user, PixelmonWrapper target, Attack a) {
        return new int[]{power, -1};
    }

    @Override
    public boolean stopsIncomingAttack(PixelmonWrapper pokemon, PixelmonWrapper user) {
        if (user.attack.getType().equals(Element.GROUND) && user.attack.getAttackCategory() != AttackCategory.STATUS && !pokemon.isGrounded()) {
            user.bc.sendToAll("pixelmon.battletext.noeffect", pokemon.getNickname());
            return true;
        }
        return false;
    }
}

