/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.status;

import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.controller.GlobalStatusController;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.log.AttackResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.GlobalStatusBase;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import java.util.List;
import java.util.Locale;
import net.minecraft.util.text.TranslationTextComponent;

public abstract class Sport
extends GlobalStatusBase {
    protected transient PixelmonWrapper user;
    protected Element affectedType;
    private transient int turnsLeft;
    private String moveName;

    public Sport(PixelmonWrapper user, StatusType status, Element affectedType, String moveName) {
        super(status);
        this.user = user;
        this.affectedType = affectedType;
        this.turnsLeft = 5;
        this.moveName = moveName;
    }

    @Override
    public void applyEffect(PixelmonWrapper user, PixelmonWrapper target) {
        if (user.bc.globalStatusController.hasStatus(this.type)) {
            user.bc.sendToAll("pixelmon.effect.effectfailed", new Object[0]);
            user.attack.moveResult.result = AttackResult.failed;
        } else {
            user.bc.sendToAll("pixelmon.status.sport", this.affectedType.getLocalizedName());
            user.addGlobalStatus(this.getNewInstance(user));
        }
    }

    protected abstract Sport getNewInstance(PixelmonWrapper var1);

    @Override
    public int[] modifyPowerAndAccuracyTarget(int power, int accuracy, PixelmonWrapper user, PixelmonWrapper target, Attack a) {
        if (a.getType() == this.affectedType) {
            power /= 3;
        }
        return new int[]{power, accuracy};
    }

    @Override
    public void applyRepeatedEffect(GlobalStatusController gsc) {
        if (--this.turnsLeft <= 0) {
            gsc.removeGlobalStatus(this);
            gsc.bc.sendToAll("pixelmon.status.sportfade", new TranslationTextComponent("attack." + this.moveName.toLowerCase(Locale.ROOT).replace(" ", "_") + ""));
        }
    }

    @Override
    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, List<MoveChoice> userChoices, List<MoveChoice> bestUserChoices, List<MoveChoice> opponentChoices, List<MoveChoice> bestOpponentChoices) {
        if (MoveChoice.hasOffensiveAttackType(bestOpponentChoices, this.affectedType)) {
            userChoice.raiseWeight(20.0f);
        }
        if (MoveChoice.hasOffensiveAttackType(bestUserChoices, this.affectedType)) {
            userChoice.raiseWeight(-20.0f);
        }
    }
}

