/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.status;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.MagicGuard;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.battles.attacks.DamageTypeEnum;
import com.pixelmonmod.pixelmon.battles.attacks.ImmutableAttack;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusBase;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.enums.heldItems.EnumHeldItems;
import java.util.List;

public class PartialTrap
extends StatusBase {
    public transient ImmutableAttack variant;
    private transient int turnsToGo;
    private transient PixelmonWrapper trapper;

    public PartialTrap() {
        super(StatusType.PartialTrap);
    }

    public PartialTrap(ImmutableAttack variant, PixelmonWrapper trapper) {
        super(StatusType.PartialTrap);
        this.variant = variant;
        this.trapper = trapper;
        this.turnsToGo = trapper.getUsableHeldItem().getHeldItemType() == EnumHeldItems.gripClaw ? 7 : RandomHelper.getRandomNumberBetween(4, 5);
    }

    @Override
    public void applyEffect(PixelmonWrapper user, PixelmonWrapper target) {
        ImmutableAttack variant = user.attack.getMove();
        if (target.addStatus(new PartialTrap(variant, user), user)) {
            if (variant.isAttack(AttackRegistry.SAND_TOMB) || variant.isAttack(AttackRegistry.G_MAX_SANDBLAST)) {
                user.bc.sendToAll("pixelmon.effect.sandtomb", target.getNickname());
            } else if (variant.isAttack(AttackRegistry.CLAMP)) {
                user.bc.sendToAll("pixelmon.effect.clamped", user.getNickname(), target.getNickname());
            } else if (variant.isAttack(AttackRegistry.MAGMA_STORM)) {
                user.bc.sendToAll("pixelmon.effect.swirlingmagma", target.getNickname());
            } else if (variant.isAttack(AttackRegistry.FIRE_SPIN) || variant.isAttack(AttackRegistry.G_MAX_CENTIFERNO)) {
                user.bc.sendToAll("pixelmon.effect.firevortex", target.getNickname());
            } else if (variant.isAttack(AttackRegistry.BIND)) {
                user.bc.sendToAll("pixelmon.effect.squeezed", target.getNickname(), user.getNickname());
            } else if (variant.isAttack(AttackRegistry.WRAP)) {
                user.bc.sendToAll("pixelmon.effect.wrapped", target.getNickname(), user.getNickname());
            } else if (variant.isAttack(AttackRegistry.WHIRLPOOL)) {
                user.bc.sendToAll("pixelmon.effect.vortex", target.getNickname());
            } else if (variant.isAttack(AttackRegistry.SNAP_TRAP)) {
                user.bc.sendToAll("pixelmon.effect.snaptrap", target.getNickname());
            }
        }
    }

    @Override
    public boolean stopsSwitching() {
        return true;
    }

    @Override
    public void applyRepeatedEffect(PixelmonWrapper pw) {
        if (!(pw.bc.getActiveUnfaintedPokemon().contains(this.trapper) || this.variant.isAttack(AttackRegistry.G_MAX_SANDBLAST) || this.variant.isAttack(AttackRegistry.G_MAX_CENTIFERNO))) {
            pw.removeStatus(this);
            return;
        }
        if (--this.turnsToGo < 0) {
            pw.removeStatus(this);
            if (this.variant.isAttack(AttackRegistry.SAND_TOMB) || this.variant.isAttack(AttackRegistry.G_MAX_SANDBLAST)) {
                pw.bc.sendToAll("pixelmon.status.freefromsandtomb", pw.getNickname());
            } else if (this.variant.isAttack(AttackRegistry.CLAMP)) {
                pw.bc.sendToAll("pixelmon.status.freefromclamp", pw.getNickname());
            } else if (this.variant.isAttack(AttackRegistry.WHIRLPOOL)) {
                pw.bc.sendToAll("pixelmon.status.freefromwhirlpool", pw.getNickname());
            } else if (this.variant.isAttack(AttackRegistry.WRAP)) {
                pw.bc.sendToAll("pixelmon.status.freefromwrap", pw.getNickname());
            } else if (this.variant.isAttack(AttackRegistry.BIND)) {
                pw.bc.sendToAll("pixelmon.status.freefrombind", pw.getNickname());
            } else if (this.variant.isAttack(AttackRegistry.FIRE_SPIN) || this.variant.isAttack(AttackRegistry.G_MAX_CENTIFERNO)) {
                pw.bc.sendToAll("pixelmon.status.freefromfirespin", pw.getNickname());
            } else if (this.variant.isAttack(AttackRegistry.SNAP_TRAP)) {
                pw.bc.sendToAll("pixelmon.status.freefromsnaptrap", pw.getNickname());
            }
            return;
        }
        if (pw.getBattleAbility() instanceof MagicGuard) {
            return;
        }
        int fraction = this.trapper.getUsableHeldItem().getHeldItemType() == EnumHeldItems.bindingBand ? 6 : 8;
        pw.doBattleDamage(pw, pw.getPercentMaxHealth(100.0f / (float)fraction), DamageTypeEnum.STATUS);
        pw.bc.sendToAll("pixelmon.status.hurtby", pw.getNickname(), this.variant.getTranslatedName());
    }

    public int getRemainingTurns() {
        return this.turnsToGo;
    }

    @Override
    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, List<MoveChoice> userChoices, List<MoveChoice> bestUserChoices, List<MoveChoice> opponentChoices, List<MoveChoice> bestOpponentChoices) {
        if (userChoice.hitsAlly()) {
            return;
        }
        for (PixelmonWrapper target : userChoice.targets) {
            if (target.getBattleAbility() instanceof MagicGuard) {
                return;
            }
            float weight = 12.5f;
            if (pw.getUsableHeldItem().getHeldItemType() == EnumHeldItems.bindingBand) {
                weight *= 2.0f;
            }
            userChoice.raiseWeight(weight);
        }
    }
}

