/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.status;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusBase;
import com.pixelmonmod.pixelmon.battles.status.StatusType;

public class ObscuredStatus
extends StatusBase {
    private int turns;
    private int evasionDelta;

    public ObscuredStatus() {
        super(StatusType.Obscured);
    }

    public ObscuredStatus(int turns, int evasionDelta) {
        super(StatusType.Obscured);
        this.turns = turns;
        this.evasionDelta = evasionDelta;
    }

    @Override
    public void applyEffect(PixelmonWrapper user, PixelmonWrapper target) {
        int turns = 3;
        int evasionDelta = 1;
        if (user.attack.isAttack(AttackRegistry.ANCIENT_LUNAR_BLESSING, AttackRegistry.ANCIENT_SHELTER)) {
            turns = 4;
        } else if (user.attack.isAttack(AttackRegistry.ANCIENT_MUD_BOMB, AttackRegistry.ANCIENT_MUD_SLAP, AttackRegistry.ANCIENT_OCTAZOOKA, AttackRegistry.ANCIENT_SHADOW_FORCE)) {
            turns = 3;
        }
        if (user.addStatus(new ObscuredStatus(turns, evasionDelta), user)) {
            user.bc.sendToAll("pixelmon.status.obscured", user.getNickname());
            user.getBattleStats().increaseStat(this.evasionDelta, BattleStatsType.EVASION, user, false);
        }
    }

    @Override
    public void applyRepeatedEffect(PixelmonWrapper pw) {
        super.applyRepeatedEffect(pw);
        if (--this.turns <= 0) {
            pw.removeStatus(this);
            pw.bc.sendToAll("pixelmon.status.obscuredworeoff", pw.getNickname());
            pw.getBattleStats().decreaseStat(this.evasionDelta, BattleStatsType.EVASION, pw, false);
        }
    }
}

