/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.status;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.StatsEffect;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusBase;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import java.util.List;

public class Minimize
extends StatusBase {
    public Minimize() {
        super(StatusType.Minimize);
    }

    @Override
    public void applyEffect(PixelmonWrapper user, PixelmonWrapper target) {
        if (user.getBattleStats().modifyStat(2, BattleStatsType.EVASION) && !user.hasStatus(StatusType.Minimize)) {
            user.addStatus(new Minimize(), user);
        }
    }

    @Override
    public int[] modifyPowerAndAccuracyTarget(int power, int accuracy, PixelmonWrapper user, PixelmonWrapper target, Attack a) {
        if (a.isAttack(AttackRegistry.BODY_SLAM, AttackRegistry.DRAGON_RUSH, AttackRegistry.FLYING_PRESS, AttackRegistry.HEAT_CRASH, AttackRegistry.STEAMROLLER, AttackRegistry.STOMP, AttackRegistry.HEAVY_SLAM, AttackRegistry.MALICIOUS_MOONSAULT)) {
            power *= 2;
            accuracy = -1;
        }
        return new int[]{power, accuracy};
    }

    @Override
    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, List<MoveChoice> userChoices, List<MoveChoice> bestUserChoices, List<MoveChoice> opponentChoices, List<MoveChoice> bestOpponentChoices) {
        if (MoveChoice.hasMove(opponentChoices, AttackRegistry.BODY_SLAM, AttackRegistry.DRAGON_RUSH, AttackRegistry.FLYING_PRESS, AttackRegistry.HEAT_CRASH, AttackRegistry.STEAMROLLER, AttackRegistry.STOMP, AttackRegistry.HEAVY_SLAM, AttackRegistry.MALICIOUS_MOONSAULT)) {
            return;
        }
        StatsEffect statsEffect = new StatsEffect(BattleStatsType.EVASION, 2, true);
        statsEffect.weightEffect(pw, userChoice, userChoices, bestUserChoices, opponentChoices, bestOpponentChoices);
    }
}

