/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.status;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.ability.Ability;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.PoisonHeal;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.VoltAbsorb;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.WaterAbsorb;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.EffectBase;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.Drain;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.Recover;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.Synthesis;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.log.AttackResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusBase;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.enums.heldItems.EnumHeldItems;
import java.util.List;

public class HealBlock
extends StatusBase {
    transient int turnsLeft = 5;

    public HealBlock() {
        super(StatusType.HealBlock);
    }

    @Override
    public void applyEffect(PixelmonWrapper user, PixelmonWrapper target) {
        if (target.hasStatus(StatusType.HealBlock)) {
            user.bc.sendToAll("pixelmon.status.healblockalready", target.getNickname());
            user.attack.moveResult.result = AttackResult.failed;
        } else if (target.addTeamStatus(new HealBlock(), user)) {
            user.bc.sendToAll("pixelmon.status.healblock", target.getNickname());
        }
    }

    @Override
    public boolean isTeamStatus() {
        return true;
    }

    @Override
    public void applyRepeatedEffect(PixelmonWrapper pw) {
        if (--this.turnsLeft <= 0) {
            pw.bc.sendToAll("pixelmon.status.healblockend", pw.getNickname());
            pw.removeTeamStatus(this);
        }
    }

    @Override
    public StatusBase copy() {
        HealBlock copy = new HealBlock();
        copy.turnsLeft = this.turnsLeft;
        return copy;
    }

    @Override
    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, List<MoveChoice> userChoices, List<MoveChoice> bestUserChoices, List<MoveChoice> opponentChoices, List<MoveChoice> bestOpponentChoices) {
        boolean hasHeal = false;
        for (PixelmonWrapper target : pw.getOpponentPokemon()) {
            Ability ability = target.getBattleAbility();
            hasHeal = hasHeal || ability instanceof PoisonHeal || ability instanceof VoltAbsorb || ability instanceof WaterAbsorb;
            EnumHeldItems heldItem = target.getUsableHeldItem().getHeldItemType();
            hasHeal = hasHeal || heldItem == EnumHeldItems.leftovers || heldItem == EnumHeldItems.shellBell;
            List<Attack> moveset = pw.getBattleAI().getMoveset(target);
            hasHeal = hasHeal || Attack.hasAttack(moveset, AttackRegistry.AQUA_RING, AttackRegistry.INGRAIN, AttackRegistry.LEECH_SEED, AttackRegistry.REST, AttackRegistry.SWALLOW, AttackRegistry.WISH);
            for (Attack attack : moveset) {
                for (EffectBase effect : attack.getMove().effects) {
                    hasHeal = hasHeal || effect instanceof Drain || effect instanceof Recover || effect instanceof Synthesis;
                }
            }
        }
        if (hasHeal) {
            userChoice.raiseWeight(25.0f);
        }
    }
}

