/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.status;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.api.pokemon.ability.Ability;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.IceBody;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.MagicGuard;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.Overcoat;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.SnowCloak;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.DamageTypeEnum;
import com.pixelmonmod.pixelmon.battles.controller.BattleController;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusBase;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.battles.status.Weather;
import com.pixelmonmod.pixelmon.enums.heldItems.EnumHeldItems;
import java.util.List;

public class Hail
extends Weather {
    public Hail() {
        this(5);
    }

    public Hail(int turnsToGo) {
        super(StatusType.Hail, turnsToGo, EnumHeldItems.icyRock, "pixelmon.effect.starthail", "pixelmon.status.heavyhail", "pixelmon.status.hailstopped", false, false);
    }

    public Hail(int turnsToGo, boolean isOverworldWeather) {
        super(StatusType.Hail, turnsToGo, EnumHeldItems.icyRock, "pixelmon.effect.starthail", "pixelmon.status.heavyhail", "pixelmon.status.hailstopped", false, isOverworldWeather);
    }

    @Override
    protected Weather getNewInstance(int turns) {
        return new Hail(turns);
    }

    @Override
    public void applyRepeatedEffect(BattleController bc) {
        for (PixelmonWrapper p : bc.getDefaultTurnOrder()) {
            if (this.isImmune(p)) continue;
            p.bc.sendToAll("pixelmon.status.hurthail", p.getNickname());
            p.doBattleDamage(p, p.getPercentMaxHealth(6.25f), DamageTypeEnum.WEATHER);
        }
    }

    @Override
    public boolean isImmune(PixelmonWrapper p) {
        Ability ability = p.getBattleAbility();
        return p.hasType(Element.ICE) || p.isFainted() || ability instanceof MagicGuard || ability instanceof Overcoat || ability instanceof SnowCloak || ability instanceof IceBody || p.getUsableHeldItem().getHeldItemType() == EnumHeldItems.safetyGoggles;
    }

    @Override
    protected int countBenefits(PixelmonWrapper user, PixelmonWrapper target) {
        List<Attack> moveset;
        Ability ability;
        int benefits = 0;
        if (!this.isImmune(target)) {
            --benefits;
        }
        if ((ability = target.getBattleAbility()) instanceof IceBody || ability instanceof SnowCloak) {
            ++benefits;
        }
        if (Attack.hasAttack(moveset = user.getBattleAI().getMoveset(target), AttackRegistry.BLIZZARD, AttackRegistry.WEATHER_BALL)) {
            ++benefits;
        }
        if (Attack.hasAttack(moveset, AttackRegistry.SOLAR_BEAM)) {
            --benefits;
        }
        if (Attack.hasAttack(moveset, AttackRegistry.MOONLIGHT, AttackRegistry.MORNING_SUN, AttackRegistry.SYNTHESIS)) {
            --benefits;
        }
        return benefits;
    }

    @Override
    public StatusBase copy() {
        return new Hail(this.turnsToGo);
    }
}

