/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.status;

import com.pixelmonmod.pixelmon.api.battles.AttackCategory;
import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.api.pokemon.ability.Ability;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.MagicGuard;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.MarvelScale;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.QuickFeet;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.Synchronize;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.DamageTypeEnum;
import com.pixelmonmod.pixelmon.battles.attacks.EffectBase;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.Thaw;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.modifiers.ModifierBase;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.modifiers.ModifierType;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusPersist;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.TranslationTextComponent;

public class Frostbite
extends StatusPersist {
    private static final transient float AI_WEIGHT = 25.0f;

    public Frostbite() {
        super(StatusType.Frostbite);
    }

    @Override
    public void applyEffect(PixelmonWrapper user, PixelmonWrapper target) {
        if (user.bc.globalStatusController.hasStatus(StatusType.Hail)) {
            for (ModifierBase m : this.modifiers) {
                if (m.type != ModifierType.Chance) continue;
                m.multiplier = Float.valueOf(1.5f);
                break;
            }
        }
        if (this.checkChance()) {
            Frostbite.frostbite(user, target, user.attack, true);
        }
    }

    public static boolean frostbite(PixelmonWrapper user, PixelmonWrapper target, Attack attack, boolean showMessage) {
        boolean result;
        boolean isStatusMove;
        boolean bl = isStatusMove = attack != null && attack.getAttackCategory() == AttackCategory.STATUS;
        if (target.hasType(Element.ICE)) {
            if (showMessage && isStatusMove) {
                user.bc.sendToAll("pixelmon.battletext.noeffect", target.getNickname());
                user.setAttackFailed();
            }
            return false;
        }
        if (target.hasNonVolatileStatus()) {
            if (showMessage && isStatusMove) {
                user.bc.sendToAll("pixelmon.effect.effectfailed", new Object[0]);
                user.setAttackFailed();
            }
            return false;
        }
        TranslationTextComponent message = null;
        if (showMessage) {
            message = ChatHandler.getMessage("pixelmon.effect.frostbitten", target.getNickname());
        }
        if (!(result = target.addStatus(new Frostbite(), user, message)) && isStatusMove) {
            user.setAttackFailed();
        }
        return result;
    }

    @Override
    public boolean canAttackThisTurn(PixelmonWrapper user, Attack a) {
        for (int i = 0; i < a.getMove().effects.size(); ++i) {
            EffectBase e = a.getMove().effects.get(i);
            if (!(e instanceof Thaw)) continue;
            user.removeStatus(this);
            return true;
        }
        return true;
    }

    @Override
    public void applyRepeatedEffect(PixelmonWrapper pw) {
        Ability userAbility = pw.getBattleAbility();
        if (!(userAbility instanceof MagicGuard)) {
            pw.bc.sendToAll("pixelmon.status.frostbitehurt", pw.getNickname());
            int fraction = 16;
            pw.doBattleDamage(pw, pw.getPercentMaxHealth(100.0f / (float)fraction), DamageTypeEnum.STATUS);
        }
    }

    @Override
    public StatusPersist restoreFromNBT(CompoundNBT nbt) {
        return new Frostbite();
    }

    @Override
    public int[] modifyPowerAndAccuracyUser(int power, int accuracy, PixelmonWrapper user, PixelmonWrapper target, Attack attack) {
        if (attack.getAttackCategory() == AttackCategory.SPECIAL) {
            return new int[]{(int)Math.ceil((float)power / 2.0f), accuracy};
        }
        return new int[]{power, accuracy};
    }

    @Override
    public boolean isImmune(PixelmonWrapper pokemon) {
        return pokemon.hasType(Element.ICE);
    }

    @Override
    public String getCureMessage() {
        return "pixelmon.status.frostbitecure";
    }

    @Override
    public String getCureMessageItem() {
        return "pixelmon.status.frostbitecureitem";
    }

    @Override
    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, List<MoveChoice> userChoices, List<MoveChoice> bestUserChoices, List<MoveChoice> opponentChoices, List<MoveChoice> bestOpponentChoices) {
        boolean offensive = userChoice.isOffensiveMove();
        float weight = this.getWeightWithChance(25.0f);
        if (!offensive || userChoice.isMiddleTier()) {
            boolean hitsAlly = userChoice.hitsAlly();
            if (offensive && hitsAlly) {
                return;
            }
            ArrayList<PixelmonWrapper> opponents = pw.getOpponentPokemon();
            for (PixelmonWrapper target : userChoice.targets) {
                boolean beneficial;
                if (offensive && !Frostbite.frostbite(pw, target, userChoice.attack, false)) continue;
                Ability ability = target.getBattleAbility();
                boolean bl = beneficial = ability instanceof MarvelScale || ability instanceof QuickFeet;
                if (beneficial && hitsAlly) {
                    if (target.getMoveset().hasAttackCategory(AttackCategory.SPECIAL)) continue;
                    userChoice.raiseWeight(weight);
                    continue;
                }
                if (beneficial ^ hitsAlly) {
                    userChoice.raiseWeight(-weight);
                    continue;
                }
                if (ability instanceof Synchronize) continue;
                pw.getBattleAI().weightStatusOpponentOptions(pw, userChoice, target, new Frostbite(), opponents, bestOpponentChoices);
                if (ability instanceof MagicGuard) continue;
                userChoice.raiseWeight(weight);
            }
        }
    }
}

