/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.controller.participants;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.battles.AttackCategory;
import com.pixelmonmod.pixelmon.api.battles.BattleEndCause;
import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.events.raids.EndRaidEvent;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.boss.BossTier;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.pokemon.stats.PermanentStats;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.DamageTypeEnum;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.OHKO;
import com.pixelmonmod.pixelmon.battles.controller.BattleController;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.ai.RaidAI;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.ParticipantType;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.battles.raids.RaidData;
import com.pixelmonmod.pixelmon.battles.raids.RaidGovernor;
import com.pixelmonmod.pixelmon.battles.raids.RaidSettings;
import com.pixelmonmod.pixelmon.battles.status.GastroAcid;
import com.pixelmonmod.pixelmon.battles.status.LightScreen;
import com.pixelmonmod.pixelmon.battles.status.Reflect;
import com.pixelmonmod.pixelmon.battles.status.StatusBase;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.battles.tasks.HPUpdateTask;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.eventbus.api.Event;

public class RaidPixelmonParticipant
extends BattleParticipant {
    private final RaidData raid;
    private final RaidGovernor governor;
    private RaidAI ai;
    private static int idCounter = 0;
    private PixelmonWrapper lastPokemonThatHitShields;
    private boolean justTransformed = false;
    private static final Set<StatusType> BLOCKED_STATUSES = new HashSet<StatusType>(Arrays.asList(StatusType.Poison, StatusType.PoisonBadly, StatusType.Burn, StatusType.Sleep, StatusType.Paralysis, StatusType.Yawn, StatusType.Freeze, StatusType.Confusion, StatusType.Infatuated));

    @Deprecated
    public RaidPixelmonParticipant(RaidData raid, RaidSettings settings, PixelmonEntity pixelmon) {
        super(1);
        this.raid = raid;
        this.governor = new RaidGovernor(settings);
        this.init(pixelmon);
    }

    public RaidPixelmonParticipant(RaidData raid, RaidSettings settings, Pokemon pokemon) {
        super(1);
        this.raid = raid;
        this.governor = new RaidGovernor(settings);
        this.init(pokemon);
    }

    public PixelmonWrapper getWrapper() {
        return (PixelmonWrapper)this.controlledPokemon.get(0);
    }

    private void init(PixelmonEntity pixelmon) {
        this.governor.init(pixelmon);
        PixelmonWrapper pw = new PixelmonWrapper((BattleParticipant)this, pixelmon, 0);
        this.allPokemon = new PixelmonWrapper[]{pw};
        this.controlledPokemon.add(pw);
    }

    private void init(Pokemon pokemon) {
        this.governor.init(pokemon);
        PixelmonWrapper pw = new PixelmonWrapper((BattleParticipant)this, pokemon, 0);
        this.allPokemon = new PixelmonWrapper[]{pw};
        this.controlledPokemon.add(pw);
    }

    @Override
    public ParticipantType getType() {
        return ParticipantType.RaidPokemon;
    }

    @Override
    public boolean hasMorePokemon() {
        return this.countAblePokemon() == 1;
    }

    @Override
    public boolean hasMorePokemonReserve() {
        return false;
    }

    @Override
    public boolean canGainXP() {
        return false;
    }

    @Override
    public void startBattle() {
        BossTier bossTier;
        super.startBattle();
        PixelmonWrapper pw = this.getWrapper();
        if (pw.entity != null) {
            pw.entity.field_70714_bg.func_220880_a(Goal.Flag.MOVE);
            pw.entity.field_70714_bg.func_220880_a(Goal.Flag.JUMP);
            pw.entity.field_70714_bg.func_220880_a(Goal.Flag.TARGET);
            pw.entity.func_184646_p(0.0f);
            pw.entity.func_191989_p(0.0f);
            pw.entity.func_70657_f(0.0f);
            pw.entity.field_70160_al = true;
            pw.entity.func_70661_as().func_75499_g();
        }
        if ((bossTier = this.governor.bossTier) != null && bossTier.isBoss()) {
            int lvl = 1;
            for (BattleParticipant p : this.bc.participants) {
                if (p.team == this.team || !(p instanceof PlayerParticipant)) continue;
                int highestLevel = ((PlayerParticipant)p).getHighestLevel();
                lvl = Math.max(lvl, highestLevel);
            }
            lvl = (int)((double)lvl * bossTier.getLevelMultiplier());
            PermanentStats stats = pw.getStats();
            stats.getIVs().maximizeIVs();
            stats.getEVs().randomizeMaxEVs();
            pw.setTempLevel(lvl += bossTier.getExtraLevels());
        }
        pw.setHealth(pw.getMaxHealth());
        pw.getMoveset().forEach(attack -> {
            if (attack != null) {
                attack.pp = attack.getMaxPP();
            }
        });
        pw.onBattlefield = true;
        this.setDynamax(pw);
        this.ai = new RaidAI(this.governor, this);
        this.setBattleAI(this.ai);
        this.governor.cycleDynamax(this);
        this.bc.sendHealPacket(this.getWrapper(), this.getWrapper().getMaxHealth());
    }

    private void setDynamax(PixelmonWrapper pw) {
        if (this.governor.isGigantamax()) {
            pw.setPrevPaletteName(pw.pokemon.getPalette().getName());
            pw.setPrevForm(pw.getForm());
            pw.getForm().getGigantamaxForm().ifPresent(pw::setForm);
            pw.isDynamax = 2;
        } else {
            pw.isDynamax = 1;
        }
        pw.dynamaxTurns = Integer.MAX_VALUE;
        pw.dynamaxAnimationTicks = 50;
        this.dynamax = pw.getPokemonUUID();
        pw.updateHPIncrease();
        pw.setHealth(pw.getMaxHealth());
        pw.update(EnumUpdateType.ALL);
    }

    @Override
    public void endBattle(BattleEndCause cause) {
        Pixelmon.EVENT_BUS.post((Event)new EndRaidEvent(this.raid, this.governor, this.bc.getOpponents(this), this, this.isDefeated));
        if (this.isDefeated) {
            for (RaidData.RaidPlayer rp : this.raid.getPlayers()) {
                rp.winRaid(this, this.raid, this.governor);
            }
        } else if (this.getEntity() != null && !this.getEntity().func_130014_f_().field_72995_K) {
            this.raid.getDenEntity(this.getEntity().func_130014_f_()).ifPresent(den -> {
                if (!den.func_130014_f_().field_72995_K) {
                    double radius = 3.0;
                    ServerWorld world = (ServerWorld)den.func_130014_f_();
                    world.func_184133_a(null, den.func_233580_cy_(), SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 4.0f, (1.0f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
                    for (int i = 0; i < 200; ++i) {
                        Vector3d sphere = RandomHelper.nextSpherePoint(radius);
                        world.func_195598_a((IParticleData)ParticleTypes.field_197594_E, den.func_226277_ct_() + sphere.field_72450_a, den.func_226278_cu_() + world.field_73012_v.nextDouble() * radius * 2.0, den.func_226281_cx_() + sphere.field_72449_c, 1, world.field_73012_v.nextDouble() * 2.0 - 1.0, world.field_73012_v.nextDouble() * 2.0 - 1.0, world.field_73012_v.nextDouble() * 2.0 - 1.0, world.field_73012_v.nextDouble() * 0.5);
                    }
                }
            });
        }
        for (PixelmonWrapper pw : this.controlledPokemon) {
            if (pw.entity == null) continue;
            pw.entity.onEndBattle();
            pw.entity.func_241204_bJ_();
        }
        for (RaidData.RaidPlayer raidPlayer : this.raid.getPlayers()) {
            if (raidPlayer.playerEntity == null) continue;
            this.raid.getDenEntity(raidPlayer.playerEntity.func_130014_f_()).ifPresent(den -> {
                if (den.func_70090_H()) {
                    for (RaidData.RaidPlayer rp : this.raid.getPlayers()) {
                        if (!rp.isPlayer()) continue;
                        rp.playerEntity.func_195064_c(new EffectInstance(Effects.field_76427_o, 400, 2));
                        rp.playerEntity.func_195064_c(new EffectInstance(Effects.field_206827_D, 400, 2));
                    }
                }
            });
        }
    }

    private boolean shouldDespawn() {
        return true;
    }

    @Override
    public void getNextPokemon(int position) {
    }

    @Override
    public UUID getNextPokemonUUID() {
        return null;
    }

    @Override
    public TextComponent getName() {
        String key = "";
        if (!this.controlledPokemon.isEmpty()) {
            key = "pixelmon." + ((PixelmonWrapper)this.controlledPokemon.get((int)0)).pokemon.getLocalizedName().toLowerCase(Locale.ROOT) + ".name";
        }
        return new TranslationTextComponent(key);
    }

    @Override
    public MoveChoice getMove(PixelmonWrapper pw) {
        if (this.bc == null) {
            return null;
        }
        if (!pw.getMoveset().isEmpty()) {
            return this.getBattleAI().getNextMove(pw);
        }
        this.bc.setFlee(pw.getPokemonUUID());
        return null;
    }

    @Override
    public PixelmonWrapper switchPokemon(PixelmonWrapper pw, UUID newPixelmonUUID) {
        return null;
    }

    @Override
    public boolean checkPokemon() {
        boolean allGood = true;
        for (PixelmonWrapper pw : this.controlledPokemon) {
            if (!pw.getMoveset().isEmpty()) continue;
            pw.pokemon.getMoveset().clear();
            pw.pokemon.getMoveset().addAll(pw.pokemon.getForm().getMoves().loadMoveset(pw.getPokemonLevelNum()));
            if (!pw.getMoveset().isEmpty()) continue;
            if (PixelmonConfigProxy.getGeneral().getDebug().isPrintErrors()) {
                Pixelmon.LOGGER.info("Couldn't load " + pw.pokemon.getLocalizedName() + "'s moves.");
            }
            allGood = false;
        }
        return allGood;
    }

    @Override
    public void updatePokemon(PixelmonWrapper pw) {
    }

    @Override
    public LivingEntity getEntity() {
        if (this.controlledPokemon.isEmpty()) {
            return null;
        }
        return ((PixelmonWrapper)this.controlledPokemon.get((int)0)).entity;
    }

    @Override
    public void updateOtherPokemon() {
    }

    @Override
    public boolean canDynamax() {
        return true;
    }

    @Override
    public String getDisplayName() {
        Iterator iterator = this.controlledPokemon.iterator();
        if (iterator.hasNext()) {
            PixelmonWrapper pw = (PixelmonWrapper)iterator.next();
            return pw.getNickname();
        }
        return super.getDisplayName();
    }

    public boolean areShieldsUp() {
        return this.governor.shields > 0;
    }

    @Override
    public void onSwitchIn(BattleController bc, PixelmonWrapper pw) {
        this.setDynamax(pw);
    }

    @Override
    public void onEndTurn(BattleController bc) {
        if (!bc.simulateMode && this.isAlive() && !this.governor.done) {
            float hp = this.getWrapper().getHealthPercent();
            if (hp < 50.0f && this.governor.previousTurnHP >= 50.0f && !this.governor.desperate) {
                this.governor.desperate = true;
                bc.sendToAll("raid.desperate", this.getDisplayName());
            }
            if (this.governor.incrementTurnCounter(bc)) {
                this.governor.done = true;
                bc.sendToAll("raid.storm.c", new Object[0]);
                bc.sendToAll("raid.blowout", new Object[0]);
                bc.endBattle();
                return;
            }
            this.tryShields();
            this.lastPokemonThatHitShields = null;
            this.governor.previousTurnHP = this.getWrapper().getHealthPercent();
            int i = 0;
            for (BattleParticipant bp : this.bc.getOpponents(this)) {
                if (this.governor.isKnockedOut(i) && this.governor.tryRevive(i)) {
                    bp.isDefeated = false;
                    bp.allPokemon[0].healByPercent(100.0f);
                    String name = bp.getDisplayName();
                    bc.sendToAll("raid.recover", name);
                    this.bc.reviveAfterDefeat(bp);
                }
                if (bp.dynamax != null) {
                    this.governor.onDynamax();
                }
                ++i;
            }
            this.governor.cycleDynamax(this);
        }
    }

    @Override
    public boolean onTakeTurn(BattleController bc, PixelmonWrapper pw) {
        if (this.governor.done || bc.simulateMode) {
            return false;
        }
        int i = 0;
        for (BattleParticipant bp : this.bc.getOpponents(this)) {
            if (this.governor.canCheer(i)) {
                this.tryCheer(bp);
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean onUseAttack(BattleController bc, PixelmonWrapper pw) {
        if (this.isAlive() && !this.governor.done && !bc.simulateMode) {
            if (this.governor.tryShockwave(pw.hasNonVolatileStatus(false))) {
                this.shockwave(pw);
            }
            this.doAttacks(pw, this.governor.getAttacksPerTurn(), false);
        }
        return true;
    }

    private void doAttacks(PixelmonWrapper pw, int attacks, boolean hasTransformed) {
        if (attacks <= 0) {
            return;
        }
        List<MoveChoice> choices = this.ai.getTopNAttackChoices(attacks, pw);
        Collections.shuffle(choices);
        for (MoveChoice choice : choices) {
            if (pw.hasStatus(StatusType.Sleep)) {
                this.bc.sendToAll("pixelmon.status.stillsleeping", this.getDisplayName());
                continue;
            }
            pw.chooseMove(choice);
            pw.useAttack(false);
            if (hasTransformed || !this.justTransformed) continue;
            this.justTransformed = false;
            this.doAttacks(pw, attacks - 1, true);
            break;
        }
    }

    @Override
    public void onUseAttackPost(BattleController bc, PixelmonWrapper pw) {
        if (pw.attack.isAttack(AttackRegistry.TRANSFORM)) {
            this.governor.settings.rerollMoveset(pw.pokemon);
            this.justTransformed = true;
        }
    }

    @Override
    public boolean onUseAttackOther(BattleController bc, Attack attack, BattleParticipant bp, PixelmonWrapper user) {
        boolean fail = attack.isAttack(AttackRegistry.BUG_BITE, AttackRegistry.CURSE, AttackRegistry.DESTINY_BOND, AttackRegistry.EXPLOSION, AttackRegistry.INCINERATE, AttackRegistry.KNOCK_OFF, AttackRegistry.PERISH_SONG, AttackRegistry.PLUCK, AttackRegistry.SELF_DESTRUCT, AttackRegistry.SELF_DESTRUCT, AttackRegistry.SUPER_FANG);
        boolean ohko = attack.getActualMove().hasEffect(OHKO.class);
        if (ohko && this.areShieldsUp() && bp != this) {
            bc.sendToAll("pixelmon.battletext.used", user.getNickname(), attack.getMove().getTranslatedName());
            this.governor.shields -= 2;
            bc.sendToAll("raid.ohko", new Object[0]);
            if (this.governor.shields <= 0) {
                bc.sendToAll("raid.barrier.destroy", this.getDisplayName());
            }
            this.getWrapper().updateRaidShields(this.governor.shields);
        } else if (ohko || fail) {
            bc.sendToAll("pixelmon.battletext.used", user.getNickname(), attack.getMove().getTranslatedName());
            bc.sendToAll("pixelmon.effect.effectfailed", new Object[0]);
        }
        return fail || ohko;
    }

    public void shockwave(PixelmonWrapper pw) {
        if (this.governor.done || this.bc.simulateMode) {
            return;
        }
        this.bc.sendToAll("raid.shockwave", this.getDisplayName());
        for (PixelmonWrapper opw : this.bc.getOpponentPokemon(this)) {
            opw.addStatus(new GastroAcid(), pw);
            opw.getBattleStats().clearBattleStats();
        }
        pw.clearStatus();
    }

    @Override
    public boolean onTargeted(PixelmonWrapper user, Attack attack) {
        return !this.governor.done && this.areShieldsUp() && attack.getMove().getAttackCategory() == AttackCategory.STATUS;
    }

    @Override
    public boolean onAddStatus(BattleController bc, PixelmonWrapper user, PixelmonWrapper target, StatusBase status) {
        return this.areShieldsUp() && BLOCKED_STATUSES.contains(status.type);
    }

    @Override
    public float onHit(PixelmonWrapper source, float damage, DamageTypeEnum damageType) {
        if (this.governor.done || this.bc.simulateMode) {
            return damage;
        }
        if (this.isAlive()) {
            float hp;
            if (this.areShieldsUp() && damageType == DamageTypeEnum.ATTACK) {
                damage = Math.max(0.0f, damage * 0.1f - 10.0f);
                if (this.lastPokemonThatHitShields == null || this.lastPokemonThatHitShields != source) {
                    --this.governor.shields;
                }
                if (this.governor.shields > 0 && source.attack != null && source.attack.isMax) {
                    --this.governor.shields;
                    this.bc.sendToAll("raid.ohko", new Object[0]);
                }
                if (this.governor.shields <= 0) {
                    this.bc.sendToAll("raid.barrier.destroy", this.getDisplayName());
                }
                this.getWrapper().updateRaidShields(this.governor.shields);
                this.lastPokemonThatHitShields = source;
            }
            if ((hp = this.getWrapper().getHealthPercent((float)this.getWrapper().getHealth() - damage)) <= this.governor.shieldHPBound) {
                this.governor.shouldRaiseShields = true;
            }
            if (this.tryShields()) {
                int hpNow = this.getWrapper().getHealth();
                float bound = (float)(this.governor.shieldUses + 1) * this.governor.shieldHPPercent;
                int newHp = this.getWrapper().getPercentMaxHealth(bound);
                if (newHp < hpNow) {
                    this.getWrapper().setHealth(newHp);
                    this.bc.sendToPlayers(new HPUpdateTask(this.getWrapper(), newHp - hpNow));
                }
                damage = 0.0f;
            }
        }
        return damage;
    }

    private boolean tryShields() {
        if (this.governor.done || this.bc.simulateMode) {
            return false;
        }
        if (this.governor.shouldRaiseShields && this.governor.shields == 0 && this.governor.raiseShields()) {
            this.getWrapper().setRaidShields(this.governor.shields);
            this.bc.sendToAll("raid.barrier", this.getDisplayName());
            return true;
        }
        return false;
    }

    private void tryCheer(BattleParticipant cheerer) {
        if (this.governor.done || this.bc.simulateMode) {
            return;
        }
        this.bc.sendToAll("raid.cheer", cheerer.getDisplayName());
        if (this.governor.tryCheer()) {
            int effect = RandomHelper.rand.nextInt(6);
            PixelmonWrapper pw = cheerer.allPokemon[0];
            boolean success = false;
            switch (effect) {
                case 0: {
                    if (!new Reflect().apply(pw, false)) break;
                    success = true;
                    break;
                }
                case 1: {
                    if (!new LightScreen().apply(pw, false)) break;
                    success = true;
                    break;
                }
                case 2: {
                    if (this.governor.shields <= 0) break;
                    this.governor.shields = 0;
                    this.bc.sendToAll("raid.barrier.destroy", this.getDisplayName());
                    this.getWrapper().updateRaidShields(this.governor.shields);
                    success = true;
                    break;
                }
                case 3: {
                    BattleStatsType stat = BattleStatsType.getRandomBattleMutableStat();
                    for (PixelmonWrapper ally : this.bc.getTeamPokemon(pw)) {
                        ally.getBattleStats().increaseStat(1, stat, pw, false);
                    }
                    success = true;
                    break;
                }
                case 4: {
                    for (PixelmonWrapper ally : this.bc.getTeamPokemon(pw)) {
                        if (ally.removePrimaryStatus(true) == null) continue;
                        success = true;
                    }
                    break;
                }
                case 5: {
                    float hp = 100.0f;
                    PixelmonWrapper toHeal = null;
                    for (PixelmonWrapper ally : this.bc.getTeamPokemon(pw)) {
                        float ahp = ally.getHealthPercent();
                        if (ally.isFainted() || !(ahp < 100.0f) || !(ahp < hp)) continue;
                        hp = ahp;
                        toHeal = ally;
                    }
                    if (toHeal == null) break;
                    toHeal.healByPercent(100.0f);
                    this.getWrapper().updateHPIncrease();
                    this.bc.sendToAll("pixelmon.effect.washealed", toHeal.getNickname());
                    success = true;
                }
            }
            if (success) {
                String name = cheerer.getDisplayName();
                this.bc.sendToAll("raid.cheer.success", name);
            } else {
                this.bc.sendToAll("raid.cheer.fail", new Object[0]);
            }
        } else {
            this.bc.sendToAll("raid.cheer.fail", new Object[0]);
        }
    }

    @Override
    public void onOpponentKO(BattleController bc, PixelmonWrapper pw) {
        if (this.governor.done || bc.simulateMode) {
            return;
        }
        if (this.isAlive()) {
            int i = 0;
            for (BattleParticipant bp : this.bc.getOpponents(this)) {
                if (bp.allPokemon[0] == pw) {
                    this.governor.knockout(i);
                    if (pw.isDynamax <= 0) break;
                    pw.dynamax(true, pw.getHealthPercent());
                    break;
                }
                ++i;
            }
            ++this.governor.kills;
            if (this.governor.kills >= this.governor.getLives()) {
                this.governor.done = true;
                bc.sendToAll("raid.blowout", new Object[0]);
                bc.endBattle();
            } else {
                int message = this.governor.getLives() - this.governor.kills;
                switch (message) {
                    case 1: {
                        bc.sendToAll("raid.storm.c", new Object[0]);
                        break;
                    }
                    case 2: {
                        bc.sendToAll("raid.storm.b", new Object[0]);
                        break;
                    }
                    default: {
                        bc.sendToAll("raid.storm.a", new Object[0]);
                    }
                }
            }
        }
    }

    public boolean canDynamax(BattleParticipant participant) {
        return !this.governor.done && !this.governor.hasDynamaxOccured && this.governor.dynamaxIndex == this.getOpponents().indexOf(participant);
    }

    public boolean isAlive() {
        return this.allPokemon[0].isAlive();
    }

    public RaidGovernor getGovernor() {
        return this.governor;
    }
}

