/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic;

import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.SpecialAttackBase;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.log.AttackResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.battles.status.Stockpile;
import java.util.List;

public class Swallow
extends SpecialAttackBase {
    @Override
    public AttackResult applyEffectDuring(PixelmonWrapper user, PixelmonWrapper target) {
        Stockpile stockpile = (Stockpile)user.getStatus(StatusType.Stockpile);
        if (stockpile == null || user.hasStatus(StatusType.HealBlock)) {
            user.bc.sendToAll("pixelmon.effect.effectfailed", new Object[0]);
            return AttackResult.failed;
        }
        if (user.hasFullHealth()) {
            user.bc.sendToAll("pixelmon.effect.healfailed", user.getNickname());
            return AttackResult.failed;
        }
        user.healEntityBy(this.getHealAmount(user, stockpile));
        user.bc.sendToAll("pixelmon.effect.washealed", target.getNickname());
        stockpile.removeStockpile(user);
        return AttackResult.succeeded;
    }

    private int getHealAmount(PixelmonWrapper user, Stockpile stockpile) {
        return user.getPercentMaxHealth(100.0f / (float)(1 << 3 - stockpile.numStockpiles));
    }

    @Override
    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, List<MoveChoice> userChoices, List<MoveChoice> bestUserChoices, List<MoveChoice> opponentChoices, List<MoveChoice> bestOpponentChoices) {
        Stockpile stockpile = (Stockpile)pw.getStatus(StatusType.Stockpile);
        if (stockpile != null) {
            float heal = Math.min(this.getHealAmount(pw, stockpile), pw.getHealthDeficit());
            userChoice.raiseWeight(pw.getHealthPercent(heal));
        }
    }
}

