/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic;

import com.pixelmonmod.pixelmon.api.battles.AttackCategory;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.SpecialAttackBase;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.log.AttackResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.Focus;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import java.util.List;

public class FocusPunch
extends SpecialAttackBase {
    @Override
    public AttackResult applyEffectDuring(PixelmonWrapper user, PixelmonWrapper target) {
        if (user.hasStatus(StatusType.Focus) || user.bc.simulateMode) {
            user.bc.sendToAll("pixelmon.battletext.used", user.getNickname(), user.attack.getMove().getTranslatedName());
            user.removeStatus(StatusType.Focus);
            return AttackResult.proceed;
        }
        user.bc.sendToAll("pixelmon.effect.lostfocus", user.getNickname());
        return AttackResult.failed;
    }

    @Override
    public void applyEarlyEffect(PixelmonWrapper user) {
        user.bc.sendToAll("pixelmon.effect.focuspunch", user.getNickname());
        user.addStatus(new Focus(), user);
    }

    @Override
    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, List<MoveChoice> userChoices, List<MoveChoice> bestUserChoices, List<MoveChoice> opponentChoices, List<MoveChoice> bestOpponentChoices) {
        if (pw.hasStatus(StatusType.Substitute)) {
            return;
        }
        for (PixelmonWrapper opponent : pw.getOpponentPokemon()) {
            if (opponent.lastAttack == null || opponent.lastAttack.moveResult.target != pw || opponent.lastAttack.getAttackCategory() == AttackCategory.STATUS) continue;
            userChoice.lowerTier(2);
            userChoice.weight = 0.0f;
        }
    }
}

