/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.attacks.animations.particles;

import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.battles.attacks.animations.particles.AttackEffectContract;
import com.pixelmonmod.pixelmon.client.particle.ParticleArcanery;
import com.pixelmonmod.pixelmon.client.particle.ParticleMathHelper;
import com.pixelmonmod.pixelmon.client.particle.ParticleSystem;
import com.pixelmonmod.pixelmon.client.particle.particles.AttackEffect;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class AttackSwarm
extends ParticleSystem
implements AttackEffectContract {
    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void execute(Minecraft mc, World w, double x, double y, double z, float scale, boolean shiny, double ... args) {
        int power = (int)args[0];
        int accuracy = (int)args[1];
        Element type = Element.values()[(int)args[2]];
        int category = (int)args[3];
        double endX = args[4];
        double endY = args[5];
        double endZ = args[6];
        int startID = (int)args[7];
        int endID = (int)args[8];
        for (int i = 0; i < power + 5; ++i) {
        }
    }

    @Override
    public void onConstruct(AttackEffect effect) {
        effect.maxAge = 30 - effect.hiddenUntil;
    }

    @Override
    public void onInit(ParticleArcanery particle, AttackEffect effect) {
        Vector3d vec = ParticleMathHelper.generatePointInSphere(0.2, RandomHelper.getRandom());
        particle.setMotion(effect.mX + vec.field_72450_a, effect.mY + vec.field_72448_b, effect.mZ + vec.field_72449_c);
    }

    @Override
    public void onEnable(ParticleArcanery particle, AttackEffect effect) {
        Entity start = effect.mc.field_71441_e.func_73045_a(effect.startID);
        Entity end = effect.mc.field_71441_e.func_73045_a(effect.endID);
        if (start != null) {
            effect.startX = start.func_226277_ct_() + (start.func_174813_aQ().field_72336_d - start.func_174813_aQ().field_72340_a) / 2.0;
            effect.startY = start.func_226278_cu_() + (start.func_174813_aQ().field_72337_e - start.func_174813_aQ().field_72338_b) / 2.0;
            effect.startZ = start.func_226281_cx_() + (start.func_174813_aQ().field_72334_f - start.func_174813_aQ().field_72339_c) / 2.0;
        }
        if (end != null) {
            effect.endX = end.func_226277_ct_() + (end.func_174813_aQ().field_72336_d - end.func_174813_aQ().field_72340_a) / 2.0;
            effect.endY = end.func_226278_cu_() + (end.func_174813_aQ().field_72337_e - end.func_174813_aQ().field_72338_b) / 2.0;
            effect.endZ = end.func_226281_cx_() + (end.func_174813_aQ().field_72334_f - end.func_174813_aQ().field_72339_c) / 2.0;
        }
        effect.setHeading();
        particle.func_187109_b(effect.startX, effect.startY, effect.startZ);
        particle.setPrevPos(effect.startX, effect.startY, effect.startZ);
        particle.setMotion(effect.mX, effect.mY, effect.mZ);
    }

    @Override
    public void onUpdateEol(ParticleArcanery particle, AttackEffect effect) {
        double ageLeft = 1.0 - (double)(particle.getAge() / Math.max(particle.func_206254_h(), 1));
        double eolRadius = 0.7 * ageLeft;
        Vector3d vec = ParticleMathHelper.generatePointInSphere(eolRadius, RandomHelper.getRandom());
        particle.setMotion(effect.mX + vec.field_72450_a, effect.mY + vec.field_72448_b, effect.mZ + vec.field_72449_c);
        particle.setRGBA(particle.getRedColorF(), particle.getGreenColorF(), particle.getBlueColorF(), particle.getAlphaF() * 0.95f);
    }

    @Override
    public void onUpdateLast(ParticleArcanery particle, AttackEffect effect) {
        if (!effect.eol) {
            Vector3d vec = ParticleMathHelper.generatePointInSphere(0.7, RandomHelper.getRandom());
            particle.setMotion(effect.mX + vec.field_72450_a, effect.mY + vec.field_72448_b, effect.mZ + vec.field_72449_c);
        }
    }
}

