/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.attacks.animations.particles;

import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.battles.attacks.animations.particles.AttackEffectContract;
import com.pixelmonmod.pixelmon.client.particle.ParticleArcanery;
import com.pixelmonmod.pixelmon.client.particle.ParticleSystem;
import com.pixelmonmod.pixelmon.client.particle.particles.AttackEffect;
import net.minecraft.client.Minecraft;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class AttackShield
extends ParticleSystem
implements AttackEffectContract {
    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void execute(Minecraft mc, World w, double x, double y, double z, float scale, boolean shiny, double ... args) {
        int power = (int)args[0];
        int accuracy = (int)args[1];
        Element type = Element.values()[(int)args[2]];
        int category = (int)args[3];
        double endX = args[4];
        double endY = args[5];
        double endZ = args[6];
        int startID = (int)args[7];
        int endID = (int)args[8];
        double dX = endX - x;
        double dY = endY - y;
        double dZ = endZ - z;
        double distanceFactor = 1.0 / Math.sqrt(dX * dX + dY * dY + dZ * dZ);
        dY *= distanceFactor;
        double rotateBy = Math.asin((dX *= distanceFactor) / (dZ *= distanceFactor));
        if (dZ == 0.0) {
            rotateBy = 0.0;
        }
        int totalPoints = 32;
        for (int i = 0; i < totalPoints; ++i) {
            double theta = Math.PI * 2 / (double)totalPoints;
            double angle = theta * (double)i;
            double dx = Math.cos(angle);
            double dy = Math.sin(angle);
            int delay = 0;
            for (double r = 0.75; r > 0.0; r -= 0.075) {
                double pX = x + (x + dx * r + dX - x) * Math.cos(rotateBy) + (z + dZ - z) * Math.sin(rotateBy);
                double pZ = z - (x + dx * r + dX - x) * Math.sin(rotateBy) + (z + dZ - z) * Math.cos(rotateBy);
                ++delay;
            }
        }
    }

    @Override
    public void onConstruct(AttackEffect effect) {
        effect.maxAge = 35;
    }

    @Override
    public void onInit(ParticleArcanery particle, AttackEffect effect) {
        particle.setRGBA(effect.r, effect.g, effect.b, 0.0f);
        particle.setMotion(0.0, 0.0, 0.0);
        effect.mX = 0.0;
        effect.mY = 0.0;
        effect.mZ = 0.0;
    }

    @Override
    public void onUpdate(ParticleArcanery particle, AttackEffect effect) {
        ++effect.age;
        particle.setRGBA(effect.r, effect.g, effect.b, particle.getAlphaF() + 0.01f);
        if (effect.age >= effect.maxAge) {
            particle.func_187112_i();
        }
    }

    @Override
    public void onUpdateEol(ParticleArcanery particle, AttackEffect effect) {
        particle.setRGBA(particle.getRedColorF(), particle.getGreenColorF(), particle.getBlueColorF(), particle.getAlphaF() * 0.95f);
    }
}

