/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.api.rules.clauses.tiers;

import com.google.common.collect.Sets;
import com.pixelmonmod.api.pokemon.PokemonSpecification;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.battles.api.rules.clauses.BattleClause;
import java.util.Arrays;
import java.util.Set;

public class Tier
extends BattleClause {
    protected final Set<PokemonSpecification> specs = Sets.newConcurrentHashSet();
    protected final boolean ban;

    public Tier(String id, boolean ban, PokemonSpecification ... spec) {
        super(id);
        this.ban = ban;
        this.specs.addAll(Arrays.asList(spec));
    }

    @Override
    public boolean validateSingle(Pokemon pokemon) {
        for (PokemonSpecification spec : this.specs) {
            if (spec.matches(pokemon)) {
                if (!this.ban) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public String getTierDescription() {
        return this.getLocalizedName();
    }
}

