/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.util.helpers;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.ServerWorldInfo;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber(modid="pixelmon", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class WorldHelper {
    private static final Map<String, Map<Pair<Integer, Integer>, List<StructureStart<?>>>> STRUCTURES = Maps.newConcurrentMap();
    private static final Map<String, Structure<?>> CACHED_STRUCTURES = Maps.newConcurrentMap();

    public static Optional<World> findLevel(String name) {
        for (ServerWorld allLevel : ServerLifecycleHooks.getCurrentServer().func_212370_w()) {
            if (!((ServerWorldInfo)allLevel.func_72912_H()).func_76065_j().equalsIgnoreCase(name)) continue;
            return Optional.ofNullable(allLevel);
        }
        return Optional.empty();
    }

    public static <T extends Entity> T getEntityByUUID(ServerWorld world, UUID uuid, Class<T> clazz) {
        return (T)world.func_217461_a(uuid);
    }

    public static int getWaterDepth(BlockPos pos, World worldObj) {
        int count = 0;
        while (worldObj.func_180495_p(pos).func_177230_c() == Blocks.field_150355_j || worldObj.func_180495_p(pos).func_177230_c() == Blocks.field_150353_l) {
            pos = pos.func_177984_a();
            ++count;
        }
        return count;
    }

    public static void spawnRedstoneParticle(World world, double posX, double posY, double posZ, double r, double g, double b) {
        world.func_195594_a((IParticleData)new RedstoneParticleData((float)r, (float)g, (float)b, 1.0f), posX, posY, posZ, 0.0, 0.0, 0.0);
    }

    @Nullable
    public static RayTraceResult rayTraceEyes(LivingEntity entity, double length) {
        Vector3d startPos = new Vector3d(entity.func_226277_ct_(), entity.func_226280_cw_(), entity.func_226281_cx_());
        Vector3d endPos = startPos.func_178787_e(new Vector3d(entity.func_70040_Z().field_72450_a * length, entity.func_70040_Z().field_72448_b * length, entity.func_70040_Z().field_72449_c * length));
        return entity.field_70170_p.func_217299_a(new RayTraceContext(startPos, endPos, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.ANY, (Entity)entity));
    }

    public static boolean insideStructure(ServerWorld world, String structure, BlockPos pos) {
        Structure value = CACHED_STRUCTURES.computeIfAbsent(structure.toLowerCase(Locale.ROOT), s -> (Structure)Structure.field_236365_a_.get((Object)structure));
        if (value == null) {
            return false;
        }
        int chunkX = pos.func_177958_n() >> 4;
        int chunkZ = pos.func_177952_p() >> 4;
        Map dimensionStructures = STRUCTURES.computeIfAbsent(world.func_234923_W_().func_240901_a_().toString(), unused -> Maps.newHashMap());
        List structureStarts = (List)dimensionStructures.get(Pair.of((Object)chunkX, (Object)chunkZ));
        if (structureStarts == null || structureStarts.isEmpty()) {
            return false;
        }
        for (StructureStart structureStart : structureStarts) {
            if (!Objects.equals(structureStart.func_214627_k(), value) || !structureStart.func_75071_a().func_175898_b((Vector3i)pos)) continue;
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public static void onLoad(ChunkEvent.Load event) {
        if (!(event.getWorld() instanceof ServerWorld)) {
            return;
        }
        if (event.getChunk().func_201609_c().isEmpty()) {
            return;
        }
        Map dimensionStructures = STRUCTURES.computeIfAbsent(((ServerWorld)event.getWorld()).func_234923_W_().func_240901_a_().toString(), unused -> Maps.newHashMap());
        List structureStarts = dimensionStructures.computeIfAbsent(Pair.of((Object)event.getChunk().func_76632_l().field_77276_a, (Object)event.getChunk().func_76632_l().field_77275_b), ___ -> Lists.newCopyOnWriteArrayList());
        structureStarts.addAll(event.getChunk().func_201609_c().values());
    }

    @SubscribeEvent
    public static void onUnload(ChunkEvent.Unload event) {
        if (!(event.getWorld() instanceof ServerWorld)) {
            return;
        }
        Map dimensionStructures = STRUCTURES.computeIfAbsent(((ServerWorld)event.getWorld()).func_234923_W_().func_240901_a_().toString(), unused -> Maps.newHashMap());
        dimensionStructures.remove(Pair.of((Object)event.getChunk().func_76632_l().field_77276_a, (Object)event.getChunk().func_76632_l().field_77275_b));
    }
}

