/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.util.helpers;

import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector4f;

public class VectorHelper {
    static final Vector3f X_AXIS = new Vector3f(1.0f, 0.0f, 0.0f);
    static final Vector3f Y_AXIS = new Vector3f(0.0f, 1.0f, 0.0f);
    static final Vector3f Z_AXIS = new Vector3f(0.0f, 0.0f, 1.0f);

    public static double[] rotate(double x, double y, double radians) {
        double cos = Math.cos(radians);
        double sin = Math.sin(radians);
        double newX = x * cos - y * sin;
        double newY = y * cos + x * sin;
        return new double[]{newX, newY};
    }

    public static Matrix4f matrix4FromLocRot(float xl, float yl, float zl, float xr, float yr, float zr) {
        Vector3f loc = new Vector3f(xl, yl, zl);
        com.pixelmonmod.pixelmon.tools.Matrix4f part1 = new com.pixelmonmod.pixelmon.tools.Matrix4f();
        part1.translate(loc);
        part1.rotate(zr, Z_AXIS);
        part1.rotate(yr, Y_AXIS);
        part1.rotate(xr, X_AXIS);
        return part1.toVanilla();
    }

    public static Matrix4f matrix4FromFloatArray(float[] vals) {
        return VectorHelper.matrix4FromLocRot(vals[0], vals[1], vals[2], vals[3], vals[4], vals[5]);
    }

    public static Matrix4f matrix4fFromFloat(float val) {
        return VectorHelper.matrix4FromLocRot(val, val, val, val, val, val);
    }

    public static Vector4f mul(Vector4f target, float factor, Vector4f dest) {
        if (dest == null) {
            dest = new Vector4f();
        }
        dest.setX(target.func_195910_a() * factor);
        dest.setY(target.func_195913_b() * factor);
        dest.setZ(target.func_195914_c() * factor);
        dest.setW(target.func_195915_d() * factor);
        return dest;
    }

    public static Matrix4f mul(Matrix4f target, float factor, Matrix4f dest) {
        if (dest == null) {
            dest = new Matrix4f();
        }
        target.func_226592_a_(factor);
        dest.func_226595_a_(target);
        return target;
    }

    public static Vector3f getInverse(Vector3f target) {
        return new Vector3f(-target.func_195899_a(), -target.func_195900_b(), -target.func_195902_c());
    }

    public static Vector3f Vector3dfFromStrings(String x, String y, String z) {
        float xl = Float.parseFloat(x);
        float yl = Float.parseFloat(y);
        float zl = Float.parseFloat(z);
        return new Vector3f(xl, yl, zl);
    }

    public static Vector4f copyVector4f(Vector4f src) {
        return new Vector4f(src.func_195910_a(), src.func_195913_b(), src.func_195914_c(), src.func_195915_d());
    }

    public static Vector3f crossProduct(Vector3f one, Vector3f two) {
        float f = one.func_195899_a();
        float f1 = one.func_195900_b();
        float f2 = one.func_195902_c();
        float f3 = two.func_195899_a();
        float f4 = two.func_195900_b();
        float f5 = two.func_195902_c();
        return new Vector3f(f1 * f5 - f2 * f4, f2 * f3 - f * f5, f * f4 - f1 * f3);
    }
}

