/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.util;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ThreadPool {
    private final ScheduledThreadPoolExecutor pool;

    private ThreadPool(String modid, int size) {
        this.pool = (ScheduledThreadPoolExecutor)Executors.newScheduledThreadPool(size, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("pixelmon_spawning_%d").build());
    }

    public static ThreadPool createNewThreadPool(String name, int size) {
        return new ThreadPool(name, size);
    }

    public void setSize(int size) {
        this.pool.setCorePoolSize(size);
    }

    public ScheduledFuture<?> submit(Runnable runnable) {
        return (ScheduledFuture)this.pool.submit(runnable);
    }

    public ScheduledFuture<?> schedule(Runnable runnable, long delay) {
        return this.schedule(runnable, delay, TimeUnit.MILLISECONDS);
    }

    public ScheduledFuture<?> schedule(Runnable runnable, long delay, TimeUnit timeUnit) {
        return this.pool.schedule(runnable, delay, timeUnit);
    }

    public ScheduledFuture<?> scheduleAtFixedRate(Runnable runnable, long delay, long period) {
        return this.scheduleAtFixedRate(runnable, delay, period, TimeUnit.SECONDS);
    }

    public ScheduledFuture<?> scheduleAtFixedRate(Runnable runnable, long delay, long period, TimeUnit timeUnit) {
        return this.pool.scheduleAtFixedRate(runnable, delay, period, timeUnit);
    }

    public ScheduledFuture<?> repeatUntilComplete(Callable<Boolean> task, long period) {
        return this.repeatUntilComplete(task, period, TimeUnit.MILLISECONDS);
    }

    public ScheduledFuture<?> repeatUntilComplete(Callable<Boolean> task, long period, TimeUnit timeUnit) {
        return this.schedule(() -> {
            try {
                if (!((Boolean)task.call()).booleanValue()) {
                    this.repeatUntilComplete(task, period, timeUnit);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }, period, timeUnit);
    }
}

