/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.notexamples;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.api.battles.BattleType;
import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.events.battles.BattleTickEvent;
import com.pixelmonmod.pixelmon.api.events.battles.TurnEndEvent;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonBuilder;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.api.test.UnitTest;
import com.pixelmonmod.pixelmon.battles.api.BattleBuilder;
import com.pixelmonmod.pixelmon.battles.api.rules.BattleRuleRegistry;
import com.pixelmonmod.pixelmon.battles.api.rules.BattleRules;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.controller.ai.NoOpAI;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.controller.participants.WildPixelmonParticipant;
import com.pixelmonmod.pixelmon.enums.EnumOldGenMode;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class OpportunistTest {
    private OpportunistTest() {
        throw new UnsupportedOperationException("Unit test");
    }

    @UnitTest(value="espathra_all_the_way_down")
    public static CompletableFuture<TestResult> testOpportunistDoesNotCopyOpportunist() {
        Attack ddance = AttackRegistry.DRAGON_DANCE.get().ofMutable();
        Attack splash = AttackRegistry.SPLASH.get().ofMutable();
        WildPixelmonParticipant magikarpOne = OpportunistTest.createMagikarp();
        WildPixelmonParticipant magikarpTwo = OpportunistTest.createMagikarp();
        return ((CompletableFuture)BattleBuilder.builder().frozen().rules(new BattleRules(BattleType.SINGLE).set(BattleRuleRegistry.GEN_MODE, (Object)EnumOldGenMode.Both)).teamOne(magikarpOne).teamTwo(magikarpTwo).start().thenCompose(controller -> {
            magikarpOne.asWrapper().setAttack(ddance, (List<PixelmonWrapper>)Lists.newArrayList((Object[])new PixelmonWrapper[]{magikarpOne.asWrapper()}), false);
            magikarpTwo.asWrapper().setAttack(splash, (List<PixelmonWrapper>)Lists.newArrayList((Object[])new PixelmonWrapper[]{magikarpOne.asWrapper()}), false);
            magikarpOne.asWrapper().takeTurn();
            magikarpTwo.asWrapper().takeTurn();
            controller.addTaskAtEvent(BattleTickEvent.Pre.class, (pre, bc) -> controller.endTurn());
            return controller.addFunctionAtEvent(TurnEndEvent.class, (turnEndEvent, bc) -> bc);
        })).thenApply(controller -> {
            if (magikarpTwo.asWrapper().getBattleStats().getStage(BattleStatsType.ATTACK) != 1) {
                return TestResult.failure("The Opportunist did not activate.");
            }
            if (magikarpOne.asWrapper().getBattleStats().getStage(BattleStatsType.ATTACK) != 1) {
                return TestResult.failure("The Opportunist copied Opportunist.");
            }
            return TestResult.success();
        });
    }

    private static WildPixelmonParticipant createMagikarp() {
        WildPixelmonParticipant participant = new WildPixelmonParticipant(PokemonBuilder.builder().species(PixelmonSpecies.ESPATHRA.getValue()).ability(AbilityRegistry.OPPORTUNIST.get()).build());
        participant.setBattleAI(new NoOpAI(participant));
        return participant;
    }
}

